/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProviderLocal;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.macosx.MacOSXLibrary;

public final class CL {
    @Nullable
    private static FunctionProviderLocal functionProvider;
    @Nullable
    private static CLCapabilities icd;

    private CL() {
    }

    public static void create() {
        SharedLibrary CL2;
        switch (Platform.get()) {
            case LINUX: 
            case WINDOWS: {
                CL2 = Library.loadNative(CL.class, Configuration.OPENCL_LIBRARY_NAME, "OpenCL");
                break;
            }
            case MACOSX: {
                CL2 = Configuration.OPENCL_LIBRARY_NAME.get() != null ? Library.loadNative(CL.class, Configuration.OPENCL_LIBRARY_NAME, new String[0]) : MacOSXLibrary.getWithIdentifier("com.apple.opencl");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        CL.create(CL2);
    }

    public static void create(String libName) {
        CL.create(Library.loadNative(CL.class, libName));
    }

    private static void create(SharedLibrary OPENCL) {
        try {
            CL.create(new SharedLibraryCL(OPENCL));
        }
        catch (RuntimeException e) {
            OPENCL.free();
            throw e;
        }
    }

    public static void create(FunctionProviderLocal functionProvider) {
        if (CL.functionProvider != null) {
            throw new IllegalStateException("OpenCL has already been created.");
        }
        CL.functionProvider = functionProvider;
        icd = new CLCapabilities(functionProvider, Collections.emptySet());
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        if (functionProvider instanceof NativeResource) {
            ((NativeResource)((Object)functionProvider)).free();
        }
        functionProvider = null;
        icd = null;
    }

    @Nullable
    public static FunctionProviderLocal getFunctionProvider() {
        return functionProvider;
    }

    @Nullable
    public static CLCapabilities getICD() {
        return icd;
    }

    public static CLCapabilities createPlatformCapabilities(long cl_platform_id) {
        HashSet<String> supportedExtensions = new HashSet<String>(32);
        CL.addExtensions(CL.getPlatformInfoStringASCII(cl_platform_id, 2308), supportedExtensions);
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pi = stack.mallocInt(1);
            CL.checkCLError(CL10.nclGetDeviceIDs(cl_platform_id, -1L, 0, 0L, MemoryUtil.memAddress(pi)));
            int num_devices = pi.get(0);
            if (num_devices != 0) {
                PointerBuffer pp = stack.mallocPointer(num_devices);
                CL.checkCLError(CL10.nclGetDeviceIDs(cl_platform_id, -1L, num_devices, MemoryUtil.memAddress(pp), 0L));
                for (int i = 0; i < num_devices; ++i) {
                    String extensionsString = CL.getDeviceInfoStringASCII(pp.get(i), 4144);
                    CL.addExtensions(extensionsString, supportedExtensions);
                }
            }
        }
        APIUtil.APIVersion version = APIUtil.apiParseVersion(CL.getPlatformInfoStringASCII(cl_platform_id, 2305), "OpenCL");
        CL.addCLVersions(version.major, version.minor, supportedExtensions);
        return new CLCapabilities(functionName -> CL.getFunctionProvider().getFunctionAddress(cl_platform_id, functionName), supportedExtensions);
    }

    public static CLCapabilities createDeviceCapabilities(long cl_device_id, CLCapabilities platformCapabilities) {
        HashSet<String> supportedExtensions = new HashSet<String>(32);
        String extensionsString = CL.getDeviceInfoStringASCII(cl_device_id, 4144);
        CL.addExtensions(extensionsString, supportedExtensions);
        APIUtil.APIVersion version = APIUtil.apiParseVersion(CL.getDeviceInfoStringASCII(cl_device_id, 4143), "OpenCL");
        CL.addCLVersions(version.major, version.minor, supportedExtensions);
        return new CLCapabilities(platformCapabilities, supportedExtensions);
    }

    static void addExtensions(String extensionsString, Set<String> supportedExtensions) {
        StringTokenizer tokenizer = new StringTokenizer(extensionsString);
        while (tokenizer.hasMoreTokens()) {
            supportedExtensions.add(tokenizer.nextToken());
        }
    }

    static void addCLVersions(int MAJOR, int MINOR, Set<String> supportedExtensions) {
        CL.addCLVersions(MAJOR, MINOR, supportedExtensions, "", new int[][]{{0, 1, 2}, {0, 1, 2}});
        if (supportedExtensions.contains("cl_khr_gl_sharing") || supportedExtensions.contains("cl_APPLE_gl_sharing")) {
            CL.addCLVersions(MAJOR, MINOR, supportedExtensions, "GL", new int[][]{{0, 2}, new int[0]});
        }
    }

    private static void addCLVersions(int MAJOR, int MINOR, Set<String> supportedExtensions, String postfix, int[][] versions) {
        block0: for (int major = 1; major <= Math.min(MAJOR, versions.length); ++major) {
            for (int minor : versions[major - 1]) {
                if (major == MAJOR && MINOR < minor) continue block0;
                supportedExtensions.add(String.format("OpenCL%d%d%s", major, minor, postfix));
            }
        }
    }

    static boolean checkExtension(String extension, boolean supported) {
        if (supported) {
            return true;
        }
        APIUtil.apiLog("[CL] " + extension + " was reported as available but an entry point is missing.");
        return false;
    }

    private static String getPlatformInfoStringASCII(long cl_platform_id, int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            CL.checkCLError(CL10.clGetPlatformInfo(cl_platform_id, param_name, (ByteBuffer)null, pp));
            int bytes = (int)pp.get(0);
            ByteBuffer buffer = stack.malloc(bytes);
            CL.checkCLError(CL10.clGetPlatformInfo(cl_platform_id, param_name, buffer, null));
            String string = MemoryUtil.memASCII(buffer, bytes - 1);
            return string;
        }
    }

    private static String getDeviceInfoStringASCII(long cl_device_id, int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            CL.checkCLError(CL10.clGetDeviceInfo(cl_device_id, param_name, (ByteBuffer)null, pp));
            int bytes = (int)pp.get(0);
            ByteBuffer buffer = stack.malloc(bytes);
            CL.checkCLError(CL10.clGetDeviceInfo(cl_device_id, param_name, buffer, null));
            String string = MemoryUtil.memASCII(buffer, bytes - 1);
            return string;
        }
    }

    private static void checkCLError(int errcode) {
        if (errcode != 0) {
            throw new RuntimeException(String.format("OpenCL error [%d]", errcode));
        }
    }

    static {
        if (!Configuration.OPENCL_EXPLICIT_INIT.get(false).booleanValue()) {
            CL.create();
        }
    }

    private static class SharedLibraryCL
    extends SharedLibrary.Delegate
    implements FunctionProviderLocal {
        private final long clGetExtensionFunctionAddress;
        private final long clGetExtensionFunctionAddressForPlatform;
        private final long platform;

        SharedLibraryCL(SharedLibrary library) {
            super(library);
            this.clGetExtensionFunctionAddress = library.getFunctionAddress("clGetExtensionFunctionAddress");
            this.clGetExtensionFunctionAddressForPlatform = library.getFunctionAddress("clGetExtensionFunctionAddressForPlatform");
            if (this.clGetExtensionFunctionAddress == 0L && this.clGetExtensionFunctionAddressForPlatform == 0L) {
                throw new IllegalStateException("A core OpenCL function is missing. Make sure that OpenCL is available.");
            }
            long platform = 0L;
            if (this.clGetExtensionFunctionAddressForPlatform != 0L) {
                long clGetPlatformIDs = library.getFunctionAddress("clGetPlatformIDs");
                if (clGetPlatformIDs == 0L) {
                    throw new IllegalStateException("A core OpenCL function is missing. Make sure that OpenCL is available.");
                }
                try (MemoryStack stack = MemoryStack.stackPush();){
                    IntBuffer pi = stack.ints(0);
                    JNI.callPPI(clGetPlatformIDs, 0, 0L, MemoryUtil.memAddress(pi));
                    int platforms = pi.get(0);
                    if (platforms == 1) {
                        PointerBuffer pp = stack.pointers(0L);
                        JNI.callPPI(clGetPlatformIDs, 1, MemoryUtil.memAddress(pp), 0L);
                        long cl_platform_id = pp.get(0);
                        if (this.supportsOpenCL12(stack, cl_platform_id)) {
                            platform = cl_platform_id;
                        }
                    } else if (this.clGetExtensionFunctionAddress == 0L) {
                        throw new IllegalStateException();
                    }
                }
            }
            this.platform = platform;
        }

        private boolean supportsOpenCL12(MemoryStack stack, long platform) {
            ByteBuffer version;
            long clGetPlatformInfo = this.library.getFunctionAddress("clGetPlatformInfo");
            if (clGetPlatformInfo == 0L) {
                return false;
            }
            PointerBuffer pp = stack.mallocPointer(1);
            int errcode = JNI.callPPPPI(clGetPlatformInfo, platform, 2305, 0L, 0L, MemoryUtil.memAddress(pp));
            if (errcode != 0) {
                return false;
            }
            int bytes = (int)pp.get(0);
            errcode = JNI.callPPPPI(clGetPlatformInfo, platform, 2305, (long)bytes, MemoryUtil.memAddress(version = stack.malloc(bytes)), 0L);
            if (errcode != 0) {
                return false;
            }
            APIUtil.APIVersion apiVersion = APIUtil.apiParseVersion(MemoryUtil.memASCII(version, bytes - 1), "OpenCL");
            return 1 < apiVersion.major || 2 <= apiVersion.minor;
        }

        @Override
        public long getFunctionAddress(ByteBuffer functionName) {
            long address;
            long nameEncoded = MemoryUtil.memAddress(functionName);
            long l = address = this.platform == 0L ? JNI.callPP(this.clGetExtensionFunctionAddress, nameEncoded) : JNI.callPPP(this.clGetExtensionFunctionAddressForPlatform, this.platform, nameEncoded);
            if (address == 0L && (address = this.library.getFunctionAddress(functionName)) == 0L && Checks.DEBUG_FUNCTIONS) {
                APIUtil.apiLog("Failed to locate address for CL function " + MemoryUtil.memASCII(functionName));
            }
            return address;
        }

        @Override
        public long getFunctionAddress(long handle, ByteBuffer functionName) {
            long address = JNI.callPPP(this.clGetExtensionFunctionAddressForPlatform, handle, MemoryUtil.memAddress(functionName));
            return address != 0L ? address : this.getFunctionAddress(functionName);
        }
    }
}

