/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.odbc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class DBMONEY
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNYHIGH;
    public static final int MNYLOW;

    DBMONEY(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public DBMONEY(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), DBMONEY.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LONG")
    public int mnyhigh() {
        return DBMONEY.nmnyhigh(this.address());
    }

    @NativeType(value="ULONG")
    public int mnylow() {
        return DBMONEY.nmnylow(this.address());
    }

    public DBMONEY mnyhigh(@NativeType(value="LONG") int value) {
        DBMONEY.nmnyhigh(this.address(), value);
        return this;
    }

    public DBMONEY mnylow(@NativeType(value="ULONG") int value) {
        DBMONEY.nmnylow(this.address(), value);
        return this;
    }

    public DBMONEY set(int mnyhigh, int mnylow) {
        this.mnyhigh(mnyhigh);
        this.mnylow(mnylow);
        return this;
    }

    public DBMONEY set(DBMONEY src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static DBMONEY malloc() {
        return DBMONEY.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static DBMONEY calloc() {
        return DBMONEY.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static DBMONEY create() {
        return new DBMONEY(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static DBMONEY create(long address) {
        return new DBMONEY(address, null);
    }

    @Nullable
    public static DBMONEY createSafe(long address) {
        return address == 0L ? null : DBMONEY.create(address);
    }

    public static Buffer malloc(int capacity) {
        return DBMONEY.create(DBMONEY.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return DBMONEY.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(DBMONEY.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : DBMONEY.create(address, capacity);
    }

    public static DBMONEY mallocStack() {
        return DBMONEY.mallocStack(MemoryStack.stackGet());
    }

    public static DBMONEY callocStack() {
        return DBMONEY.callocStack(MemoryStack.stackGet());
    }

    public static DBMONEY mallocStack(MemoryStack stack) {
        return DBMONEY.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static DBMONEY callocStack(MemoryStack stack) {
        return DBMONEY.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return DBMONEY.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return DBMONEY.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return DBMONEY.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return DBMONEY.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmnyhigh(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNYHIGH);
    }

    public static int nmnylow(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNYLOW);
    }

    public static void nmnyhigh(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNYHIGH, value);
    }

    public static void nmnylow(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNYLOW, value);
    }

    static {
        Struct.Layout layout = DBMONEY.__struct(DBMONEY.__member(4), DBMONEY.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNYHIGH = layout.offsetof(0);
        MNYLOW = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<DBMONEY, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected DBMONEY newInstance(long address) {
            return new DBMONEY(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="LONG")
        public int mnyhigh() {
            return DBMONEY.nmnyhigh(this.address());
        }

        @NativeType(value="ULONG")
        public int mnylow() {
            return DBMONEY.nmnylow(this.address());
        }

        public Buffer mnyhigh(@NativeType(value="LONG") int value) {
            DBMONEY.nmnyhigh(this.address(), value);
            return this;
        }

        public Buffer mnylow(@NativeType(value="ULONG") int value) {
            DBMONEY.nmnylow(this.address(), value);
            return this;
        }
    }
}

