/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.odbc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class DBDATETIME
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DTDAYS;
    public static final int DTTIME;

    DBDATETIME(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public DBDATETIME(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), DBDATETIME.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LONG")
    public int dtdays() {
        return DBDATETIME.ndtdays(this.address());
    }

    @NativeType(value="ULONG")
    public int dttime() {
        return DBDATETIME.ndttime(this.address());
    }

    public DBDATETIME dtdays(@NativeType(value="LONG") int value) {
        DBDATETIME.ndtdays(this.address(), value);
        return this;
    }

    public DBDATETIME dttime(@NativeType(value="ULONG") int value) {
        DBDATETIME.ndttime(this.address(), value);
        return this;
    }

    public DBDATETIME set(int dtdays, int dttime) {
        this.dtdays(dtdays);
        this.dttime(dttime);
        return this;
    }

    public DBDATETIME set(DBDATETIME src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static DBDATETIME malloc() {
        return DBDATETIME.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static DBDATETIME calloc() {
        return DBDATETIME.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static DBDATETIME create() {
        return new DBDATETIME(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static DBDATETIME create(long address) {
        return new DBDATETIME(address, null);
    }

    @Nullable
    public static DBDATETIME createSafe(long address) {
        return address == 0L ? null : DBDATETIME.create(address);
    }

    public static Buffer malloc(int capacity) {
        return DBDATETIME.create(DBDATETIME.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return DBDATETIME.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(DBDATETIME.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : DBDATETIME.create(address, capacity);
    }

    public static DBDATETIME mallocStack() {
        return DBDATETIME.mallocStack(MemoryStack.stackGet());
    }

    public static DBDATETIME callocStack() {
        return DBDATETIME.callocStack(MemoryStack.stackGet());
    }

    public static DBDATETIME mallocStack(MemoryStack stack) {
        return DBDATETIME.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static DBDATETIME callocStack(MemoryStack stack) {
        return DBDATETIME.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return DBDATETIME.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return DBDATETIME.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return DBDATETIME.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return DBDATETIME.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ndtdays(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DTDAYS);
    }

    public static int ndttime(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DTTIME);
    }

    public static void ndtdays(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DTDAYS, value);
    }

    public static void ndttime(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DTTIME, value);
    }

    static {
        Struct.Layout layout = DBDATETIME.__struct(DBDATETIME.__member(4), DBDATETIME.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DTDAYS = layout.offsetof(0);
        DTTIME = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<DBDATETIME, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected DBDATETIME newInstance(long address) {
            return new DBDATETIME(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="LONG")
        public int dtdays() {
            return DBDATETIME.ndtdays(this.address());
        }

        @NativeType(value="ULONG")
        public int dttime() {
            return DBDATETIME.ndttime(this.address());
        }

        public Buffer dtdays(@NativeType(value="LONG") int value) {
            DBDATETIME.ndtdays(this.address(), value);
            return this;
        }

        public Buffer dttime(@NativeType(value="ULONG") int value) {
            DBDATETIME.ndttime(this.address(), value);
            return this;
        }
    }
}

