/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="union nk_style_item_data")
public class NkStyleItemData
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int IMAGE;
    public static final int COLOR;

    NkStyleItemData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public NkStyleItemData(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkStyleItemData.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_image")
    public NkImage image() {
        return NkStyleItemData.nimage(this.address());
    }

    public NkStyleItemData image(Consumer<NkImage> consumer) {
        consumer.accept(this.image());
        return this;
    }

    @NativeType(value="struct nk_color")
    public NkColor color() {
        return NkStyleItemData.ncolor(this.address());
    }

    public NkStyleItemData color(Consumer<NkColor> consumer) {
        consumer.accept(this.color());
        return this;
    }

    public NkStyleItemData image(@NativeType(value="struct nk_image") NkImage value) {
        NkStyleItemData.nimage(this.address(), value);
        return this;
    }

    public NkStyleItemData color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleItemData.ncolor(this.address(), value);
        return this;
    }

    public NkStyleItemData set(NkStyleItemData src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyleItemData malloc() {
        return NkStyleItemData.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NkStyleItemData calloc() {
        return NkStyleItemData.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NkStyleItemData create() {
        return new NkStyleItemData(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkStyleItemData create(long address) {
        return new NkStyleItemData(address, null);
    }

    @Nullable
    public static NkStyleItemData createSafe(long address) {
        return address == 0L ? null : NkStyleItemData.create(address);
    }

    public static Buffer malloc(int capacity) {
        return NkStyleItemData.create(NkStyleItemData.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkStyleItemData.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(NkStyleItemData.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkStyleItemData.create(address, capacity);
    }

    public static NkStyleItemData mallocStack() {
        return NkStyleItemData.mallocStack(MemoryStack.stackGet());
    }

    public static NkStyleItemData callocStack() {
        return NkStyleItemData.callocStack(MemoryStack.stackGet());
    }

    public static NkStyleItemData mallocStack(MemoryStack stack) {
        return NkStyleItemData.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStyleItemData callocStack(MemoryStack stack) {
        return NkStyleItemData.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkStyleItemData.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkStyleItemData.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleItemData.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleItemData.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkImage nimage(long struct) {
        return NkImage.create(struct + (long)IMAGE);
    }

    public static NkColor ncolor(long struct) {
        return NkColor.create(struct + (long)COLOR);
    }

    public static void nimage(long struct, NkImage value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGE, NkImage.SIZEOF);
    }

    public static void ncolor(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)COLOR, NkColor.SIZEOF);
    }

    static {
        Struct.Layout layout = NkStyleItemData.__union(NkStyleItemData.__member(NkImage.SIZEOF, NkImage.ALIGNOF), NkStyleItemData.__member(NkColor.SIZEOF, NkColor.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        IMAGE = layout.offsetof(0);
        COLOR = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkStyleItemData, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkStyleItemData newInstance(long address) {
            return new NkStyleItemData(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="struct nk_image")
        public NkImage image() {
            return NkStyleItemData.nimage(this.address());
        }

        public Buffer image(Consumer<NkImage> consumer) {
            consumer.accept(this.image());
            return this;
        }

        @NativeType(value="struct nk_color")
        public NkColor color() {
            return NkStyleItemData.ncolor(this.address());
        }

        public Buffer color(Consumer<NkColor> consumer) {
            consumer.accept(this.color());
            return this;
        }

        public Buffer image(@NativeType(value="struct nk_image") NkImage value) {
            NkStyleItemData.nimage(this.address(), value);
            return this;
        }

        public Buffer color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleItemData.ncolor(this.address(), value);
            return this;
        }
    }
}

