/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_key")
public class NkKey
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DOWN;
    public static final int CLICKED;

    NkKey(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public NkKey(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkKey.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int down() {
        return NkKey.ndown(this.address());
    }

    @NativeType(value="unsigned int")
    public int clicked() {
        return NkKey.nclicked(this.address());
    }

    public static NkKey create(long address) {
        return new NkKey(address, null);
    }

    @Nullable
    public static NkKey createSafe(long address) {
        return address == 0L ? null : NkKey.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkKey.create(address, capacity);
    }

    public static int ndown(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DOWN);
    }

    public static int nclicked(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CLICKED);
    }

    static {
        Struct.Layout layout = NkKey.__struct(NkKey.__member(4), NkKey.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DOWN = layout.offsetof(0);
        CLICKED = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkKey, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkKey newInstance(long address) {
            return new NkKey(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public int down() {
            return NkKey.ndown(this.address());
        }

        @NativeType(value="unsigned int")
        public int clicked() {
            return NkKey.nclicked(this.address());
        }
    }
}

