/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkKeyboard;
import org.lwjgl.nuklear.NkMouse;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_input")
public class NkInput
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int KEYBOARD;
    public static final int MOUSE;

    NkInput(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public NkInput(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkInput.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_keyboard")
    public NkKeyboard keyboard() {
        return NkInput.nkeyboard(this.address());
    }

    @NativeType(value="struct nk_mouse")
    public NkMouse mouse() {
        return NkInput.nmouse(this.address());
    }

    public static NkInput malloc() {
        return NkInput.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NkInput calloc() {
        return NkInput.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NkInput create() {
        return new NkInput(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkInput create(long address) {
        return new NkInput(address, null);
    }

    @Nullable
    public static NkInput createSafe(long address) {
        return address == 0L ? null : NkInput.create(address);
    }

    public static Buffer malloc(int capacity) {
        return NkInput.create(NkInput.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkInput.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(NkInput.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkInput.create(address, capacity);
    }

    public static NkInput mallocStack() {
        return NkInput.mallocStack(MemoryStack.stackGet());
    }

    public static NkInput callocStack() {
        return NkInput.callocStack(MemoryStack.stackGet());
    }

    public static NkInput mallocStack(MemoryStack stack) {
        return NkInput.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkInput callocStack(MemoryStack stack) {
        return NkInput.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkInput.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkInput.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkInput.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkInput.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkKeyboard nkeyboard(long struct) {
        return NkKeyboard.create(struct + (long)KEYBOARD);
    }

    public static NkMouse nmouse(long struct) {
        return NkMouse.create(struct + (long)MOUSE);
    }

    static {
        Struct.Layout layout = NkInput.__struct(NkInput.__member(NkKeyboard.SIZEOF, NkKeyboard.ALIGNOF), NkInput.__member(NkMouse.SIZEOF, NkMouse.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        KEYBOARD = layout.offsetof(0);
        MOUSE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkInput, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkInput newInstance(long address) {
            return new NkInput(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="struct nk_keyboard")
        public NkKeyboard keyboard() {
            return NkInput.nkeyboard(this.address());
        }

        @NativeType(value="struct nk_mouse")
        public NkMouse mouse() {
            return NkInput.nmouse(this.address());
        }
    }
}

