/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_draw_null_texture")
public class NkDrawNullTexture
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TEXTURE;
    public static final int UV;

    NkDrawNullTexture(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public NkDrawNullTexture(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkDrawNullTexture.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="nk_handle")
    public NkHandle texture() {
        return NkDrawNullTexture.ntexture(this.address());
    }

    public NkDrawNullTexture texture(Consumer<NkHandle> consumer) {
        consumer.accept(this.texture());
        return this;
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 uv() {
        return NkDrawNullTexture.nuv(this.address());
    }

    public NkDrawNullTexture uv(Consumer<NkVec2> consumer) {
        consumer.accept(this.uv());
        return this;
    }

    public NkDrawNullTexture texture(@NativeType(value="nk_handle") NkHandle value) {
        NkDrawNullTexture.ntexture(this.address(), value);
        return this;
    }

    public NkDrawNullTexture uv(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkDrawNullTexture.nuv(this.address(), value);
        return this;
    }

    public NkDrawNullTexture set(NkHandle texture, NkVec2 uv) {
        this.texture(texture);
        this.uv(uv);
        return this;
    }

    public NkDrawNullTexture set(NkDrawNullTexture src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkDrawNullTexture malloc() {
        return NkDrawNullTexture.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NkDrawNullTexture calloc() {
        return NkDrawNullTexture.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NkDrawNullTexture create() {
        return new NkDrawNullTexture(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkDrawNullTexture create(long address) {
        return new NkDrawNullTexture(address, null);
    }

    @Nullable
    public static NkDrawNullTexture createSafe(long address) {
        return address == 0L ? null : NkDrawNullTexture.create(address);
    }

    public static Buffer malloc(int capacity) {
        return NkDrawNullTexture.create(NkDrawNullTexture.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkDrawNullTexture.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(NkDrawNullTexture.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkDrawNullTexture.create(address, capacity);
    }

    public static NkDrawNullTexture mallocStack() {
        return NkDrawNullTexture.mallocStack(MemoryStack.stackGet());
    }

    public static NkDrawNullTexture callocStack() {
        return NkDrawNullTexture.callocStack(MemoryStack.stackGet());
    }

    public static NkDrawNullTexture mallocStack(MemoryStack stack) {
        return NkDrawNullTexture.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkDrawNullTexture callocStack(MemoryStack stack) {
        return NkDrawNullTexture.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkDrawNullTexture.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkDrawNullTexture.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkDrawNullTexture.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkDrawNullTexture.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkHandle ntexture(long struct) {
        return NkHandle.create(struct + (long)TEXTURE);
    }

    public static NkVec2 nuv(long struct) {
        return NkVec2.create(struct + (long)UV);
    }

    public static void ntexture(long struct, NkHandle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXTURE, NkHandle.SIZEOF);
    }

    public static void nuv(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)UV, NkVec2.SIZEOF);
    }

    static {
        Struct.Layout layout = NkDrawNullTexture.__struct(NkDrawNullTexture.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF), NkDrawNullTexture.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TEXTURE = layout.offsetof(0);
        UV = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkDrawNullTexture, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkDrawNullTexture newInstance(long address) {
            return new NkDrawNullTexture(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="nk_handle")
        public NkHandle texture() {
            return NkDrawNullTexture.ntexture(this.address());
        }

        public Buffer texture(Consumer<NkHandle> consumer) {
            consumer.accept(this.texture());
            return this;
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 uv() {
            return NkDrawNullTexture.nuv(this.address());
        }

        public Buffer uv(Consumer<NkVec2> consumer) {
            consumer.accept(this.uv());
            return this;
        }

        public Buffer texture(@NativeType(value="nk_handle") NkHandle value) {
            NkDrawNullTexture.ntexture(this.address(), value);
            return this;
        }

        public Buffer uv(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkDrawNullTexture.nuv(this.address(), value);
            return this;
        }
    }
}

