/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_config_stack_float_element")
class NkConfigStackFloatElement
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PVALUES;
    public static final int OLD_VALUE;

    NkConfigStackFloatElement(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    NkConfigStackFloatElement(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkConfigStackFloatElement.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float *")
    public FloatBuffer pValues(int capacity) {
        return NkConfigStackFloatElement.npValues(this.address(), capacity);
    }

    public float old_value() {
        return NkConfigStackFloatElement.nold_value(this.address());
    }

    public static NkConfigStackFloatElement create(long address) {
        return new NkConfigStackFloatElement(address, null);
    }

    @Nullable
    public static NkConfigStackFloatElement createSafe(long address) {
        return address == 0L ? null : NkConfigStackFloatElement.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkConfigStackFloatElement.create(address, capacity);
    }

    public static FloatBuffer npValues(long struct, int capacity) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)PVALUES), capacity);
    }

    public static float nold_value(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)OLD_VALUE);
    }

    static {
        Struct.Layout layout = NkConfigStackFloatElement.__struct(NkConfigStackFloatElement.__member(POINTER_SIZE), NkConfigStackFloatElement.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PVALUES = layout.offsetof(0);
        OLD_VALUE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkConfigStackFloatElement, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkConfigStackFloatElement newInstance(long address) {
            return new NkConfigStackFloatElement(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="float *")
        public FloatBuffer pValues(int capacity) {
            return NkConfigStackFloatElement.npValues(this.address(), capacity);
        }

        public float old_value() {
            return NkConfigStackFloatElement.nold_value(this.address());
        }
    }
}

