/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_buffer_marker")
public class NkBufferMarker
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ACTIVE;
    public static final int OFFSET;

    NkBufferMarker(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public NkBufferMarker(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkBufferMarker.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int active() {
        return NkBufferMarker.nactive(this.address());
    }

    @NativeType(value="nk_size")
    public long offset() {
        return NkBufferMarker.noffset(this.address());
    }

    public static NkBufferMarker create(long address) {
        return new NkBufferMarker(address, null);
    }

    @Nullable
    public static NkBufferMarker createSafe(long address) {
        return address == 0L ? null : NkBufferMarker.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkBufferMarker.create(address, capacity);
    }

    public static int nactive(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ACTIVE);
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)OFFSET);
    }

    static {
        Struct.Layout layout = NkBufferMarker.__struct(NkBufferMarker.__member(4), NkBufferMarker.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ACTIVE = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkBufferMarker, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkBufferMarker newInstance(long address) {
            return new NkBufferMarker(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public int active() {
            return NkBufferMarker.nactive(this.address());
        }

        @NativeType(value="nk_size")
        public long offset() {
            return NkBufferMarker.noffset(this.address());
        }
    }
}

