/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nanovg;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.nanovg.NSVGGradientStop;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct NSVGgradient")
public class NSVGGradient
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int XFORM;
    public static final int SPREAD;
    public static final int FX;
    public static final int FY;
    public static final int NSTOPS;
    public static final int PSTOPS;

    NSVGGradient(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public NSVGGradient(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NSVGGradient.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[6]")
    public FloatBuffer xform() {
        return NSVGGradient.nxform(this.address());
    }

    public float xform(int index) {
        return NSVGGradient.nxform(this.address(), index);
    }

    @NativeType(value="char")
    public byte spread() {
        return NSVGGradient.nspread(this.address());
    }

    public float fx() {
        return NSVGGradient.nfx(this.address());
    }

    public float fy() {
        return NSVGGradient.nfy(this.address());
    }

    public int nstops() {
        return NSVGGradient.nnstops(this.address());
    }

    @NativeType(value="NSVGgradientStop[1]")
    public NSVGGradientStop.Buffer pstops() {
        return NSVGGradient.npstops(this.address());
    }

    @NativeType(value="NSVGgradientStop")
    public NSVGGradientStop pstops(int index) {
        return NSVGGradient.npstops(this.address(), index);
    }

    public static NSVGGradient create(long address) {
        return new NSVGGradient(address, null);
    }

    @Nullable
    public static NSVGGradient createSafe(long address) {
        return address == 0L ? null : NSVGGradient.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NSVGGradient.create(address, capacity);
    }

    public static FloatBuffer nxform(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)XFORM, 6);
    }

    public static float nxform(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)XFORM + Checks.check(index, 6) * 4L);
    }

    public static byte nspread(long struct) {
        return MemoryUtil.memGetByte(struct + (long)SPREAD);
    }

    public static float nfx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FX);
    }

    public static float nfy(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FY);
    }

    public static int nnstops(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NSTOPS);
    }

    public static NSVGGradientStop.Buffer npstops(long struct) {
        return NSVGGradientStop.create(struct + (long)PSTOPS, NSVGGradient.nnstops(struct));
    }

    public static NSVGGradientStop npstops(long struct, int index) {
        return NSVGGradientStop.create(struct + (long)PSTOPS + Checks.check(index, NSVGGradient.nnstops(struct)) * (long)NSVGGradientStop.SIZEOF);
    }

    static {
        Struct.Layout layout = NSVGGradient.__struct(NSVGGradient.__array(4, 6), NSVGGradient.__member(1), NSVGGradient.__member(4), NSVGGradient.__member(4), NSVGGradient.__member(4), NSVGGradient.__array(NSVGGradientStop.SIZEOF, NSVGGradientStop.ALIGNOF, 1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        XFORM = layout.offsetof(0);
        SPREAD = layout.offsetof(1);
        FX = layout.offsetof(2);
        FY = layout.offsetof(3);
        NSTOPS = layout.offsetof(4);
        PSTOPS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<NSVGGradient, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NSVGGradient newInstance(long address) {
            return new NSVGGradient(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="float[6]")
        public FloatBuffer xform() {
            return NSVGGradient.nxform(this.address());
        }

        public float xform(int index) {
            return NSVGGradient.nxform(this.address(), index);
        }

        @NativeType(value="char")
        public byte spread() {
            return NSVGGradient.nspread(this.address());
        }

        public float fx() {
            return NSVGGradient.nfx(this.address());
        }

        public float fy() {
            return NSVGGradient.nfy(this.address());
        }

        public int nstops() {
            return NSVGGradient.nnstops(this.address());
        }

        @NativeType(value="NSVGgradientStop[1]")
        public NSVGGradientStop.Buffer pstops() {
            return NSVGGradient.npstops(this.address());
        }

        @NativeType(value="NSVGgradientStop")
        public NSVGGradientStop pstops(int index) {
            return NSVGGradient.npstops(this.address(), index);
        }
    }
}

