/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class EXTPlatformBase {
    protected EXTPlatformBase() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglGetPlatformDisplayEXT, caps.eglCreatePlatformWindowSurfaceEXT, caps.eglCreatePlatformPixmapSurfaceEXT);
    }

    public static long neglGetPlatformDisplayEXT(int platform, long native_display, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglGetPlatformDisplayEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(native_display);
        }
        return JNI.callPPP(__functionAddress, platform, native_display, attrib_list);
    }

    @NativeType(value="EGLDisplay")
    public static long eglGetPlatformDisplayEXT(@NativeType(value="EGLenum") int platform, @NativeType(value="void *") long native_display, @Nullable @NativeType(value="EGLint const *") IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return EXTPlatformBase.neglGetPlatformDisplayEXT(platform, native_display, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long neglCreatePlatformWindowSurfaceEXT(long dpy, long config, long native_window, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePlatformWindowSurfaceEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(config);
            Checks.check(native_window);
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, native_window, attrib_list);
    }

    @NativeType(value="EGLSurface")
    public static long eglCreatePlatformWindowSurfaceEXT(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLConfig") long config, @NativeType(value="void *") long native_window, @Nullable @NativeType(value="EGLint const *") IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return EXTPlatformBase.neglCreatePlatformWindowSurfaceEXT(dpy, config, native_window, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long neglCreatePlatformPixmapSurfaceEXT(long dpy, long config, long native_pixmap, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePlatformPixmapSurfaceEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(config);
            Checks.check(native_pixmap);
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, native_pixmap, attrib_list);
    }

    @NativeType(value="EGLSurface")
    public static long eglCreatePlatformPixmapSurfaceEXT(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLConfig") long config, @NativeType(value="void *") long native_pixmap, @Nullable @NativeType(value="EGLint const *") IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return EXTPlatformBase.neglCreatePlatformPixmapSurfaceEXT(dpy, config, native_pixmap, MemoryUtil.memAddressSafe(attrib_list));
    }

    @NativeType(value="EGLDisplay")
    public static long eglGetPlatformDisplayEXT(@NativeType(value="EGLenum") int platform, @NativeType(value="void *") long native_display, @Nullable @NativeType(value="EGLint const *") int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglGetPlatformDisplayEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(native_display);
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return JNI.callPPP(__functionAddress, platform, native_display, attrib_list);
    }

    @NativeType(value="EGLSurface")
    public static long eglCreatePlatformWindowSurfaceEXT(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLConfig") long config, @NativeType(value="void *") long native_window, @Nullable @NativeType(value="EGLint const *") int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePlatformWindowSurfaceEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(config);
            Checks.check(native_window);
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, native_window, attrib_list);
    }

    @NativeType(value="EGLSurface")
    public static long eglCreatePlatformPixmapSurfaceEXT(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLConfig") long config, @NativeType(value="void *") long native_pixmap, @Nullable @NativeType(value="EGLint const *") int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePlatformPixmapSurfaceEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(config);
            Checks.check(native_pixmap);
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, native_pixmap, attrib_list);
    }
}

