/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_uniform_info_t")
public class BGFXUniformInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int TYPE;
    public static final int NUM;

    BGFXUniformInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public BGFXUniformInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXUniformInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[256]")
    public ByteBuffer name() {
        return BGFXUniformInfo.nname(this.address());
    }

    @NativeType(value="char[256]")
    public String nameString() {
        return BGFXUniformInfo.nnameString(this.address());
    }

    @NativeType(value="bgfx_uniform_type_t")
    public int type() {
        return BGFXUniformInfo.ntype(this.address());
    }

    @NativeType(value="uint16_t")
    public short num() {
        return BGFXUniformInfo.nnum(this.address());
    }

    public BGFXUniformInfo name(@NativeType(value="char[256]") ByteBuffer value) {
        BGFXUniformInfo.nname(this.address(), value);
        return this;
    }

    public BGFXUniformInfo type(@NativeType(value="bgfx_uniform_type_t") int value) {
        BGFXUniformInfo.ntype(this.address(), value);
        return this;
    }

    public BGFXUniformInfo num(@NativeType(value="uint16_t") short value) {
        BGFXUniformInfo.nnum(this.address(), value);
        return this;
    }

    public BGFXUniformInfo set(ByteBuffer name, int type, short num) {
        this.name(name);
        this.type(type);
        this.num(num);
        return this;
    }

    public BGFXUniformInfo set(BGFXUniformInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXUniformInfo malloc() {
        return BGFXUniformInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static BGFXUniformInfo calloc() {
        return BGFXUniformInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static BGFXUniformInfo create() {
        return new BGFXUniformInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static BGFXUniformInfo create(long address) {
        return new BGFXUniformInfo(address, null);
    }

    @Nullable
    public static BGFXUniformInfo createSafe(long address) {
        return address == 0L ? null : BGFXUniformInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return BGFXUniformInfo.create(BGFXUniformInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXUniformInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BGFXUniformInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : BGFXUniformInfo.create(address, capacity);
    }

    public static BGFXUniformInfo mallocStack() {
        return BGFXUniformInfo.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXUniformInfo callocStack() {
        return BGFXUniformInfo.callocStack(MemoryStack.stackGet());
    }

    public static BGFXUniformInfo mallocStack(MemoryStack stack) {
        return BGFXUniformInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXUniformInfo callocStack(MemoryStack stack) {
        return BGFXUniformInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return BGFXUniformInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return BGFXUniformInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXUniformInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXUniformInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)NAME, 256);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memASCII(struct + (long)NAME);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static short nnum(long struct) {
        return MemoryUtil.memGetShort(struct + (long)NUM);
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
            Checks.checkGT(value, 256);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)NAME, value.remaining());
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnum(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)NUM, value);
    }

    static {
        Struct.Layout layout = BGFXUniformInfo.__struct(BGFXUniformInfo.__array(1, 256), BGFXUniformInfo.__member(4), BGFXUniformInfo.__member(2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        TYPE = layout.offsetof(1);
        NUM = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<BGFXUniformInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXUniformInfo newInstance(long address) {
            return new BGFXUniformInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="char[256]")
        public ByteBuffer name() {
            return BGFXUniformInfo.nname(this.address());
        }

        @NativeType(value="char[256]")
        public String nameString() {
            return BGFXUniformInfo.nnameString(this.address());
        }

        @NativeType(value="bgfx_uniform_type_t")
        public int type() {
            return BGFXUniformInfo.ntype(this.address());
        }

        @NativeType(value="uint16_t")
        public short num() {
            return BGFXUniformInfo.nnum(this.address());
        }

        public Buffer name(@NativeType(value="char[256]") ByteBuffer value) {
            BGFXUniformInfo.nname(this.address(), value);
            return this;
        }

        public Buffer type(@NativeType(value="bgfx_uniform_type_t") int value) {
            BGFXUniformInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer num(@NativeType(value="uint16_t") short value) {
            BGFXUniformInfo.nnum(this.address(), value);
            return this;
        }
    }
}

