/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_instance_data_buffer_t")
public class BGFXInstanceDataBuffer
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int SIZE;
    public static final int OFFSET;
    public static final int NUM;
    public static final int STRIDE;
    public static final int HANDLE;

    BGFXInstanceDataBuffer(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public BGFXInstanceDataBuffer(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXInstanceDataBuffer.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t *")
    public ByteBuffer data() {
        return BGFXInstanceDataBuffer.ndata(this.address());
    }

    @NativeType(value="uint32_t")
    public int size() {
        return BGFXInstanceDataBuffer.nsize(this.address());
    }

    @NativeType(value="uint32_t")
    public int offset() {
        return BGFXInstanceDataBuffer.noffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int num() {
        return BGFXInstanceDataBuffer.nnum(this.address());
    }

    @NativeType(value="uint16_t")
    public short stride() {
        return BGFXInstanceDataBuffer.nstride(this.address());
    }

    @NativeType(value="bgfx_vertex_buffer_handle_t")
    public short handle() {
        return BGFXInstanceDataBuffer.nhandle(this.address());
    }

    public BGFXInstanceDataBuffer data(@NativeType(value="uint8_t *") ByteBuffer value) {
        BGFXInstanceDataBuffer.ndata(this.address(), value);
        return this;
    }

    public BGFXInstanceDataBuffer offset(@NativeType(value="uint32_t") int value) {
        BGFXInstanceDataBuffer.noffset(this.address(), value);
        return this;
    }

    public BGFXInstanceDataBuffer num(@NativeType(value="uint32_t") int value) {
        BGFXInstanceDataBuffer.nnum(this.address(), value);
        return this;
    }

    public BGFXInstanceDataBuffer stride(@NativeType(value="uint16_t") short value) {
        BGFXInstanceDataBuffer.nstride(this.address(), value);
        return this;
    }

    public BGFXInstanceDataBuffer handle(@NativeType(value="bgfx_vertex_buffer_handle_t") short value) {
        BGFXInstanceDataBuffer.nhandle(this.address(), value);
        return this;
    }

    public BGFXInstanceDataBuffer set(ByteBuffer data, int offset, int num, short stride, short handle) {
        this.data(data);
        this.offset(offset);
        this.num(num);
        this.stride(stride);
        this.handle(handle);
        return this;
    }

    public BGFXInstanceDataBuffer set(BGFXInstanceDataBuffer src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXInstanceDataBuffer malloc() {
        return BGFXInstanceDataBuffer.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static BGFXInstanceDataBuffer calloc() {
        return BGFXInstanceDataBuffer.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static BGFXInstanceDataBuffer create() {
        return new BGFXInstanceDataBuffer(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static BGFXInstanceDataBuffer create(long address) {
        return new BGFXInstanceDataBuffer(address, null);
    }

    @Nullable
    public static BGFXInstanceDataBuffer createSafe(long address) {
        return address == 0L ? null : BGFXInstanceDataBuffer.create(address);
    }

    public static Buffer malloc(int capacity) {
        return BGFXInstanceDataBuffer.create(BGFXInstanceDataBuffer.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXInstanceDataBuffer.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BGFXInstanceDataBuffer.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : BGFXInstanceDataBuffer.create(address, capacity);
    }

    public static BGFXInstanceDataBuffer mallocStack() {
        return BGFXInstanceDataBuffer.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXInstanceDataBuffer callocStack() {
        return BGFXInstanceDataBuffer.callocStack(MemoryStack.stackGet());
    }

    public static BGFXInstanceDataBuffer mallocStack(MemoryStack stack) {
        return BGFXInstanceDataBuffer.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXInstanceDataBuffer callocStack(MemoryStack stack) {
        return BGFXInstanceDataBuffer.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return BGFXInstanceDataBuffer.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return BGFXInstanceDataBuffer.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXInstanceDataBuffer.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXInstanceDataBuffer.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)DATA), BGFXInstanceDataBuffer.nsize(struct));
    }

    public static int nsize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SIZE);
    }

    public static int noffset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OFFSET);
    }

    public static int nnum(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUM);
    }

    public static short nstride(long struct) {
        return MemoryUtil.memGetShort(struct + (long)STRIDE);
    }

    public static short nhandle(long struct) {
        return MemoryUtil.memGetShort(struct + (long)HANDLE);
    }

    public static void ndata(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)DATA, MemoryUtil.memAddress(value));
        BGFXInstanceDataBuffer.nsize(struct, value.remaining());
    }

    public static void nsize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SIZE, value);
    }

    public static void noffset(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OFFSET, value);
    }

    public static void nnum(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUM, value);
    }

    public static void nstride(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)STRIDE, value);
    }

    public static void nhandle(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)HANDLE, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DATA));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            BGFXInstanceDataBuffer.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = BGFXInstanceDataBuffer.__struct(BGFXInstanceDataBuffer.__member(POINTER_SIZE), BGFXInstanceDataBuffer.__member(4), BGFXInstanceDataBuffer.__member(4), BGFXInstanceDataBuffer.__member(4), BGFXInstanceDataBuffer.__member(2), BGFXInstanceDataBuffer.__member(2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        OFFSET = layout.offsetof(2);
        NUM = layout.offsetof(3);
        STRIDE = layout.offsetof(4);
        HANDLE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<BGFXInstanceDataBuffer, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXInstanceDataBuffer newInstance(long address) {
            return new BGFXInstanceDataBuffer(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="uint8_t *")
        public ByteBuffer data() {
            return BGFXInstanceDataBuffer.ndata(this.address());
        }

        @NativeType(value="uint32_t")
        public int size() {
            return BGFXInstanceDataBuffer.nsize(this.address());
        }

        @NativeType(value="uint32_t")
        public int offset() {
            return BGFXInstanceDataBuffer.noffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int num() {
            return BGFXInstanceDataBuffer.nnum(this.address());
        }

        @NativeType(value="uint16_t")
        public short stride() {
            return BGFXInstanceDataBuffer.nstride(this.address());
        }

        @NativeType(value="bgfx_vertex_buffer_handle_t")
        public short handle() {
            return BGFXInstanceDataBuffer.nhandle(this.address());
        }

        public Buffer data(@NativeType(value="uint8_t *") ByteBuffer value) {
            BGFXInstanceDataBuffer.ndata(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="uint32_t") int value) {
            BGFXInstanceDataBuffer.noffset(this.address(), value);
            return this;
        }

        public Buffer num(@NativeType(value="uint32_t") int value) {
            BGFXInstanceDataBuffer.nnum(this.address(), value);
            return this;
        }

        public Buffer stride(@NativeType(value="uint16_t") short value) {
            BGFXInstanceDataBuffer.nstride(this.address(), value);
            return this;
        }

        public Buffer handle(@NativeType(value="bgfx_vertex_buffer_handle_t") short value) {
            BGFXInstanceDataBuffer.nhandle(this.address(), value);
            return this;
        }
    }
}

