/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct bgfx_init_limits_t")
public class BGFXInitLimits
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAXENCODERS;
    public static final int TRANSIENTVBSIZE;
    public static final int TRANSIENTIBSIZE;

    BGFXInitLimits(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public BGFXInitLimits(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXInitLimits.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint16_t")
    public short maxEncoders() {
        return BGFXInitLimits.nmaxEncoders(this.address());
    }

    @NativeType(value="uint32_t")
    public int transientVbSize() {
        return BGFXInitLimits.ntransientVbSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int transientIbSize() {
        return BGFXInitLimits.ntransientIbSize(this.address());
    }

    public BGFXInitLimits maxEncoders(@NativeType(value="uint16_t") short value) {
        BGFXInitLimits.nmaxEncoders(this.address(), value);
        return this;
    }

    public BGFXInitLimits transientVbSize(@NativeType(value="uint32_t") int value) {
        BGFXInitLimits.ntransientVbSize(this.address(), value);
        return this;
    }

    public BGFXInitLimits transientIbSize(@NativeType(value="uint32_t") int value) {
        BGFXInitLimits.ntransientIbSize(this.address(), value);
        return this;
    }

    public BGFXInitLimits set(short maxEncoders, int transientVbSize, int transientIbSize) {
        this.maxEncoders(maxEncoders);
        this.transientVbSize(transientVbSize);
        this.transientIbSize(transientIbSize);
        return this;
    }

    public BGFXInitLimits set(BGFXInitLimits src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXInitLimits malloc() {
        return BGFXInitLimits.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static BGFXInitLimits calloc() {
        return BGFXInitLimits.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static BGFXInitLimits create() {
        return new BGFXInitLimits(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static BGFXInitLimits create(long address) {
        return new BGFXInitLimits(address, null);
    }

    @Nullable
    public static BGFXInitLimits createSafe(long address) {
        return address == 0L ? null : BGFXInitLimits.create(address);
    }

    public static BGFXInitLimits mallocStack() {
        return BGFXInitLimits.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXInitLimits callocStack() {
        return BGFXInitLimits.callocStack(MemoryStack.stackGet());
    }

    public static BGFXInitLimits mallocStack(MemoryStack stack) {
        return BGFXInitLimits.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXInitLimits callocStack(MemoryStack stack) {
        return BGFXInitLimits.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static short nmaxEncoders(long struct) {
        return MemoryUtil.memGetShort(struct + (long)MAXENCODERS);
    }

    public static int ntransientVbSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TRANSIENTVBSIZE);
    }

    public static int ntransientIbSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TRANSIENTIBSIZE);
    }

    public static void nmaxEncoders(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)MAXENCODERS, value);
    }

    public static void ntransientVbSize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TRANSIENTVBSIZE, value);
    }

    public static void ntransientIbSize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TRANSIENTIBSIZE, value);
    }

    static {
        Struct.Layout layout = BGFXInitLimits.__struct(BGFXInitLimits.__member(2), BGFXInitLimits.__member(4), BGFXInitLimits.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAXENCODERS = layout.offsetof(0);
        TRANSIENTVBSIZE = layout.offsetof(1);
        TRANSIENTIBSIZE = layout.offsetof(2);
    }
}

