/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.bgfx.BGFXAllocatorInterface;
import org.lwjgl.bgfx.BGFXCallbackInterface;
import org.lwjgl.bgfx.BGFXInitLimits;
import org.lwjgl.bgfx.BGFXResolution;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct bgfx_init_t")
public class BGFXInit
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int VENDORID;
    public static final int DEVICEID;
    public static final int DEBUG;
    public static final int PROFILE;
    public static final int RESOLUTION;
    public static final int LIMITS;
    public static final int CALLBACK;
    public static final int ALLOCATOR;

    BGFXInit(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public BGFXInit(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXInit.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bgfx_renderer_type_t")
    public int type() {
        return BGFXInit.ntype(this.address());
    }

    @NativeType(value="uint16_t")
    public short vendorId() {
        return BGFXInit.nvendorId(this.address());
    }

    @NativeType(value="uint16_t")
    public short deviceId() {
        return BGFXInit.ndeviceId(this.address());
    }

    @NativeType(value="bool")
    public boolean debug() {
        return BGFXInit.ndebug(this.address());
    }

    @NativeType(value="bool")
    public boolean profile() {
        return BGFXInit.nprofile(this.address());
    }

    @NativeType(value="bgfx_resolution_t")
    public BGFXResolution resolution() {
        return BGFXInit.nresolution(this.address());
    }

    public BGFXInit resolution(Consumer<BGFXResolution> consumer) {
        consumer.accept(this.resolution());
        return this;
    }

    @NativeType(value="bgfx_init_limits_t")
    public BGFXInitLimits limits() {
        return BGFXInit.nlimits(this.address());
    }

    public BGFXInit limits(Consumer<BGFXInitLimits> consumer) {
        consumer.accept(this.limits());
        return this;
    }

    @Nullable
    @NativeType(value="bgfx_callback_interface_t *")
    public BGFXCallbackInterface callback() {
        return BGFXInit.ncallback(this.address());
    }

    @Nullable
    @NativeType(value="bgfx_allocator_interface_t *")
    public BGFXAllocatorInterface allocator() {
        return BGFXInit.nallocator(this.address());
    }

    public BGFXInit type(@NativeType(value="bgfx_renderer_type_t") int value) {
        BGFXInit.ntype(this.address(), value);
        return this;
    }

    public BGFXInit vendorId(@NativeType(value="uint16_t") short value) {
        BGFXInit.nvendorId(this.address(), value);
        return this;
    }

    public BGFXInit deviceId(@NativeType(value="uint16_t") short value) {
        BGFXInit.ndeviceId(this.address(), value);
        return this;
    }

    public BGFXInit debug(@NativeType(value="bool") boolean value) {
        BGFXInit.ndebug(this.address(), value);
        return this;
    }

    public BGFXInit profile(@NativeType(value="bool") boolean value) {
        BGFXInit.nprofile(this.address(), value);
        return this;
    }

    public BGFXInit resolution(@NativeType(value="bgfx_resolution_t") BGFXResolution value) {
        BGFXInit.nresolution(this.address(), value);
        return this;
    }

    public BGFXInit limits(@NativeType(value="bgfx_init_limits_t") BGFXInitLimits value) {
        BGFXInit.nlimits(this.address(), value);
        return this;
    }

    public BGFXInit callback(@Nullable @NativeType(value="bgfx_callback_interface_t *") BGFXCallbackInterface value) {
        BGFXInit.ncallback(this.address(), value);
        return this;
    }

    public BGFXInit allocator(@Nullable @NativeType(value="bgfx_allocator_interface_t *") BGFXAllocatorInterface value) {
        BGFXInit.nallocator(this.address(), value);
        return this;
    }

    public BGFXInit set(int type, short vendorId, short deviceId, boolean debug, boolean profile, BGFXResolution resolution, BGFXInitLimits limits, @Nullable BGFXCallbackInterface callback, @Nullable BGFXAllocatorInterface allocator) {
        this.type(type);
        this.vendorId(vendorId);
        this.deviceId(deviceId);
        this.debug(debug);
        this.profile(profile);
        this.resolution(resolution);
        this.limits(limits);
        this.callback(callback);
        this.allocator(allocator);
        return this;
    }

    public BGFXInit set(BGFXInit src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXInit malloc() {
        return BGFXInit.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static BGFXInit calloc() {
        return BGFXInit.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static BGFXInit create() {
        return new BGFXInit(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static BGFXInit create(long address) {
        return new BGFXInit(address, null);
    }

    @Nullable
    public static BGFXInit createSafe(long address) {
        return address == 0L ? null : BGFXInit.create(address);
    }

    public static BGFXInit mallocStack() {
        return BGFXInit.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXInit callocStack() {
        return BGFXInit.callocStack(MemoryStack.stackGet());
    }

    public static BGFXInit mallocStack(MemoryStack stack) {
        return BGFXInit.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXInit callocStack(MemoryStack stack) {
        return BGFXInit.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static short nvendorId(long struct) {
        return MemoryUtil.memGetShort(struct + (long)VENDORID);
    }

    public static short ndeviceId(long struct) {
        return MemoryUtil.memGetShort(struct + (long)DEVICEID);
    }

    public static boolean ndebug(long struct) {
        return MemoryUtil.memGetByte(struct + (long)DEBUG) != 0;
    }

    public static boolean nprofile(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PROFILE) != 0;
    }

    public static BGFXResolution nresolution(long struct) {
        return BGFXResolution.create(struct + (long)RESOLUTION);
    }

    public static BGFXInitLimits nlimits(long struct) {
        return BGFXInitLimits.create(struct + (long)LIMITS);
    }

    @Nullable
    public static BGFXCallbackInterface ncallback(long struct) {
        return BGFXCallbackInterface.createSafe(MemoryUtil.memGetAddress(struct + (long)CALLBACK));
    }

    @Nullable
    public static BGFXAllocatorInterface nallocator(long struct) {
        return BGFXAllocatorInterface.createSafe(MemoryUtil.memGetAddress(struct + (long)ALLOCATOR));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nvendorId(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)VENDORID, value);
    }

    public static void ndeviceId(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)DEVICEID, value);
    }

    public static void ndebug(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)DEBUG, value ? (byte)1 : 0);
    }

    public static void nprofile(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)PROFILE, value ? (byte)1 : 0);
    }

    public static void nresolution(long struct, BGFXResolution value) {
        MemoryUtil.memCopy(value.address(), struct + (long)RESOLUTION, BGFXResolution.SIZEOF);
    }

    public static void nlimits(long struct, BGFXInitLimits value) {
        MemoryUtil.memCopy(value.address(), struct + (long)LIMITS, BGFXInitLimits.SIZEOF);
    }

    public static void ncallback(long struct, @Nullable BGFXCallbackInterface value) {
        MemoryUtil.memPutAddress(struct + (long)CALLBACK, MemoryUtil.memAddressSafe(value));
    }

    public static void nallocator(long struct, @Nullable BGFXAllocatorInterface value) {
        MemoryUtil.memPutAddress(struct + (long)ALLOCATOR, MemoryUtil.memAddressSafe(value));
    }

    public static void validate(long struct) {
        long allocator;
        long callback = MemoryUtil.memGetAddress(struct + (long)CALLBACK);
        if (callback != 0L) {
            BGFXCallbackInterface.validate(callback);
        }
        if ((allocator = MemoryUtil.memGetAddress(struct + (long)ALLOCATOR)) != 0L) {
            BGFXAllocatorInterface.validate(allocator);
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            BGFXInit.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = BGFXInit.__struct(BGFXInit.__member(4), BGFXInit.__member(2), BGFXInit.__member(2), BGFXInit.__member(1), BGFXInit.__member(1), BGFXInit.__member(BGFXResolution.SIZEOF, BGFXResolution.ALIGNOF), BGFXInit.__member(BGFXInitLimits.SIZEOF, BGFXInitLimits.ALIGNOF), BGFXInit.__member(POINTER_SIZE), BGFXInit.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        VENDORID = layout.offsetof(1);
        DEVICEID = layout.offsetof(2);
        DEBUG = layout.offsetof(3);
        PROFILE = layout.offsetof(4);
        RESOLUTION = layout.offsetof(5);
        LIMITS = layout.offsetof(6);
        CALLBACK = layout.offsetof(7);
        ALLOCATOR = layout.offsetof(8);
    }
}

