/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.bgfx.BGFXCapsGPU;
import org.lwjgl.bgfx.BGFXCapsLimits;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct bgfx_caps_t")
public class BGFXCaps
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RENDERERTYPE;
    public static final int SUPPORTED;
    public static final int VENDORID;
    public static final int DEVICEID;
    public static final int HOMOGENEOUSDEPTH;
    public static final int ORIGINBOTTOMLEFT;
    public static final int NUMGPUS;
    public static final int GPU;
    public static final int LIMITS;
    public static final int FORMATS;

    BGFXCaps(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public BGFXCaps(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXCaps.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bgfx_renderer_type_t")
    public int rendererType() {
        return BGFXCaps.nrendererType(this.address());
    }

    @NativeType(value="uint64_t")
    public long supported() {
        return BGFXCaps.nsupported(this.address());
    }

    @NativeType(value="uint16_t")
    public short vendorId() {
        return BGFXCaps.nvendorId(this.address());
    }

    @NativeType(value="uint16_t")
    public short deviceId() {
        return BGFXCaps.ndeviceId(this.address());
    }

    @NativeType(value="bool")
    public boolean homogeneousDepth() {
        return BGFXCaps.nhomogeneousDepth(this.address());
    }

    @NativeType(value="bool")
    public boolean originBottomLeft() {
        return BGFXCaps.noriginBottomLeft(this.address());
    }

    @NativeType(value="uint8_t")
    public byte numGPUs() {
        return BGFXCaps.nnumGPUs(this.address());
    }

    @NativeType(value="bgfx_caps_gpu_t[4]")
    public BGFXCapsGPU.Buffer gpu() {
        return BGFXCaps.ngpu(this.address());
    }

    @NativeType(value="bgfx_caps_gpu_t")
    public BGFXCapsGPU gpu(int index) {
        return BGFXCaps.ngpu(this.address(), index);
    }

    @NativeType(value="bgfx_caps_limits_t")
    public BGFXCapsLimits limits() {
        return BGFXCaps.nlimits(this.address());
    }

    @NativeType(value="uint16_t[BGFX_TEXTURE_FORMAT_COUNT]")
    public ShortBuffer formats() {
        return BGFXCaps.nformats(this.address());
    }

    @NativeType(value="uint16_t")
    public short formats(int index) {
        return BGFXCaps.nformats(this.address(), index);
    }

    public static BGFXCaps create(long address) {
        return new BGFXCaps(address, null);
    }

    @Nullable
    public static BGFXCaps createSafe(long address) {
        return address == 0L ? null : BGFXCaps.create(address);
    }

    public static int nrendererType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RENDERERTYPE);
    }

    public static long nsupported(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SUPPORTED);
    }

    public static short nvendorId(long struct) {
        return MemoryUtil.memGetShort(struct + (long)VENDORID);
    }

    public static short ndeviceId(long struct) {
        return MemoryUtil.memGetShort(struct + (long)DEVICEID);
    }

    public static boolean nhomogeneousDepth(long struct) {
        return MemoryUtil.memGetByte(struct + (long)HOMOGENEOUSDEPTH) != 0;
    }

    public static boolean noriginBottomLeft(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ORIGINBOTTOMLEFT) != 0;
    }

    public static byte nnumGPUs(long struct) {
        return MemoryUtil.memGetByte(struct + (long)NUMGPUS);
    }

    public static BGFXCapsGPU.Buffer ngpu(long struct) {
        return BGFXCapsGPU.create(struct + (long)GPU, Byte.toUnsignedInt(BGFXCaps.nnumGPUs(struct)));
    }

    public static BGFXCapsGPU ngpu(long struct, int index) {
        return BGFXCapsGPU.create(struct + (long)GPU + Checks.check(index, Byte.toUnsignedInt(BGFXCaps.nnumGPUs(struct))) * (long)BGFXCapsGPU.SIZEOF);
    }

    public static BGFXCapsLimits nlimits(long struct) {
        return BGFXCapsLimits.create(struct + (long)LIMITS);
    }

    public static ShortBuffer nformats(long struct) {
        return MemoryUtil.memShortBuffer(struct + (long)FORMATS, 85);
    }

    public static short nformats(long struct, int index) {
        return MemoryUtil.memGetShort(struct + (long)FORMATS + Checks.check(index, 85) * 2L);
    }

    static {
        Struct.Layout layout = BGFXCaps.__struct(BGFXCaps.__member(4), BGFXCaps.__member(8), BGFXCaps.__member(2), BGFXCaps.__member(2), BGFXCaps.__member(1), BGFXCaps.__member(1), BGFXCaps.__member(1), BGFXCaps.__array(BGFXCapsGPU.SIZEOF, BGFXCapsGPU.ALIGNOF, 4), BGFXCaps.__member(BGFXCapsLimits.SIZEOF, BGFXCapsLimits.ALIGNOF), BGFXCaps.__array(2, 85));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RENDERERTYPE = layout.offsetof(0);
        SUPPORTED = layout.offsetof(1);
        VENDORID = layout.offsetof(2);
        DEVICEID = layout.offsetof(3);
        HOMOGENEOUSDEPTH = layout.offsetof(4);
        ORIGINBOTTOMLEFT = layout.offsetof(5);
        NUMGPUS = layout.offsetof(6);
        GPU = layout.offsetof(7);
        LIMITS = layout.offsetof(8);
        FORMATS = layout.offsetof(9);
    }
}

