/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.bgfx.BGFXCacheReadCallback;
import org.lwjgl.bgfx.BGFXCacheReadCallbackI;
import org.lwjgl.bgfx.BGFXCacheReadSizeCallback;
import org.lwjgl.bgfx.BGFXCacheReadSizeCallbackI;
import org.lwjgl.bgfx.BGFXCacheWriteCallback;
import org.lwjgl.bgfx.BGFXCacheWriteCallbackI;
import org.lwjgl.bgfx.BGFXCaptureBeginCallback;
import org.lwjgl.bgfx.BGFXCaptureBeginCallbackI;
import org.lwjgl.bgfx.BGFXCaptureEndCallback;
import org.lwjgl.bgfx.BGFXCaptureEndCallbackI;
import org.lwjgl.bgfx.BGFXCaptureFrameCallback;
import org.lwjgl.bgfx.BGFXCaptureFrameCallbackI;
import org.lwjgl.bgfx.BGFXFatalCallback;
import org.lwjgl.bgfx.BGFXFatalCallbackI;
import org.lwjgl.bgfx.BGFXProfilerBegin;
import org.lwjgl.bgfx.BGFXProfilerBeginI;
import org.lwjgl.bgfx.BGFXProfilerBeginLiteral;
import org.lwjgl.bgfx.BGFXProfilerBeginLiteralI;
import org.lwjgl.bgfx.BGFXProfilerEnd;
import org.lwjgl.bgfx.BGFXProfilerEndI;
import org.lwjgl.bgfx.BGFXScreenShotCallback;
import org.lwjgl.bgfx.BGFXScreenShotCallbackI;
import org.lwjgl.bgfx.BGFXTraceVarArgsCallback;
import org.lwjgl.bgfx.BGFXTraceVarArgsCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct bgfx_callback_vtbl_t")
public class BGFXCallbackVtbl
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FATAL;
    public static final int TRACE_VARGS;
    public static final int PROFILER_BEGIN;
    public static final int PROFILER_BEGIN_LITERAL;
    public static final int PROFILER_END;
    public static final int CACHE_READ_SIZE;
    public static final int CACHE_READ;
    public static final int CACHE_WRITE;
    public static final int SCREEN_SHOT;
    public static final int CAPTURE_BEGIN;
    public static final int CAPTURE_END;
    public static final int CAPTURE_FRAME;

    BGFXCallbackVtbl(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public BGFXCallbackVtbl(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXCallbackVtbl.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void (*) (bgfx_callback_interface_t *, bgfx_fatal_t, char *)")
    public BGFXFatalCallback fatal() {
        return BGFXCallbackVtbl.nfatal(this.address());
    }

    @NativeType(value="void (*) (bgfx_callback_interface_t *, char const *, uint16_t, char const *, va_list)")
    public BGFXTraceVarArgsCallback trace_vargs() {
        return BGFXCallbackVtbl.ntrace_vargs(this.address());
    }

    @NativeType(value="void (*) (bgfx_callback_interface_t *, char const *, uint32_t, char const *, uint16_t)")
    public BGFXProfilerBegin profiler_begin() {
        return BGFXCallbackVtbl.nprofiler_begin(this.address());
    }

    @NativeType(value="void (*) (bgfx_callback_interface_t *, char const *, uint32_t, char const *, uint16_t)")
    public BGFXProfilerBeginLiteral profiler_begin_literal() {
        return BGFXCallbackVtbl.nprofiler_begin_literal(this.address());
    }

    @NativeType(value="void (*) (bgfx_callback_interface_t *)")
    public BGFXProfilerEnd profiler_end() {
        return BGFXCallbackVtbl.nprofiler_end(this.address());
    }

    @NativeType(value="uint32_t (*) (bgfx_callback_interface_t *, uint64_t)")
    public BGFXCacheReadSizeCallback cache_read_size() {
        return BGFXCallbackVtbl.ncache_read_size(this.address());
    }

    @NativeType(value="bool (*) (bgfx_callback_interface_t *, uint64_t, void *, uint32_t)")
    public BGFXCacheReadCallback cache_read() {
        return BGFXCallbackVtbl.ncache_read(this.address());
    }

    @NativeType(value="void (*) (bgfx_callback_interface_t *, uint64_t, void const *, uint32_t)")
    public BGFXCacheWriteCallback cache_write() {
        return BGFXCallbackVtbl.ncache_write(this.address());
    }

    @NativeType(value="void (*) (bgfx_callback_interface_t *, char const *, uint32_t, uint32_t, uint32_t, void const *, uint32_t, bool)")
    public BGFXScreenShotCallback screen_shot() {
        return BGFXCallbackVtbl.nscreen_shot(this.address());
    }

    @NativeType(value="void (*) (bgfx_callback_interface_t *, uint32_t, uint32_t, uint32_t, bgfx_texture_format_t, bool)")
    public BGFXCaptureBeginCallback capture_begin() {
        return BGFXCallbackVtbl.ncapture_begin(this.address());
    }

    @NativeType(value="void (*) (bgfx_callback_interface_t *)")
    public BGFXCaptureEndCallback capture_end() {
        return BGFXCallbackVtbl.ncapture_end(this.address());
    }

    @NativeType(value="void (*) (bgfx_callback_interface_t *, void const *, uint32_t)")
    public BGFXCaptureFrameCallback capture_frame() {
        return BGFXCallbackVtbl.ncapture_frame(this.address());
    }

    public BGFXCallbackVtbl fatal(@NativeType(value="void (*) (bgfx_callback_interface_t *, bgfx_fatal_t, char *)") BGFXFatalCallbackI value) {
        BGFXCallbackVtbl.nfatal(this.address(), value);
        return this;
    }

    public BGFXCallbackVtbl trace_vargs(@NativeType(value="void (*) (bgfx_callback_interface_t *, char const *, uint16_t, char const *, va_list)") BGFXTraceVarArgsCallbackI value) {
        BGFXCallbackVtbl.ntrace_vargs(this.address(), value);
        return this;
    }

    public BGFXCallbackVtbl profiler_begin(@NativeType(value="void (*) (bgfx_callback_interface_t *, char const *, uint32_t, char const *, uint16_t)") BGFXProfilerBeginI value) {
        BGFXCallbackVtbl.nprofiler_begin(this.address(), value);
        return this;
    }

    public BGFXCallbackVtbl profiler_begin_literal(@NativeType(value="void (*) (bgfx_callback_interface_t *, char const *, uint32_t, char const *, uint16_t)") BGFXProfilerBeginLiteralI value) {
        BGFXCallbackVtbl.nprofiler_begin_literal(this.address(), value);
        return this;
    }

    public BGFXCallbackVtbl profiler_end(@NativeType(value="void (*) (bgfx_callback_interface_t *)") BGFXProfilerEndI value) {
        BGFXCallbackVtbl.nprofiler_end(this.address(), value);
        return this;
    }

    public BGFXCallbackVtbl cache_read_size(@NativeType(value="uint32_t (*) (bgfx_callback_interface_t *, uint64_t)") BGFXCacheReadSizeCallbackI value) {
        BGFXCallbackVtbl.ncache_read_size(this.address(), value);
        return this;
    }

    public BGFXCallbackVtbl cache_read(@NativeType(value="bool (*) (bgfx_callback_interface_t *, uint64_t, void *, uint32_t)") BGFXCacheReadCallbackI value) {
        BGFXCallbackVtbl.ncache_read(this.address(), value);
        return this;
    }

    public BGFXCallbackVtbl cache_write(@NativeType(value="void (*) (bgfx_callback_interface_t *, uint64_t, void const *, uint32_t)") BGFXCacheWriteCallbackI value) {
        BGFXCallbackVtbl.ncache_write(this.address(), value);
        return this;
    }

    public BGFXCallbackVtbl screen_shot(@NativeType(value="void (*) (bgfx_callback_interface_t *, char const *, uint32_t, uint32_t, uint32_t, void const *, uint32_t, bool)") BGFXScreenShotCallbackI value) {
        BGFXCallbackVtbl.nscreen_shot(this.address(), value);
        return this;
    }

    public BGFXCallbackVtbl capture_begin(@NativeType(value="void (*) (bgfx_callback_interface_t *, uint32_t, uint32_t, uint32_t, bgfx_texture_format_t, bool)") BGFXCaptureBeginCallbackI value) {
        BGFXCallbackVtbl.ncapture_begin(this.address(), value);
        return this;
    }

    public BGFXCallbackVtbl capture_end(@NativeType(value="void (*) (bgfx_callback_interface_t *)") BGFXCaptureEndCallbackI value) {
        BGFXCallbackVtbl.ncapture_end(this.address(), value);
        return this;
    }

    public BGFXCallbackVtbl capture_frame(@NativeType(value="void (*) (bgfx_callback_interface_t *, void const *, uint32_t)") BGFXCaptureFrameCallbackI value) {
        BGFXCallbackVtbl.ncapture_frame(this.address(), value);
        return this;
    }

    public BGFXCallbackVtbl set(BGFXFatalCallbackI fatal, BGFXTraceVarArgsCallbackI trace_vargs, BGFXProfilerBeginI profiler_begin, BGFXProfilerBeginLiteralI profiler_begin_literal, BGFXProfilerEndI profiler_end, BGFXCacheReadSizeCallbackI cache_read_size, BGFXCacheReadCallbackI cache_read, BGFXCacheWriteCallbackI cache_write, BGFXScreenShotCallbackI screen_shot, BGFXCaptureBeginCallbackI capture_begin, BGFXCaptureEndCallbackI capture_end, BGFXCaptureFrameCallbackI capture_frame) {
        this.fatal(fatal);
        this.trace_vargs(trace_vargs);
        this.profiler_begin(profiler_begin);
        this.profiler_begin_literal(profiler_begin_literal);
        this.profiler_end(profiler_end);
        this.cache_read_size(cache_read_size);
        this.cache_read(cache_read);
        this.cache_write(cache_write);
        this.screen_shot(screen_shot);
        this.capture_begin(capture_begin);
        this.capture_end(capture_end);
        this.capture_frame(capture_frame);
        return this;
    }

    public BGFXCallbackVtbl set(BGFXCallbackVtbl src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXCallbackVtbl malloc() {
        return BGFXCallbackVtbl.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static BGFXCallbackVtbl calloc() {
        return BGFXCallbackVtbl.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static BGFXCallbackVtbl create() {
        return new BGFXCallbackVtbl(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static BGFXCallbackVtbl create(long address) {
        return new BGFXCallbackVtbl(address, null);
    }

    @Nullable
    public static BGFXCallbackVtbl createSafe(long address) {
        return address == 0L ? null : BGFXCallbackVtbl.create(address);
    }

    public static BGFXCallbackVtbl mallocStack() {
        return BGFXCallbackVtbl.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXCallbackVtbl callocStack() {
        return BGFXCallbackVtbl.callocStack(MemoryStack.stackGet());
    }

    public static BGFXCallbackVtbl mallocStack(MemoryStack stack) {
        return BGFXCallbackVtbl.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXCallbackVtbl callocStack(MemoryStack stack) {
        return BGFXCallbackVtbl.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static BGFXFatalCallback nfatal(long struct) {
        return BGFXFatalCallback.create(MemoryUtil.memGetAddress(struct + (long)FATAL));
    }

    public static BGFXTraceVarArgsCallback ntrace_vargs(long struct) {
        return BGFXTraceVarArgsCallback.create(MemoryUtil.memGetAddress(struct + (long)TRACE_VARGS));
    }

    public static BGFXProfilerBegin nprofiler_begin(long struct) {
        return BGFXProfilerBegin.create(MemoryUtil.memGetAddress(struct + (long)PROFILER_BEGIN));
    }

    public static BGFXProfilerBeginLiteral nprofiler_begin_literal(long struct) {
        return BGFXProfilerBeginLiteral.create(MemoryUtil.memGetAddress(struct + (long)PROFILER_BEGIN_LITERAL));
    }

    public static BGFXProfilerEnd nprofiler_end(long struct) {
        return BGFXProfilerEnd.create(MemoryUtil.memGetAddress(struct + (long)PROFILER_END));
    }

    public static BGFXCacheReadSizeCallback ncache_read_size(long struct) {
        return BGFXCacheReadSizeCallback.create(MemoryUtil.memGetAddress(struct + (long)CACHE_READ_SIZE));
    }

    public static BGFXCacheReadCallback ncache_read(long struct) {
        return BGFXCacheReadCallback.create(MemoryUtil.memGetAddress(struct + (long)CACHE_READ));
    }

    public static BGFXCacheWriteCallback ncache_write(long struct) {
        return BGFXCacheWriteCallback.create(MemoryUtil.memGetAddress(struct + (long)CACHE_WRITE));
    }

    public static BGFXScreenShotCallback nscreen_shot(long struct) {
        return BGFXScreenShotCallback.create(MemoryUtil.memGetAddress(struct + (long)SCREEN_SHOT));
    }

    public static BGFXCaptureBeginCallback ncapture_begin(long struct) {
        return BGFXCaptureBeginCallback.create(MemoryUtil.memGetAddress(struct + (long)CAPTURE_BEGIN));
    }

    public static BGFXCaptureEndCallback ncapture_end(long struct) {
        return BGFXCaptureEndCallback.create(MemoryUtil.memGetAddress(struct + (long)CAPTURE_END));
    }

    public static BGFXCaptureFrameCallback ncapture_frame(long struct) {
        return BGFXCaptureFrameCallback.create(MemoryUtil.memGetAddress(struct + (long)CAPTURE_FRAME));
    }

    public static void nfatal(long struct, BGFXFatalCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)FATAL, value.address());
    }

    public static void ntrace_vargs(long struct, BGFXTraceVarArgsCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)TRACE_VARGS, value.address());
    }

    public static void nprofiler_begin(long struct, BGFXProfilerBeginI value) {
        MemoryUtil.memPutAddress(struct + (long)PROFILER_BEGIN, value.address());
    }

    public static void nprofiler_begin_literal(long struct, BGFXProfilerBeginLiteralI value) {
        MemoryUtil.memPutAddress(struct + (long)PROFILER_BEGIN_LITERAL, value.address());
    }

    public static void nprofiler_end(long struct, BGFXProfilerEndI value) {
        MemoryUtil.memPutAddress(struct + (long)PROFILER_END, value.address());
    }

    public static void ncache_read_size(long struct, BGFXCacheReadSizeCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)CACHE_READ_SIZE, value.address());
    }

    public static void ncache_read(long struct, BGFXCacheReadCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)CACHE_READ, value.address());
    }

    public static void ncache_write(long struct, BGFXCacheWriteCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)CACHE_WRITE, value.address());
    }

    public static void nscreen_shot(long struct, BGFXScreenShotCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)SCREEN_SHOT, value.address());
    }

    public static void ncapture_begin(long struct, BGFXCaptureBeginCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)CAPTURE_BEGIN, value.address());
    }

    public static void ncapture_end(long struct, BGFXCaptureEndCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)CAPTURE_END, value.address());
    }

    public static void ncapture_frame(long struct, BGFXCaptureFrameCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)CAPTURE_FRAME, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)FATAL));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)TRACE_VARGS));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PROFILER_BEGIN));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PROFILER_BEGIN_LITERAL));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PROFILER_END));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CACHE_READ_SIZE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CACHE_READ));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CACHE_WRITE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SCREEN_SHOT));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CAPTURE_BEGIN));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CAPTURE_END));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CAPTURE_FRAME));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            BGFXCallbackVtbl.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = BGFXCallbackVtbl.__struct(BGFXCallbackVtbl.__member(POINTER_SIZE), BGFXCallbackVtbl.__member(POINTER_SIZE), BGFXCallbackVtbl.__member(POINTER_SIZE), BGFXCallbackVtbl.__member(POINTER_SIZE), BGFXCallbackVtbl.__member(POINTER_SIZE), BGFXCallbackVtbl.__member(POINTER_SIZE), BGFXCallbackVtbl.__member(POINTER_SIZE), BGFXCallbackVtbl.__member(POINTER_SIZE), BGFXCallbackVtbl.__member(POINTER_SIZE), BGFXCallbackVtbl.__member(POINTER_SIZE), BGFXCallbackVtbl.__member(POINTER_SIZE), BGFXCallbackVtbl.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FATAL = layout.offsetof(0);
        TRACE_VARGS = layout.offsetof(1);
        PROFILER_BEGIN = layout.offsetof(2);
        PROFILER_BEGIN_LITERAL = layout.offsetof(3);
        PROFILER_END = layout.offsetof(4);
        CACHE_READ_SIZE = layout.offsetof(5);
        CACHE_READ = layout.offsetof(6);
        CACHE_WRITE = layout.offsetof(7);
        SCREEN_SHOT = layout.offsetof(8);
        CAPTURE_BEGIN = layout.offsetof(9);
        CAPTURE_END = layout.offsetof(10);
        CAPTURE_FRAME = layout.offsetof(11);
    }
}

