/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.bgfx.BGFXCallbackVtbl;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct bgfx_callback_interface_t")
public class BGFXCallbackInterface
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VTBL;

    BGFXCallbackInterface(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public BGFXCallbackInterface(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXCallbackInterface.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bgfx_callback_vtbl_t const *")
    public BGFXCallbackVtbl vtbl() {
        return BGFXCallbackInterface.nvtbl(this.address());
    }

    public BGFXCallbackInterface vtbl(@NativeType(value="bgfx_callback_vtbl_t const *") BGFXCallbackVtbl value) {
        BGFXCallbackInterface.nvtbl(this.address(), value);
        return this;
    }

    public BGFXCallbackInterface set(BGFXCallbackInterface src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXCallbackInterface malloc() {
        return BGFXCallbackInterface.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static BGFXCallbackInterface calloc() {
        return BGFXCallbackInterface.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static BGFXCallbackInterface create() {
        return new BGFXCallbackInterface(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static BGFXCallbackInterface create(long address) {
        return new BGFXCallbackInterface(address, null);
    }

    @Nullable
    public static BGFXCallbackInterface createSafe(long address) {
        return address == 0L ? null : BGFXCallbackInterface.create(address);
    }

    public static BGFXCallbackInterface mallocStack() {
        return BGFXCallbackInterface.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXCallbackInterface callocStack() {
        return BGFXCallbackInterface.callocStack(MemoryStack.stackGet());
    }

    public static BGFXCallbackInterface mallocStack(MemoryStack stack) {
        return BGFXCallbackInterface.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXCallbackInterface callocStack(MemoryStack stack) {
        return BGFXCallbackInterface.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static BGFXCallbackVtbl nvtbl(long struct) {
        return BGFXCallbackVtbl.create(MemoryUtil.memGetAddress(struct + (long)VTBL));
    }

    public static void nvtbl(long struct, BGFXCallbackVtbl value) {
        MemoryUtil.memPutAddress(struct + (long)VTBL, value.address());
    }

    public static void validate(long struct) {
        long vtbl = MemoryUtil.memGetAddress(struct + (long)VTBL);
        Checks.check(vtbl);
        BGFXCallbackVtbl.validate(vtbl);
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            BGFXCallbackInterface.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = BGFXCallbackInterface.__struct(BGFXCallbackInterface.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VTBL = layout.offsetof(0);
    }
}

