/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.bgfx.BGFXReallocCallback;
import org.lwjgl.bgfx.BGFXReallocCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_allocator_vtbl_t")
public class BGFXAllocatorVtbl
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int REALLOC;

    BGFXAllocatorVtbl(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public BGFXAllocatorVtbl(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXAllocatorVtbl.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void * (*) (bgfx_allocator_interface_t *, void *, size_t, size_t, char *, uint32_t)")
    public BGFXReallocCallback realloc() {
        return BGFXAllocatorVtbl.nrealloc(this.address());
    }

    public BGFXAllocatorVtbl realloc(@NativeType(value="void * (*) (bgfx_allocator_interface_t *, void *, size_t, size_t, char *, uint32_t)") BGFXReallocCallbackI value) {
        BGFXAllocatorVtbl.nrealloc(this.address(), value);
        return this;
    }

    public BGFXAllocatorVtbl set(BGFXAllocatorVtbl src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXAllocatorVtbl malloc() {
        return BGFXAllocatorVtbl.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static BGFXAllocatorVtbl calloc() {
        return BGFXAllocatorVtbl.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static BGFXAllocatorVtbl create() {
        return new BGFXAllocatorVtbl(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static BGFXAllocatorVtbl create(long address) {
        return new BGFXAllocatorVtbl(address, null);
    }

    @Nullable
    public static BGFXAllocatorVtbl createSafe(long address) {
        return address == 0L ? null : BGFXAllocatorVtbl.create(address);
    }

    public static Buffer malloc(int capacity) {
        return BGFXAllocatorVtbl.create(BGFXAllocatorVtbl.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXAllocatorVtbl.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BGFXAllocatorVtbl.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : BGFXAllocatorVtbl.create(address, capacity);
    }

    public static BGFXAllocatorVtbl mallocStack() {
        return BGFXAllocatorVtbl.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXAllocatorVtbl callocStack() {
        return BGFXAllocatorVtbl.callocStack(MemoryStack.stackGet());
    }

    public static BGFXAllocatorVtbl mallocStack(MemoryStack stack) {
        return BGFXAllocatorVtbl.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXAllocatorVtbl callocStack(MemoryStack stack) {
        return BGFXAllocatorVtbl.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return BGFXAllocatorVtbl.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return BGFXAllocatorVtbl.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXAllocatorVtbl.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXAllocatorVtbl.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static BGFXReallocCallback nrealloc(long struct) {
        return BGFXReallocCallback.create(MemoryUtil.memGetAddress(struct + (long)REALLOC));
    }

    public static void nrealloc(long struct, BGFXReallocCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)REALLOC, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)REALLOC));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            BGFXAllocatorVtbl.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = BGFXAllocatorVtbl.__struct(BGFXAllocatorVtbl.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        REALLOC = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<BGFXAllocatorVtbl, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXAllocatorVtbl newInstance(long address) {
            return new BGFXAllocatorVtbl(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="void * (*) (bgfx_allocator_interface_t *, void *, size_t, size_t, char *, uint32_t)")
        public BGFXReallocCallback realloc() {
            return BGFXAllocatorVtbl.nrealloc(this.address());
        }

        public Buffer realloc(@NativeType(value="void * (*) (bgfx_allocator_interface_t *, void *, size_t, size_t, char *, uint32_t)") BGFXReallocCallbackI value) {
            BGFXAllocatorVtbl.nrealloc(this.address(), value);
            return this;
        }
    }
}

