/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.assimp.AIColor4D;
import org.lwjgl.assimp.AIExportDataBlob;
import org.lwjgl.assimp.AIExportFormatDesc;
import org.lwjgl.assimp.AIFileIO;
import org.lwjgl.assimp.AIImporterDesc;
import org.lwjgl.assimp.AILogStream;
import org.lwjgl.assimp.AIMaterial;
import org.lwjgl.assimp.AIMatrix3x3;
import org.lwjgl.assimp.AIMatrix4x4;
import org.lwjgl.assimp.AIMemoryInfo;
import org.lwjgl.assimp.AIPropertyStore;
import org.lwjgl.assimp.AIQuaternion;
import org.lwjgl.assimp.AIScene;
import org.lwjgl.assimp.AIString;
import org.lwjgl.assimp.AIUVTransform;
import org.lwjgl.assimp.AIVector3D;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;

public class Assimp {
    public static final String AI_CONFIG_GLOB_MEASURE_TIME = "GLOB_MEASURE_TIME";
    public static final String AI_CONFIG_IMPORT_NO_SKELETON_MESHES = "IMPORT_NO_SKELETON_MESHES";
    public static final String AI_CONFIG_PP_SBBC_MAX_BONES = "PP_SBBC_MAX_BONES";
    public static final String AI_CONFIG_PP_CT_MAX_SMOOTHING_ANGLE = "PP_CT_MAX_SMOOTHING_ANGLE";
    public static final String AI_CONFIG_PP_CT_TEXTURE_CHANNEL_INDEX = "PP_CT_TEXTURE_CHANNEL_INDEX";
    public static final String AI_CONFIG_PP_GSN_MAX_SMOOTHING_ANGLE = "PP_GSN_MAX_SMOOTHING_ANGLE";
    public static final String AI_CONFIG_IMPORT_MDL_COLORMAP = "IMPORT_MDL_COLORMAP";
    public static final String AI_CONFIG_PP_RRM_EXCLUDE_LIST = "PP_RRM_EXCLUDE_LIST";
    public static final String AI_CONFIG_PP_PTV_KEEP_HIERARCHY = "PP_PTV_KEEP_HIERARCHY";
    public static final String AI_CONFIG_PP_PTV_NORMALIZE = "PP_PTV_NORMALIZE";
    public static final String AI_CONFIG_PP_PTV_ADD_ROOT_TRANSFORMATION = "PP_PTV_ADD_ROOT_TRANSFORMATION";
    public static final String AI_CONFIG_PP_PTV_ROOT_TRANSFORMATION = "PP_PTV_ROOT_TRANSFORMATION";
    public static final String AI_CONFIG_PP_FD_REMOVE = "PP_FD_REMOVE";
    public static final String AI_CONFIG_PP_FD_CHECKAREA = "PP_FD_CHECKAREA";
    public static final String AI_CONFIG_PP_OG_EXCLUDE_LIST = "PP_OG_EXCLUDE_LIST";
    public static final String AI_CONFIG_PP_SLM_TRIANGLE_LIMIT = "PP_SLM_TRIANGLE_LIMIT";
    public static final String AI_CONFIG_PP_SLM_VERTEX_LIMIT = "PP_SLM_VERTEX_LIMIT";
    public static final String AI_CONFIG_PP_LBW_MAX_WEIGHTS = "PP_LBW_MAX_WEIGHTS";
    public static final String AI_CONFIG_PP_DB_THRESHOLD = "PP_DB_THRESHOLD";
    public static final String AI_CONFIG_PP_DB_ALL_OR_NONE = "PP_DB_ALL_OR_NONE";
    public static final String AI_CONFIG_PP_ICL_PTCACHE_SIZE = "PP_ICL_PTCACHE_SIZE";
    public static final String AI_CONFIG_PP_RVC_FLAGS = "PP_RVC_FLAGS";
    public static final String AI_CONFIG_PP_SBP_REMOVE = "PP_SBP_REMOVE";
    public static final String AI_CONFIG_PP_FID_ANIM_ACCURACY = "PP_FID_ANIM_ACCURACY";
    public static final String AI_CONFIG_PP_TUV_EVALUATE = "PP_TUV_EVALUATE";
    public static final String AI_CONFIG_FAVOUR_SPEED = "FAVOUR_SPEED";
    public static final String AI_CONFIG_IMPORT_FBX_READ_ALL_GEOMETRY_LAYERS = "IMPORT_FBX_READ_ALL_GEOMETRY_LAYERS";
    public static final String AI_CONFIG_IMPORT_FBX_READ_ALL_MATERIALS = "IMPORT_FBX_READ_ALL_MATERIALS";
    public static final String AI_CONFIG_IMPORT_FBX_READ_MATERIALS = "IMPORT_FBX_READ_MATERIALS";
    public static final String AI_CONFIG_IMPORT_FBX_READ_TEXTURES = "IMPORT_FBX_READ_TEXTURES";
    public static final String AI_CONFIG_IMPORT_FBX_READ_CAMERAS = "IMPORT_FBX_READ_CAMERAS";
    public static final String AI_CONFIG_IMPORT_FBX_READ_LIGHTS = "IMPORT_FBX_READ_LIGHTS";
    public static final String AI_CONFIG_IMPORT_FBX_READ_ANIMATIONS = "IMPORT_FBX_READ_ANIMATIONS";
    public static final String AI_CONFIG_IMPORT_FBX_STRICT_MODE = "IMPORT_FBX_STRICT_MODE";
    public static final String AI_CONFIG_IMPORT_FBX_PRESERVE_PIVOTS = "IMPORT_FBX_PRESERVE_PIVOTS";
    public static final String AI_CONFIG_IMPORT_FBX_OPTIMIZE_EMPTY_ANIMATION_CURVES = "IMPORT_FBX_OPTIMIZE_EMPTY_ANIMATION_CURVES";
    public static final String AI_CONFIG_IMPORT_FBX_EMBEDDED_TEXTURES_LEGACY_NAMING = "AI_CONFIG_IMPORT_FBX_EMBEDDED_TEXTURES_LEGACY_NAMING";
    public static final String AI_CONFIG_IMPORT_GLOBAL_KEYFRAME = "IMPORT_GLOBAL_KEYFRAME";
    public static final String AI_CONFIG_IMPORT_MD3_KEYFRAME = "IMPORT_MD3_KEYFRAME";
    public static final String AI_CONFIG_IMPORT_MD2_KEYFRAME = "IMPORT_MD2_KEYFRAME";
    public static final String AI_CONFIG_IMPORT_MDL_KEYFRAME = "IMPORT_MDL_KEYFRAME";
    public static final String AI_CONFIG_IMPORT_MDC_KEYFRAME = "IMPORT_MDC_KEYFRAME";
    public static final String AI_CONFIG_IMPORT_SMD_KEYFRAME = "IMPORT_SMD_KEYFRAME";
    public static final String AI_CONFIG_IMPORT_UNREAL_KEYFRAME = "IMPORT_UNREAL_KEYFRAME";
    public static final String AI_CONFIG_IMPORT_AC_SEPARATE_BFCULL = "IMPORT_AC_SEPARATE_BFCULL";
    public static final String AI_CONFIG_IMPORT_AC_EVAL_SUBDIVISION = "IMPORT_AC_EVAL_SUBDIVISION";
    public static final String AI_CONFIG_UNREAL_HANDLE_FLAGS = "UNREAL_HANDLE_FLAGS";
    public static final String AI_CONFIG_IMPORT_TER_MAKE_UVS = "IMPORT_TER_MAKE_UVS";
    public static final String AI_CONFIG_IMPORT_ASE_RECONSTRUCT_NORMALS = "IMPORT_ASE_RECONSTRUCT_NORMALS";
    public static final String AI_CONFIG_IMPORT_MD3_HANDLE_MULTIPART = "IMPORT_MD3_HANDLE_MULTIPART";
    public static final String AI_CONFIG_IMPORT_MD3_SKIN_NAME = "IMPORT_MD3_SKIN_NAME";
    public static final String AI_CONFIG_IMPORT_MD3_SHADER_SRC = "IMPORT_MD3_SHADER_SRC";
    public static final String AI_CONFIG_IMPORT_LWO_ONE_LAYER_ONLY = "IMPORT_LWO_ONE_LAYER_ONLY";
    public static final String AI_CONFIG_IMPORT_MD5_NO_ANIM_AUTOLOAD = "IMPORT_MD5_NO_ANIM_AUTOLOAD";
    public static final String AI_CONFIG_IMPORT_LWS_ANIM_START = "IMPORT_LWS_ANIM_START";
    public static final String AI_CONFIG_IMPORT_LWS_ANIM_END = "IMPORT_LWS_ANIM_END";
    public static final String AI_CONFIG_IMPORT_IRR_ANIM_FPS = "IMPORT_IRR_ANIM_FPS";
    public static final String AI_CONFIG_IMPORT_OGRE_MATERIAL_FILE = "IMPORT_OGRE_MATERIAL_FILE";
    public static final String AI_CONFIG_IMPORT_OGRE_TEXTURETYPE_FROM_FILENAME = "IMPORT_OGRE_TEXTURETYPE_FROM_FILENAME";
    public static final String AI_CONFIG_IMPORT_IFC_SKIP_SPACE_REPRESENTATIONS = "IMPORT_IFC_SKIP_SPACE_REPRESENTATIONS";
    public static final String AI_CONFIG_ANDROID_JNI_ASSIMP_MANAGER_SUPPORT = "AI_CONFIG_ANDROID_JNI_ASSIMP_MANAGER_SUPPORT";
    public static final String AI_CONFIG_IMPORT_IFC_SKIP_CURVE_REPRESENTATIONS = "IMPORT_IFC_SKIP_CURVE_REPRESENTATIONS";
    public static final String AI_CONFIG_IMPORT_IFC_CUSTOM_TRIANGULATION = "IMPORT_IFC_CUSTOM_TRIANGULATION";
    public static final String AI_CONFIG_IMPORT_IFC_SMOOTHING_ANGLE = "IMPORT_IFC_SMOOTHING_ANGLE";
    public static final String AI_CONFIG_IMPORT_IFC_CYLINDRICAL_TESSELLATION = "IMPORT_IFC_CYLINDRICAL_TESSELLATION";
    public static final String AI_CONFIG_IMPORT_COLLADA_IGNORE_UP_DIRECTION = "IMPORT_COLLADA_IGNORE_UP_DIRECTION";
    public static final String AI_CONFIG_IMPORT_COLLADA_USE_COLLADA_NAMES = "IMPORT_COLLADA_USE_COLLADA_NAMES";
    public static final String AI_CONFIG_EXPORT_XFILE_64BIT = "EXPORT_XFILE_64BIT";
    public static final String AI_CONFIG_EXPORT_POINT_CLOUDS = "EXPORT_POINT_CLOUDS";
    public static final String AI_CONFIG_GLOBAL_SCALE_FACTOR_KEY = "GLOBAL_SCALE_FACTOR";
    public static final int AI_SBBC_DEFAULT_MAX_BONES = 60;
    public static final int AI_SLM_DEFAULT_MAX_TRIANGLES = 1000000;
    public static final int AI_SLM_DEFAULT_MAX_VERTICES = 1000000;
    public static final int AI_LBW_MAX_WEIGHTS = 4;
    public static final int PP_ICL_PTCACHE_SIZE = 12;
    public static final int AI_IMPORT_IFC_DEFAULT_CYLINDRICAL_TESSELLATION = 32;
    public static final float AI_DEBONE_THRESHOLD = 1.0f;
    public static final float AI_IMPORT_IFC_DEFAULT_SMOOTHING_ANGLE = 10.0f;
    public static final float AI_CONFIG_GLOBAL_SCALE_FACTOR_DEFAULT = 1.0f;
    public static final int AI_UVTRAFO_SCALING = 1;
    public static final int AI_UVTRAFO_ROTATION = 2;
    public static final int AI_UVTRAFO_TRANSLATION = 4;
    public static final int AI_UVTRAFO_ALL = 7;
    public static final int aiComponent_NORMALS = 2;
    public static final int aiComponent_TANGENTS_AND_BITANGENTS = 4;
    public static final int aiComponent_COLORS = 8;
    public static final int aiComponent_TEXCOORDS = 16;
    public static final int aiComponent_BONEWEIGHTS = 32;
    public static final int aiComponent_ANIMATIONS = 64;
    public static final int aiComponent_TEXTURES = 128;
    public static final int aiComponent_LIGHTS = 256;
    public static final int aiComponent_CAMERAS = 512;
    public static final int aiComponent_MESHES = 1024;
    public static final int aiComponent_MATERIALS = 2048;
    public static final double AI_MATH_PI = Math.PI;
    public static final double AI_MATH_TWO_PI = Math.PI * 2;
    public static final double AI_MATH_HALF_PI = 1.5707963267948966;
    public static final float AI_MATH_PI_F = (float)Math.PI;
    public static final float AI_MATH_TWO_PI_F = (float)Math.PI * 2;
    public static final float AI_MATH_HALF_PI_F = 0.0f;
    public static final int MAXLEN = 1024;
    public static final int aiReturn_SUCCESS = 0;
    public static final int aiReturn_FAILURE = -1;
    public static final int aiReturn_OUTOFMEMORY = -3;
    public static final int aiOrigin_SET = 0;
    public static final int aiOrigin_CUR = 1;
    public static final int aiOrigin_END = 2;
    public static final int aiDefaultLogStream_FILE = 1;
    public static final int aiDefaultLogStream_STDOUT = 2;
    public static final int aiDefaultLogStream_STDERR = 4;
    public static final int aiDefaultLogStream_DEBUGGER = 8;
    public static final int aiAnimBehaviour_DEFAULT = 0;
    public static final int aiAnimBehaviour_CONSTANT = 1;
    public static final int aiAnimBehaviour_LINEAR = 2;
    public static final int aiAnimBehaviour_REPEAT = 3;
    public static final int AI_TRUE = 1;
    public static final int AI_FALSE = 0;
    public static final int aiImporterFlags_SupportTextFlavour = 1;
    public static final int aiImporterFlags_SupportBinaryFlavour = 2;
    public static final int aiImporterFlags_SupportCompressedFlavour = 4;
    public static final int aiImporterFlags_LimitedSupport = 8;
    public static final int aiImporterFlags_Experimental = 16;
    public static final int aiLightSource_UNDEFINED = 0;
    public static final int aiLightSource_DIRECTIONAL = 1;
    public static final int aiLightSource_POINT = 2;
    public static final int aiLightSource_SPOT = 3;
    public static final int aiLightSource_AMBIENT = 4;
    public static final int aiLightSource_AREA = 5;
    public static final String AI_DEFAULT_MATERIAL_NAME = "DefaultMaterial";
    public static final int aiTextureOp_Multiply = 0;
    public static final int aiTextureOp_Add = 1;
    public static final int aiTextureOp_Subtract = 2;
    public static final int aiTextureOp_Divide = 3;
    public static final int aiTextureOp_SmoothAdd = 4;
    public static final int aiTextureOp_SignedAdd = 5;
    public static final int aiTextureMapMode_Wrap = 0;
    public static final int aiTextureMapMode_Clamp = 1;
    public static final int aiTextureMapMode_Decal = 3;
    public static final int aiTextureMapMode_Mirror = 2;
    public static final int aiTextureMapping_UV = 0;
    public static final int aiTextureMapping_SPHERE = 1;
    public static final int aiTextureMapping_CYLINDER = 2;
    public static final int aiTextureMapping_BOX = 3;
    public static final int aiTextureMapping_PLANE = 4;
    public static final int aiTextureMapping_OTHER = 5;
    public static final int aiTextureType_NONE = 0;
    public static final int aiTextureType_DIFFUSE = 1;
    public static final int aiTextureType_SPECULAR = 2;
    public static final int aiTextureType_AMBIENT = 3;
    public static final int aiTextureType_EMISSIVE = 4;
    public static final int aiTextureType_HEIGHT = 5;
    public static final int aiTextureType_NORMALS = 6;
    public static final int aiTextureType_SHININESS = 7;
    public static final int aiTextureType_OPACITY = 8;
    public static final int aiTextureType_DISPLACEMENT = 9;
    public static final int aiTextureType_LIGHTMAP = 10;
    public static final int aiTextureType_REFLECTION = 11;
    public static final int aiTextureType_UNKNOWN = 12;
    public static final int aiShadingMode_Fflat = 1;
    public static final int aiShadingMode_Gouraud = 2;
    public static final int aiShadingMode_Phong = 3;
    public static final int aiShadingMode_Blinn = 4;
    public static final int aiShadingMode_Toon = 5;
    public static final int aiShadingMode_OrenNayar = 6;
    public static final int aiShadingMode_Minnaert = 7;
    public static final int aiShadingMode_CookTorrance = 8;
    public static final int aiShadingMode_NoShading = 9;
    public static final int aiShadingMode_Fresnel = 10;
    public static final int aiTextureFlags_Invert = 1;
    public static final int aiTextureFlags_UseAlpha = 2;
    public static final int aiTextureFlags_IgnoreAlpha = 2;
    public static final int aiBlendMode_Default = 0;
    public static final int aiBlendMode_Additive = 1;
    public static final int aiPTI_Float = 1;
    public static final int aiPTI_Double = 2;
    public static final int aiPTI_String = 3;
    public static final int aiPTI_Integer = 4;
    public static final int aiPTI_Buffer = 5;
    public static final String AI_MATKEY_NAME = "?mat.name";
    public static final String AI_MATKEY_TWOSIDED = "$mat.twosided";
    public static final String AI_MATKEY_SHADING_MODEL = "$mat.shadingm";
    public static final String AI_MATKEY_ENABLE_WIREFRAME = "$mat.wireframe";
    public static final String AI_MATKEY_BLEND_FUNC = "$mat.blend";
    public static final String AI_MATKEY_OPACITY = "$mat.opacity";
    public static final String AI_MATKEY_BUMPSCALING = "$mat.bumpscaling";
    public static final String AI_MATKEY_SHININESS = "$mat.shininess";
    public static final String AI_MATKEY_REFLECTIVITY = "$mat.reflectivity";
    public static final String AI_MATKEY_SHININESS_STRENGTH = "$mat.shinpercent";
    public static final String AI_MATKEY_REFRACTI = "$mat.refracti";
    public static final String AI_MATKEY_COLOR_DIFFUSE = "$clr.diffuse";
    public static final String AI_MATKEY_COLOR_AMBIENT = "$clr.ambient";
    public static final String AI_MATKEY_COLOR_SPECULAR = "$clr.specular";
    public static final String AI_MATKEY_COLOR_EMISSIVE = "$clr.emissive";
    public static final String AI_MATKEY_COLOR_TRANSPARENT = "$clr.transparent";
    public static final String AI_MATKEY_COLOR_REFLECTIVE = "$clr.reflective";
    public static final String AI_MATKEY_GLOBAL_BACKGROUND_IMAGE = "?bg.global";
    public static final String _AI_MATKEY_TEXTURE_BASE = "$tex.file";
    public static final String _AI_MATKEY_UVWSRC_BASE = "$tex.uvwsrc";
    public static final String _AI_MATKEY_TEXOP_BASE = "$tex.op";
    public static final String _AI_MATKEY_MAPPING_BASE = "$tex.mapping";
    public static final String _AI_MATKEY_TEXBLEND_BASE = "$tex.blend";
    public static final String _AI_MATKEY_MAPPINGMODE_U_BASE = "$tex.mapmodeu";
    public static final String _AI_MATKEY_MAPPINGMODE_V_BASE = "$tex.mapmodev";
    public static final String _AI_MATKEY_TEXMAP_AXIS_BASE = "$tex.mapaxis";
    public static final String _AI_MATKEY_UVTRANSFORM_BASE = "$tex.uvtrafo";
    public static final String _AI_MATKEY_TEXFLAGS_BASE = "$tex.flags";
    public static final String aiAI_MATKEY_GLTF_PBRMETALLICROUGHNESS_BASE_COLOR_FACTOR = "$mat.gltf.pbrMetallicRoughness.baseColorFactor";
    public static final String aiAI_MATKEY_GLTF_PBRMETALLICROUGHNESS_METALLIC_FACTOR = "$mat.gltf.pbrMetallicRoughness.metallicFactor";
    public static final String aiAI_MATKEY_GLTF_PBRMETALLICROUGHNESS_ROUGHNESS_FACTOR = "$mat.gltf.pbrMetallicRoughness.roughnessFactor";
    public static final String aiAI_MATKEY_GLTF_ALPHAMODE = "$mat.gltf.alphaMode";
    public static final String aiAI_MATKEY_GLTF_ALPHACUTOFF = "$mat.gltf.alphaCutoff";
    public static final String aiAI_MATKEY_GLTF_PBRSPECULARGLOSSINESS = "$mat.gltf.pbrSpecularGlossiness";
    public static final String aiAI_MATKEY_GLTF_PBRSPECULARGLOSSINESS_GLOSSINESS_FACTOR = "$mat.gltf.pbrMetallicRoughness.glossinessFactor";
    public static final String aiAI_MATKEY_GLTF_UNLIT = "$mat.gltf.unlit";
    public static final String ai_AI_MATKEY_GLTF_TEXTURE_TEXCOORD_BASE = "$tex.file.texCoord";
    public static final String ai_AI_MATKEY_GLTF_MAPPINGNAME_BASE = "$tex.mappingname";
    public static final String ai_AI_MATKEY_GLTF_MAPPINGID_BASE = "$tex.mappingid";
    public static final String ai_AI_MATKEY_GLTF_MAPPINGFILTER_MAG_BASE = "$tex.mappingfiltermag";
    public static final String ai_AI_MATKEY_GLTF_MAPPINGFILTER_MIN_BASE = "$tex.mappingfiltermin";
    public static final String ai_AI_MATKEY_GLTF_SCALE_BASE = "$tex.scale";
    public static final String ai_AI_MATKEY_GLTF_STRENGTH_BASE = "$tex.strength";
    public static final int AI_MATKEY_GLTF_PBRMETALLICROUGHNESS_BASE_COLOR_TEXTURE = 1;
    public static final int AI_MATKEY_GLTF_PBRMETALLICROUGHNESS_METALLICROUGHNESS_TEXTURE = 12;
    public static final int AI_MAX_FACE_INDICES = Short.MAX_VALUE;
    public static final int AI_MAX_BONE_WEIGHTS = Integer.MAX_VALUE;
    public static final int AI_MAX_VERTICES = Integer.MAX_VALUE;
    public static final int AI_MAX_FACES = Integer.MAX_VALUE;
    public static final int AI_MAX_NUMBER_OF_COLOR_SETS = 8;
    public static final int AI_MAX_NUMBER_OF_TEXTURECOORDS = 8;
    public static final int aiPrimitiveType_POINT = 1;
    public static final int aiPrimitiveType_LINE = 2;
    public static final int aiPrimitiveType_TRIANGLE = 4;
    public static final int aiPrimitiveType_POLYGON = 8;
    public static final int AI_BOOL = 0;
    public static final int AI_INT32 = 1;
    public static final int AI_UINT64 = 2;
    public static final int AI_FLOAT = 3;
    public static final int AI_DOUBLE = 4;
    public static final int AI_AISTRING = 5;
    public static final int AI_AIVECTOR3D = 6;
    public static final int AI_META_MAX = 7;
    public static final int aiProcess_CalcTangentSpace = 1;
    public static final int aiProcess_JoinIdenticalVertices = 2;
    public static final int aiProcess_MakeLeftHanded = 4;
    public static final int aiProcess_Triangulate = 8;
    public static final int aiProcess_RemoveComponent = 16;
    public static final int aiProcess_GenNormals = 32;
    public static final int aiProcess_GenSmoothNormals = 64;
    public static final int aiProcess_SplitLargeMeshes = 128;
    public static final int aiProcess_PreTransformVertices = 256;
    public static final int aiProcess_LimitBoneWeights = 512;
    public static final int aiProcess_ValidateDataStructure = 1024;
    public static final int aiProcess_ImproveCacheLocality = 2048;
    public static final int aiProcess_RemoveRedundantMaterials = 4096;
    public static final int aiProcess_FixInfacingNormals = 8192;
    public static final int aiProcess_SortByPType = 32768;
    public static final int aiProcess_FindDegenerates = 65536;
    public static final int aiProcess_FindInvalidData = 131072;
    public static final int aiProcess_GenUVCoords = 262144;
    public static final int aiProcess_TransformUVCoords = 524288;
    public static final int aiProcess_FindInstances = 0x100000;
    public static final int aiProcess_OptimizeMeshes = 0x200000;
    public static final int aiProcess_OptimizeGraph = 0x400000;
    public static final int aiProcess_FlipUVs = 0x800000;
    public static final int aiProcess_FlipWindingOrder = 0x1000000;
    public static final int aiProcess_SplitByBoneCount = 0x2000000;
    public static final int aiProcess_Debone = 0x4000000;
    public static final int aiProcess_GlobalScale = 0x8000000;
    public static final int aiProcess_EmbedTextures = 0x10000000;
    public static final int aiProcess_ForceGenNormals = 0x20000000;
    public static final int aiProcess_ConvertToLeftHanded = 25165828;
    public static final int aiProcessPreset_TargetRealtime_Fast = 294955;
    public static final int aiProcessPreset_TargetRealtime_Quality = 498379;
    public static final int aiProcessPreset_TargetRealtime_MaxQuality = 3644107;
    public static final int AI_SCENE_FLAGS_INCOMPLETE = 1;
    public static final int AI_SCENE_FLAGS_VALIDATED = 2;
    public static final int AI_SCENE_FLAGS_VALIDATION_WARNING = 4;
    public static final int AI_SCENE_FLAGS_NON_VERBOSE_FORMAT = 8;
    public static final int AI_SCENE_FLAGS_TERRAIN = 16;
    public static final int ASSIMP_CFLAGS_SHARED = 1;
    public static final int ASSIMP_CFLAGS_STLPORT = 2;
    public static final int ASSIMP_CFLAGS_DEBUG = 4;
    public static final int ASSIMP_CFLAGS_NOBOOST = 8;
    public static final int ASSIMP_CFLAGS_SINGLETHREADED = 16;
    private static final SharedLibrary ASSIMP = Library.loadNative(Assimp.class, Configuration.ASSIMP_LIBRARY_NAME.get(Platform.mapLibraryNameBundled("assimp")), true);

    protected Assimp() {
        throw new UnsupportedOperationException();
    }

    public static SharedLibrary getLibrary() {
        return ASSIMP;
    }

    public static int aiComponent_COLORSn(int n) {
        return 1 << n + 20;
    }

    public static int aiComponent_TEXCOORDSn(int n) {
        return 1 << n + 25;
    }

    public static float AI_DEG_TO_RAD(float x) {
        return x * ((float)Math.PI / 180);
    }

    public static float AI_RAD_TO_DEG(float x) {
        return x * 57.29578f;
    }

    @NativeType(value="size_t")
    public static long aiGetExportFormatCount() {
        long __functionAddress = Functions.GetExportFormatCount;
        return JNI.invokeP(__functionAddress);
    }

    public static long naiGetExportFormatDescription(long pIndex) {
        long __functionAddress = Functions.GetExportFormatDescription;
        return JNI.invokePP(__functionAddress, pIndex);
    }

    @Nullable
    @NativeType(value="struct aiExportFormatDesc *")
    public static AIExportFormatDesc aiGetExportFormatDescription(@NativeType(value="size_t") long pIndex) {
        long __result = Assimp.naiGetExportFormatDescription(pIndex);
        return AIExportFormatDesc.createSafe(__result);
    }

    public static void naiReleaseExportFormatDescription(long desc) {
        long __functionAddress = Functions.ReleaseExportFormatDescription;
        if (Checks.CHECKS) {
            AIExportFormatDesc.validate(desc);
        }
        JNI.invokePV(__functionAddress, desc);
    }

    public static void aiReleaseExportFormatDescription(@NativeType(value="struct aiExportFormatDesc const *") AIExportFormatDesc desc) {
        Assimp.naiReleaseExportFormatDescription(desc.address());
    }

    public static void naiCopyScene(long pIn, long pOut) {
        long __functionAddress = Functions.CopyScene;
        if (Checks.CHECKS) {
            AIScene.validate(pIn);
        }
        JNI.invokePPV(__functionAddress, pIn, pOut);
    }

    public static void aiCopyScene(@NativeType(value="struct aiScene const *") AIScene pIn, @NativeType(value="struct aiScene **") PointerBuffer pOut) {
        if (Checks.CHECKS) {
            Checks.check(pOut, 1);
        }
        Assimp.naiCopyScene(pIn.address(), MemoryUtil.memAddress(pOut));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="void")
    public static AIScene aiCopyScene(@NativeType(value="struct aiScene const *") AIScene pIn) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer pOut = stack.callocPointer(1);
            Assimp.naiCopyScene(pIn.address(), MemoryUtil.memAddress(pOut));
            AIScene aIScene = AIScene.createSafe(pOut.get(0));
            return aIScene;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void naiFreeScene(long pIn) {
        long __functionAddress = Functions.FreeScene;
        if (Checks.CHECKS) {
            AIScene.validate(pIn);
        }
        JNI.invokePV(__functionAddress, pIn);
    }

    public static void aiFreeScene(@NativeType(value="struct aiScene const *") AIScene pIn) {
        Assimp.naiFreeScene(pIn.address());
    }

    public static int naiExportScene(long pScene, long pFormatId, long pFileName, int pPreProcessing) {
        long __functionAddress = Functions.ExportScene;
        if (Checks.CHECKS) {
            AIScene.validate(pScene);
        }
        return JNI.invokePPPI(__functionAddress, pScene, pFormatId, pFileName, pPreProcessing);
    }

    @NativeType(value="aiReturn")
    public static int aiExportScene(@NativeType(value="struct aiScene const *") AIScene pScene, @NativeType(value="char const *") ByteBuffer pFormatId, @NativeType(value="char const *") ByteBuffer pFileName, @NativeType(value="unsigned int") int pPreProcessing) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pFormatId);
            Checks.checkNT1(pFileName);
        }
        return Assimp.naiExportScene(pScene.address(), MemoryUtil.memAddress(pFormatId), MemoryUtil.memAddress(pFileName), pPreProcessing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="aiReturn")
    public static int aiExportScene(@NativeType(value="struct aiScene const *") AIScene pScene, @NativeType(value="char const *") CharSequence pFormatId, @NativeType(value="char const *") CharSequence pFileName, @NativeType(value="unsigned int") int pPreProcessing) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pFormatIdEncoded = stack.UTF8(pFormatId);
            ByteBuffer pFileNameEncoded = stack.UTF8(pFileName);
            int n = Assimp.naiExportScene(pScene.address(), MemoryUtil.memAddress(pFormatIdEncoded), MemoryUtil.memAddress(pFileNameEncoded), pPreProcessing);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int naiExportSceneEx(long pScene, long pFormatId, long pFileName, long pIO, int pPreProcessing) {
        long __functionAddress = Functions.ExportSceneEx;
        if (Checks.CHECKS) {
            AIScene.validate(pScene);
            if (pIO != 0L) {
                AIFileIO.validate(pIO);
            }
        }
        return JNI.invokePPPPI(__functionAddress, pScene, pFormatId, pFileName, pIO, pPreProcessing);
    }

    @NativeType(value="aiReturn")
    public static int aiExportSceneEx(@NativeType(value="struct aiScene const *") AIScene pScene, @NativeType(value="char const *") ByteBuffer pFormatId, @NativeType(value="char const *") ByteBuffer pFileName, @Nullable @NativeType(value="struct aiFileIO const *") AIFileIO pIO, @NativeType(value="unsigned int") int pPreProcessing) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pFormatId);
            Checks.checkNT1(pFileName);
        }
        return Assimp.naiExportSceneEx(pScene.address(), MemoryUtil.memAddress(pFormatId), MemoryUtil.memAddress(pFileName), MemoryUtil.memAddressSafe(pIO), pPreProcessing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="aiReturn")
    public static int aiExportSceneEx(@NativeType(value="struct aiScene const *") AIScene pScene, @NativeType(value="char const *") CharSequence pFormatId, @NativeType(value="char const *") CharSequence pFileName, @Nullable @NativeType(value="struct aiFileIO const *") AIFileIO pIO, @NativeType(value="unsigned int") int pPreProcessing) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pFormatIdEncoded = stack.UTF8(pFormatId);
            ByteBuffer pFileNameEncoded = stack.UTF8(pFileName);
            int n = Assimp.naiExportSceneEx(pScene.address(), MemoryUtil.memAddress(pFormatIdEncoded), MemoryUtil.memAddress(pFileNameEncoded), MemoryUtil.memAddressSafe(pIO), pPreProcessing);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long naiExportSceneToBlob(long pScene, long pFormatId, int pPreProcessing) {
        long __functionAddress = Functions.ExportSceneToBlob;
        if (Checks.CHECKS) {
            AIScene.validate(pScene);
        }
        return JNI.invokePPP(__functionAddress, pScene, pFormatId, pPreProcessing);
    }

    @Nullable
    @NativeType(value="struct aiExportDataBlob *")
    public static AIExportDataBlob aiExportSceneToBlob(@NativeType(value="struct aiScene const *") AIScene pScene, @NativeType(value="char const *") ByteBuffer pFormatId, @NativeType(value="unsigned int") int pPreProcessing) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pFormatId);
        }
        long __result = Assimp.naiExportSceneToBlob(pScene.address(), MemoryUtil.memAddress(pFormatId), pPreProcessing);
        return AIExportDataBlob.createSafe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="struct aiExportDataBlob *")
    public static AIExportDataBlob aiExportSceneToBlob(@NativeType(value="struct aiScene const *") AIScene pScene, @NativeType(value="char const *") CharSequence pFormatId, @NativeType(value="unsigned int") int pPreProcessing) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pFormatIdEncoded = stack.UTF8(pFormatId);
            long __result = Assimp.naiExportSceneToBlob(pScene.address(), MemoryUtil.memAddress(pFormatIdEncoded), pPreProcessing);
            AIExportDataBlob aIExportDataBlob = AIExportDataBlob.createSafe(__result);
            return aIExportDataBlob;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void naiReleaseExportBlob(long pData) {
        long __functionAddress = Functions.ReleaseExportBlob;
        if (Checks.CHECKS) {
            AIExportDataBlob.validate(pData);
        }
        JNI.invokePV(__functionAddress, pData);
    }

    public static void aiReleaseExportBlob(@NativeType(value="struct aiExportDataBlob const *") AIExportDataBlob pData) {
        Assimp.naiReleaseExportBlob(pData.address());
    }

    public static long naiImportFile(long pFile, int pFlags) {
        long __functionAddress = Functions.ImportFile;
        return JNI.invokePP(__functionAddress, pFile, pFlags);
    }

    @Nullable
    @NativeType(value="struct aiScene *")
    public static AIScene aiImportFile(@NativeType(value="char const *") ByteBuffer pFile, @NativeType(value="unsigned int") int pFlags) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pFile);
        }
        long __result = Assimp.naiImportFile(MemoryUtil.memAddress(pFile), pFlags);
        return AIScene.createSafe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="struct aiScene *")
    public static AIScene aiImportFile(@NativeType(value="char const *") CharSequence pFile, @NativeType(value="unsigned int") int pFlags) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pFileEncoded = stack.UTF8(pFile);
            long __result = Assimp.naiImportFile(MemoryUtil.memAddress(pFileEncoded), pFlags);
            AIScene aIScene = AIScene.createSafe(__result);
            return aIScene;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long naiImportFileEx(long pFile, int pFlags, long pFS) {
        long __functionAddress = Functions.ImportFileEx;
        if (Checks.CHECKS && pFS != 0L) {
            AIFileIO.validate(pFS);
        }
        return JNI.invokePPP(__functionAddress, pFile, pFlags, pFS);
    }

    @Nullable
    @NativeType(value="struct aiScene *")
    public static AIScene aiImportFileEx(@NativeType(value="char const *") ByteBuffer pFile, @NativeType(value="unsigned int") int pFlags, @Nullable @NativeType(value="struct aiFileIO *") AIFileIO pFS) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pFile);
        }
        long __result = Assimp.naiImportFileEx(MemoryUtil.memAddress(pFile), pFlags, MemoryUtil.memAddressSafe(pFS));
        return AIScene.createSafe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="struct aiScene *")
    public static AIScene aiImportFileEx(@NativeType(value="char const *") CharSequence pFile, @NativeType(value="unsigned int") int pFlags, @Nullable @NativeType(value="struct aiFileIO *") AIFileIO pFS) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pFileEncoded = stack.UTF8(pFile);
            long __result = Assimp.naiImportFileEx(MemoryUtil.memAddress(pFileEncoded), pFlags, MemoryUtil.memAddressSafe(pFS));
            AIScene aIScene = AIScene.createSafe(__result);
            return aIScene;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long naiImportFileExWithProperties(long pFile, int pFlags, long pFS, long pProps) {
        long __functionAddress = Functions.ImportFileExWithProperties;
        if (Checks.CHECKS && pFS != 0L) {
            AIFileIO.validate(pFS);
        }
        return JNI.invokePPPP(__functionAddress, pFile, pFlags, pFS, pProps);
    }

    @Nullable
    @NativeType(value="struct aiScene *")
    public static AIScene aiImportFileExWithProperties(@NativeType(value="char const *") ByteBuffer pFile, @NativeType(value="unsigned int") int pFlags, @Nullable @NativeType(value="struct aiFileIO *") AIFileIO pFS, @NativeType(value="struct aiPropertyStore const *") AIPropertyStore pProps) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pFile);
        }
        long __result = Assimp.naiImportFileExWithProperties(MemoryUtil.memAddress(pFile), pFlags, MemoryUtil.memAddressSafe(pFS), pProps.address());
        return AIScene.createSafe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="struct aiScene *")
    public static AIScene aiImportFileExWithProperties(@NativeType(value="char const *") CharSequence pFile, @NativeType(value="unsigned int") int pFlags, @Nullable @NativeType(value="struct aiFileIO *") AIFileIO pFS, @NativeType(value="struct aiPropertyStore const *") AIPropertyStore pProps) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pFileEncoded = stack.UTF8(pFile);
            long __result = Assimp.naiImportFileExWithProperties(MemoryUtil.memAddress(pFileEncoded), pFlags, MemoryUtil.memAddressSafe(pFS), pProps.address());
            AIScene aIScene = AIScene.createSafe(__result);
            return aIScene;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long naiImportFileFromMemory(long pBuffer, int pLength, int pFlags, long pHint) {
        long __functionAddress = Functions.ImportFileFromMemory;
        return JNI.invokePPP(__functionAddress, pBuffer, pLength, pFlags, pHint);
    }

    @Nullable
    @NativeType(value="struct aiScene *")
    public static AIScene aiImportFileFromMemory(@NativeType(value="char const *") ByteBuffer pBuffer, @NativeType(value="unsigned int") int pFlags, @Nullable @NativeType(value="char const *") ByteBuffer pHint) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(pHint);
        }
        long __result = Assimp.naiImportFileFromMemory(MemoryUtil.memAddress(pBuffer), pBuffer.remaining(), pFlags, MemoryUtil.memAddressSafe(pHint));
        return AIScene.createSafe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="struct aiScene *")
    public static AIScene aiImportFileFromMemory(@NativeType(value="char const *") ByteBuffer pBuffer, @NativeType(value="unsigned int") int pFlags, @Nullable @NativeType(value="char const *") CharSequence pHint) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pHintEncoded = stack.UTF8Safe(pHint);
            long __result = Assimp.naiImportFileFromMemory(MemoryUtil.memAddress(pBuffer), pBuffer.remaining(), pFlags, MemoryUtil.memAddressSafe(pHintEncoded));
            AIScene aIScene = AIScene.createSafe(__result);
            return aIScene;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long naiImportFileFromMemoryWithProperties(long pBuffer, int pLength, int pFlags, long pHint, long pProps) {
        long __functionAddress = Functions.ImportFileFromMemoryWithProperties;
        return JNI.invokePPPP(__functionAddress, pBuffer, pLength, pFlags, pHint, pProps);
    }

    @Nullable
    @NativeType(value="struct aiScene *")
    public static AIScene aiImportFileFromMemoryWithProperties(@NativeType(value="char const *") ByteBuffer pBuffer, @NativeType(value="unsigned int") int pFlags, @Nullable @NativeType(value="char const *") ByteBuffer pHint, @NativeType(value="struct aiPropertyStore const *") AIPropertyStore pProps) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(pHint);
        }
        long __result = Assimp.naiImportFileFromMemoryWithProperties(MemoryUtil.memAddress(pBuffer), pBuffer.remaining(), pFlags, MemoryUtil.memAddressSafe(pHint), pProps.address());
        return AIScene.createSafe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="struct aiScene *")
    public static AIScene aiImportFileFromMemoryWithProperties(@NativeType(value="char const *") ByteBuffer pBuffer, @NativeType(value="unsigned int") int pFlags, @Nullable @NativeType(value="char const *") CharSequence pHint, @NativeType(value="struct aiPropertyStore const *") AIPropertyStore pProps) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pHintEncoded = stack.UTF8Safe(pHint);
            long __result = Assimp.naiImportFileFromMemoryWithProperties(MemoryUtil.memAddress(pBuffer), pBuffer.remaining(), pFlags, MemoryUtil.memAddressSafe(pHintEncoded), pProps.address());
            AIScene aIScene = AIScene.createSafe(__result);
            return aIScene;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long naiApplyPostProcessing(long pScene, int pFlags) {
        long __functionAddress = Functions.ApplyPostProcessing;
        if (Checks.CHECKS) {
            AIScene.validate(pScene);
        }
        return JNI.invokePP(__functionAddress, pScene, pFlags);
    }

    @Nullable
    @NativeType(value="struct aiScene *")
    public static AIScene aiApplyPostProcessing(@NativeType(value="struct aiScene const *") AIScene pScene, @NativeType(value="unsigned int") int pFlags) {
        long __result = Assimp.naiApplyPostProcessing(pScene.address(), pFlags);
        return AIScene.createSafe(__result);
    }

    public static void naiAttachLogStream(long stream) {
        long __functionAddress = Functions.AttachLogStream;
        if (Checks.CHECKS) {
            AILogStream.validate(stream);
        }
        JNI.invokePV(__functionAddress, stream);
    }

    public static void aiAttachLogStream(@NativeType(value="struct aiLogStream const *") AILogStream stream) {
        Assimp.naiAttachLogStream(stream.address());
    }

    public static void aiEnableVerboseLogging(@NativeType(value="aiBool") boolean d) {
        long __functionAddress = Functions.EnableVerboseLogging;
        JNI.invokeV(__functionAddress, d ? 1 : 0);
    }

    public static int naiDetachLogStream(long stream) {
        long __functionAddress = Functions.DetachLogStream;
        if (Checks.CHECKS) {
            AILogStream.validate(stream);
        }
        return JNI.invokePI(__functionAddress, stream);
    }

    @NativeType(value="aiReturn")
    public static int aiDetachLogStream(@NativeType(value="struct aiLogStream *") AILogStream stream) {
        return Assimp.naiDetachLogStream(stream.address());
    }

    public static void aiDetachAllLogStreams() {
        long __functionAddress = Functions.DetachAllLogStreams;
        JNI.invokeV(__functionAddress);
    }

    public static void naiReleaseImport(long pScene) {
        long __functionAddress = Functions.ReleaseImport;
        if (Checks.CHECKS && pScene != 0L) {
            AIScene.validate(pScene);
        }
        JNI.invokePV(__functionAddress, pScene);
    }

    public static void aiReleaseImport(@Nullable @NativeType(value="struct aiScene const *") AIScene pScene) {
        Assimp.naiReleaseImport(MemoryUtil.memAddressSafe(pScene));
    }

    public static long naiGetErrorString() {
        long __functionAddress = Functions.GetErrorString;
        return JNI.invokeP(__functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String aiGetErrorString() {
        long __result = Assimp.naiGetErrorString();
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static int naiIsExtensionSupported(long szExtension) {
        long __functionAddress = Functions.IsExtensionSupported;
        return JNI.invokePI(__functionAddress, szExtension);
    }

    @NativeType(value="aiBool")
    public static boolean aiIsExtensionSupported(@NativeType(value="char const *") ByteBuffer szExtension) {
        if (Checks.CHECKS) {
            Checks.checkNT1(szExtension);
        }
        return Assimp.naiIsExtensionSupported(MemoryUtil.memAddress(szExtension)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="aiBool")
    public static boolean aiIsExtensionSupported(@NativeType(value="char const *") CharSequence szExtension) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer szExtensionEncoded = stack.UTF8(szExtension);
            boolean bl = Assimp.naiIsExtensionSupported(MemoryUtil.memAddress(szExtensionEncoded)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void naiGetExtensionList(long szOut) {
        long __functionAddress = Functions.GetExtensionList;
        JNI.invokePV(__functionAddress, szOut);
    }

    public static void aiGetExtensionList(@NativeType(value="struct aiString *") AIString szOut) {
        Assimp.naiGetExtensionList(szOut.address());
    }

    public static void naiGetMemoryRequirements(long pIn, long in) {
        long __functionAddress = Functions.GetMemoryRequirements;
        if (Checks.CHECKS) {
            AIScene.validate(pIn);
        }
        JNI.invokePPV(__functionAddress, pIn, in);
    }

    public static void aiGetMemoryRequirements(@NativeType(value="struct aiScene const *") AIScene pIn, @NativeType(value="struct aiMemoryInfo *") AIMemoryInfo in) {
        Assimp.naiGetMemoryRequirements(pIn.address(), in.address());
    }

    public static long naiCreatePropertyStore() {
        long __functionAddress = Functions.CreatePropertyStore;
        return JNI.invokeP(__functionAddress);
    }

    @Nullable
    @NativeType(value="struct aiPropertyStore *")
    public static AIPropertyStore aiCreatePropertyStore() {
        long __result = Assimp.naiCreatePropertyStore();
        return AIPropertyStore.createSafe(__result);
    }

    public static void naiReleasePropertyStore(long p) {
        long __functionAddress = Functions.ReleasePropertyStore;
        JNI.invokePV(__functionAddress, p);
    }

    public static void aiReleasePropertyStore(@NativeType(value="struct aiPropertyStore *") AIPropertyStore p) {
        Assimp.naiReleasePropertyStore(p.address());
    }

    public static void naiSetImportPropertyInteger(long store, long szName, int value) {
        long __functionAddress = Functions.SetImportPropertyInteger;
        JNI.invokePPV(__functionAddress, store, szName, value);
    }

    public static void aiSetImportPropertyInteger(@NativeType(value="struct aiPropertyStore *") AIPropertyStore store, @NativeType(value="char const *") ByteBuffer szName, int value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(szName);
        }
        Assimp.naiSetImportPropertyInteger(store.address(), MemoryUtil.memAddress(szName), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void aiSetImportPropertyInteger(@NativeType(value="struct aiPropertyStore *") AIPropertyStore store, @NativeType(value="char const *") CharSequence szName, int value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer szNameEncoded = stack.ASCII(szName);
            Assimp.naiSetImportPropertyInteger(store.address(), MemoryUtil.memAddress(szNameEncoded), value);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void naiSetImportPropertyFloat(long store, long szName, float value) {
        long __functionAddress = Functions.SetImportPropertyFloat;
        JNI.invokePPV(__functionAddress, store, szName, value);
    }

    public static void aiSetImportPropertyFloat(@NativeType(value="struct aiPropertyStore *") AIPropertyStore store, @NativeType(value="char const *") ByteBuffer szName, float value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(szName);
        }
        Assimp.naiSetImportPropertyFloat(store.address(), MemoryUtil.memAddress(szName), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void aiSetImportPropertyFloat(@NativeType(value="struct aiPropertyStore *") AIPropertyStore store, @NativeType(value="char const *") CharSequence szName, float value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer szNameEncoded = stack.ASCII(szName);
            Assimp.naiSetImportPropertyFloat(store.address(), MemoryUtil.memAddress(szNameEncoded), value);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void naiSetImportPropertyString(long store, long szName, long value) {
        long __functionAddress = Functions.SetImportPropertyString;
        JNI.invokePPPV(__functionAddress, store, szName, value);
    }

    public static void aiSetImportPropertyString(@NativeType(value="struct aiPropertyStore *") AIPropertyStore store, @NativeType(value="char const *") ByteBuffer szName, @NativeType(value="struct aiString const *") AIString value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(szName);
        }
        Assimp.naiSetImportPropertyString(store.address(), MemoryUtil.memAddress(szName), value.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void aiSetImportPropertyString(@NativeType(value="struct aiPropertyStore *") AIPropertyStore store, @NativeType(value="char const *") CharSequence szName, @NativeType(value="struct aiString const *") AIString value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer szNameEncoded = stack.ASCII(szName);
            Assimp.naiSetImportPropertyString(store.address(), MemoryUtil.memAddress(szNameEncoded), value.address());
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void naiSetImportPropertyMatrix(long store, long szName, long value) {
        long __functionAddress = Functions.SetImportPropertyMatrix;
        JNI.invokePPPV(__functionAddress, store, szName, value);
    }

    public static void aiSetImportPropertyMatrix(@NativeType(value="struct aiPropertyStore *") AIPropertyStore store, @NativeType(value="char const *") ByteBuffer szName, @NativeType(value="struct aiMatrix4x4 const *") AIMatrix4x4 value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(szName);
        }
        Assimp.naiSetImportPropertyMatrix(store.address(), MemoryUtil.memAddress(szName), value.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void aiSetImportPropertyMatrix(@NativeType(value="struct aiPropertyStore *") AIPropertyStore store, @NativeType(value="char const *") CharSequence szName, @NativeType(value="struct aiMatrix4x4 const *") AIMatrix4x4 value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer szNameEncoded = stack.ASCII(szName);
            Assimp.naiSetImportPropertyMatrix(store.address(), MemoryUtil.memAddress(szNameEncoded), value.address());
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void naiCreateQuaternionFromMatrix(long quat, long mat) {
        long __functionAddress = Functions.CreateQuaternionFromMatrix;
        JNI.invokePPV(__functionAddress, quat, mat);
    }

    public static void aiCreateQuaternionFromMatrix(@NativeType(value="struct aiQuaternion *") AIQuaternion quat, @NativeType(value="struct aiMatrix3x3 const *") AIMatrix3x3 mat) {
        Assimp.naiCreateQuaternionFromMatrix(quat.address(), mat.address());
    }

    public static void naiDecomposeMatrix(long mat, long scaling, long rotation, long position) {
        long __functionAddress = Functions.DecomposeMatrix;
        JNI.invokePPPPV(__functionAddress, mat, scaling, rotation, position);
    }

    public static void aiDecomposeMatrix(@NativeType(value="struct aiMatrix4x4 const *") AIMatrix4x4 mat, @NativeType(value="struct aiVector3D *") AIVector3D scaling, @NativeType(value="struct aiQuaternion *") AIQuaternion rotation, @NativeType(value="struct aiVector3D *") AIVector3D position) {
        Assimp.naiDecomposeMatrix(mat.address(), scaling.address(), rotation.address(), position.address());
    }

    public static void naiTransposeMatrix4(long mat) {
        long __functionAddress = Functions.TransposeMatrix4;
        JNI.invokePV(__functionAddress, mat);
    }

    public static void aiTransposeMatrix4(@NativeType(value="struct aiMatrix4x4 *") AIMatrix4x4 mat) {
        Assimp.naiTransposeMatrix4(mat.address());
    }

    public static void naiTransposeMatrix3(long mat) {
        long __functionAddress = Functions.TransposeMatrix3;
        JNI.invokePV(__functionAddress, mat);
    }

    public static void aiTransposeMatrix3(@NativeType(value="struct aiMatrix3x3 *") AIMatrix3x3 mat) {
        Assimp.naiTransposeMatrix3(mat.address());
    }

    public static void naiTransformVecByMatrix3(long vec, long mat) {
        long __functionAddress = Functions.TransformVecByMatrix3;
        JNI.invokePPV(__functionAddress, vec, mat);
    }

    public static void aiTransformVecByMatrix3(@NativeType(value="struct aiVector3D *") AIVector3D vec, @NativeType(value="struct aiMatrix3x3 const *") AIMatrix3x3 mat) {
        Assimp.naiTransformVecByMatrix3(vec.address(), mat.address());
    }

    public static void naiTransformVecByMatrix4(long vec, long mat) {
        long __functionAddress = Functions.TransformVecByMatrix4;
        JNI.invokePPV(__functionAddress, vec, mat);
    }

    public static void aiTransformVecByMatrix4(@NativeType(value="struct aiVector3D *") AIVector3D vec, @NativeType(value="struct aiMatrix4x4 const *") AIMatrix4x4 mat) {
        Assimp.naiTransformVecByMatrix4(vec.address(), mat.address());
    }

    public static void naiMultiplyMatrix4(long dst, long src) {
        long __functionAddress = Functions.MultiplyMatrix4;
        JNI.invokePPV(__functionAddress, dst, src);
    }

    public static void aiMultiplyMatrix4(@NativeType(value="struct aiMatrix4x4 *") AIMatrix4x4 dst, @NativeType(value="struct aiMatrix4x4 const *") AIMatrix4x4 src) {
        Assimp.naiMultiplyMatrix4(dst.address(), src.address());
    }

    public static void naiMultiplyMatrix3(long dst, long src) {
        long __functionAddress = Functions.MultiplyMatrix3;
        JNI.invokePPV(__functionAddress, dst, src);
    }

    public static void aiMultiplyMatrix3(@NativeType(value="struct aiMatrix3x3 *") AIMatrix3x3 dst, @NativeType(value="struct aiMatrix3x3 const *") AIMatrix3x3 src) {
        Assimp.naiMultiplyMatrix3(dst.address(), src.address());
    }

    public static void naiIdentityMatrix3(long mat) {
        long __functionAddress = Functions.IdentityMatrix3;
        JNI.invokePV(__functionAddress, mat);
    }

    public static void aiIdentityMatrix3(@NativeType(value="struct aiMatrix3x3 *") AIMatrix3x3 mat) {
        Assimp.naiIdentityMatrix3(mat.address());
    }

    public static void naiIdentityMatrix4(long mat) {
        long __functionAddress = Functions.IdentityMatrix4;
        JNI.invokePV(__functionAddress, mat);
    }

    public static void aiIdentityMatrix4(@NativeType(value="struct aiMatrix4x4 *") AIMatrix4x4 mat) {
        Assimp.naiIdentityMatrix4(mat.address());
    }

    @NativeType(value="size_t")
    public static long aiGetImportFormatCount() {
        long __functionAddress = Functions.GetImportFormatCount;
        return JNI.invokeP(__functionAddress);
    }

    public static long naiGetImportFormatDescription(long pIndex) {
        long __functionAddress = Functions.GetImportFormatDescription;
        return JNI.invokePP(__functionAddress, pIndex);
    }

    @Nullable
    @NativeType(value="struct aiImporterDesc *")
    public static AIImporterDesc aiGetImportFormatDescription(@NativeType(value="size_t") long pIndex) {
        long __result = Assimp.naiGetImportFormatDescription(pIndex);
        return AIImporterDesc.createSafe(__result);
    }

    public static long naiGetImporterDesc(long extension) {
        long __functionAddress = Functions.GetImporterDesc;
        return JNI.invokePP(__functionAddress, extension);
    }

    @Nullable
    @NativeType(value="struct aiImporterDesc *")
    public static AIImporterDesc aiGetImporterDesc(@NativeType(value="char const *") ByteBuffer extension) {
        if (Checks.CHECKS) {
            Checks.checkNT1(extension);
        }
        long __result = Assimp.naiGetImporterDesc(MemoryUtil.memAddress(extension));
        return AIImporterDesc.createSafe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="struct aiImporterDesc *")
    public static AIImporterDesc aiGetImporterDesc(@NativeType(value="char const *") CharSequence extension) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer extensionEncoded = stack.ASCII(extension);
            long __result = Assimp.naiGetImporterDesc(MemoryUtil.memAddress(extensionEncoded));
            AIImporterDesc aIImporterDesc = AIImporterDesc.createSafe(__result);
            return aIImporterDesc;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int naiGetMaterialProperty(long pMat, long pKey, int type, int index, long mPropOut) {
        long __functionAddress = Functions.GetMaterialProperty;
        if (Checks.CHECKS) {
            AIMaterial.validate(pMat);
        }
        return JNI.invokePPPI(__functionAddress, pMat, pKey, type, index, mPropOut);
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialProperty(@NativeType(value="struct aiMaterial *") AIMaterial pMat, @NativeType(value="char *") ByteBuffer pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="struct aiMaterialProperty **") PointerBuffer mPropOut) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pKey);
            Checks.check(mPropOut, 1);
        }
        return Assimp.naiGetMaterialProperty(pMat.address(), MemoryUtil.memAddress(pKey), type, index, MemoryUtil.memAddress(mPropOut));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="aiReturn")
    public static int aiGetMaterialProperty(@NativeType(value="struct aiMaterial *") AIMaterial pMat, @NativeType(value="char *") CharSequence pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="struct aiMaterialProperty **") PointerBuffer mPropOut) {
        if (Checks.CHECKS) {
            Checks.check(mPropOut, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pKeyEncoded = stack.ASCII(pKey);
            int n = Assimp.naiGetMaterialProperty(pMat.address(), MemoryUtil.memAddress(pKeyEncoded), type, index, MemoryUtil.memAddress(mPropOut));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialProperty(@NativeType(value="struct aiMaterial *") AIMaterial pMat, @NativeType(value="char *") ByteBuffer pKey, @NativeType(value="struct aiMaterialProperty **") PointerBuffer mPropOut) {
        return Assimp.aiGetMaterialProperty(pMat, pKey, 0, 0, mPropOut);
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialProperty(@NativeType(value="struct aiMaterial *") AIMaterial pMat, @NativeType(value="char *") CharSequence pKey, @NativeType(value="struct aiMaterialProperty **") PointerBuffer mPropOut) {
        return Assimp.aiGetMaterialProperty(pMat, pKey, 0, 0, mPropOut);
    }

    public static int naiGetMaterialFloatArray(long pMat, long pKey, int type, int index, long pOut, long pMax) {
        long __functionAddress = Functions.GetMaterialFloatArray;
        if (Checks.CHECKS) {
            AIMaterial.validate(pMat);
        }
        return JNI.invokePPPPI(__functionAddress, pMat, pKey, type, index, pOut, pMax);
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialFloatArray(@NativeType(value="struct aiMaterial *") AIMaterial pMat, @NativeType(value="char *") ByteBuffer pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="float *") FloatBuffer pOut, @Nullable @NativeType(value="unsigned int *") IntBuffer pMax) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pKey);
            Checks.checkSafe((Buffer)pMax, 1);
            Checks.check((Buffer)pOut, pMax.get(pMax.position()));
        }
        return Assimp.naiGetMaterialFloatArray(pMat.address(), MemoryUtil.memAddress(pKey), type, index, MemoryUtil.memAddress(pOut), MemoryUtil.memAddressSafe(pMax));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="aiReturn")
    public static int aiGetMaterialFloatArray(@NativeType(value="struct aiMaterial *") AIMaterial pMat, @NativeType(value="char *") CharSequence pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="float *") FloatBuffer pOut, @Nullable @NativeType(value="unsigned int *") IntBuffer pMax) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pMax, 1);
            Checks.check((Buffer)pOut, pMax.get(pMax.position()));
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pKeyEncoded = stack.ASCII(pKey);
            int n = Assimp.naiGetMaterialFloatArray(pMat.address(), MemoryUtil.memAddress(pKeyEncoded), type, index, MemoryUtil.memAddress(pOut), MemoryUtil.memAddressSafe(pMax));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int naiGetMaterialIntegerArray(long pMat, long pKey, int type, int index, long pOut, long pMax) {
        long __functionAddress = Functions.GetMaterialIntegerArray;
        if (Checks.CHECKS) {
            AIMaterial.validate(pMat);
        }
        return JNI.invokePPPPI(__functionAddress, pMat, pKey, type, index, pOut, pMax);
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialIntegerArray(@NativeType(value="struct aiMaterial *") AIMaterial pMat, @NativeType(value="char *") ByteBuffer pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="int *") IntBuffer pOut, @Nullable @NativeType(value="unsigned int *") IntBuffer pMax) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pKey);
            Checks.checkSafe((Buffer)pMax, 1);
            Checks.check((Buffer)pOut, pMax.get(pMax.position()));
        }
        return Assimp.naiGetMaterialIntegerArray(pMat.address(), MemoryUtil.memAddress(pKey), type, index, MemoryUtil.memAddress(pOut), MemoryUtil.memAddressSafe(pMax));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="aiReturn")
    public static int aiGetMaterialIntegerArray(@NativeType(value="struct aiMaterial *") AIMaterial pMat, @NativeType(value="char *") CharSequence pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="int *") IntBuffer pOut, @Nullable @NativeType(value="unsigned int *") IntBuffer pMax) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pMax, 1);
            Checks.check((Buffer)pOut, pMax.get(pMax.position()));
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pKeyEncoded = stack.ASCII(pKey);
            int n = Assimp.naiGetMaterialIntegerArray(pMat.address(), MemoryUtil.memAddress(pKeyEncoded), type, index, MemoryUtil.memAddress(pOut), MemoryUtil.memAddressSafe(pMax));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int naiGetMaterialColor(long pMat, long pKey, int type, int index, long pOut) {
        long __functionAddress = Functions.GetMaterialColor;
        if (Checks.CHECKS) {
            AIMaterial.validate(pMat);
        }
        return JNI.invokePPPI(__functionAddress, pMat, pKey, type, index, pOut);
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialColor(@NativeType(value="struct aiMaterial *") AIMaterial pMat, @NativeType(value="char *") ByteBuffer pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="struct aiColor4D *") AIColor4D pOut) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pKey);
        }
        return Assimp.naiGetMaterialColor(pMat.address(), MemoryUtil.memAddress(pKey), type, index, pOut.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="aiReturn")
    public static int aiGetMaterialColor(@NativeType(value="struct aiMaterial *") AIMaterial pMat, @NativeType(value="char *") CharSequence pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="struct aiColor4D *") AIColor4D pOut) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pKeyEncoded = stack.ASCII(pKey);
            int n = Assimp.naiGetMaterialColor(pMat.address(), MemoryUtil.memAddress(pKeyEncoded), type, index, pOut.address());
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int naiGetMaterialUVTransform(long pMat, long pKey, int type, int index, long pOut) {
        long __functionAddress = Functions.GetMaterialUVTransform;
        if (Checks.CHECKS) {
            AIMaterial.validate(pMat);
        }
        return JNI.invokePPPI(__functionAddress, pMat, pKey, type, index, pOut);
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialUVTransform(@NativeType(value="struct aiMaterial *") AIMaterial pMat, @NativeType(value="char *") ByteBuffer pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="struct aiUVTransform *") AIUVTransform pOut) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pKey);
        }
        return Assimp.naiGetMaterialUVTransform(pMat.address(), MemoryUtil.memAddress(pKey), type, index, pOut.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="aiReturn")
    public static int aiGetMaterialUVTransform(@NativeType(value="struct aiMaterial *") AIMaterial pMat, @NativeType(value="char *") CharSequence pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="struct aiUVTransform *") AIUVTransform pOut) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pKeyEncoded = stack.ASCII(pKey);
            int n = Assimp.naiGetMaterialUVTransform(pMat.address(), MemoryUtil.memAddress(pKeyEncoded), type, index, pOut.address());
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int naiGetMaterialString(long pMat, long pKey, int type, int index, long pOut) {
        long __functionAddress = Functions.GetMaterialString;
        if (Checks.CHECKS) {
            AIMaterial.validate(pMat);
        }
        return JNI.invokePPPI(__functionAddress, pMat, pKey, type, index, pOut);
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialString(@NativeType(value="struct aiMaterial *") AIMaterial pMat, @NativeType(value="char *") ByteBuffer pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="struct aiString *") AIString pOut) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pKey);
        }
        return Assimp.naiGetMaterialString(pMat.address(), MemoryUtil.memAddress(pKey), type, index, pOut.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="aiReturn")
    public static int aiGetMaterialString(@NativeType(value="struct aiMaterial *") AIMaterial pMat, @NativeType(value="char *") CharSequence pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="struct aiString *") AIString pOut) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pKeyEncoded = stack.ASCII(pKey);
            int n = Assimp.naiGetMaterialString(pMat.address(), MemoryUtil.memAddress(pKeyEncoded), type, index, pOut.address());
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int naiGetMaterialTextureCount(long pMat, int type) {
        long __functionAddress = Functions.GetMaterialTextureCount;
        if (Checks.CHECKS) {
            AIMaterial.validate(pMat);
        }
        return JNI.invokePI(__functionAddress, pMat, type);
    }

    @NativeType(value="unsigned int")
    public static int aiGetMaterialTextureCount(@NativeType(value="struct aiMaterial *") AIMaterial pMat, @NativeType(value="aiTextureType") int type) {
        return Assimp.naiGetMaterialTextureCount(pMat.address(), type);
    }

    public static int naiGetMaterialTexture(long pMat, int type, int index, long path, long mapping, long uvindex, long blend, long op, long mapmode, long flags) {
        long __functionAddress = Functions.GetMaterialTexture;
        if (Checks.CHECKS) {
            AIMaterial.validate(pMat);
        }
        return JNI.invokePPPPPPPPI(__functionAddress, pMat, type, index, path, mapping, uvindex, blend, op, mapmode, flags);
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialTexture(@NativeType(value="struct aiMaterial *") AIMaterial pMat, @NativeType(value="aiTextureType") int type, @NativeType(value="unsigned int") int index, @NativeType(value="struct aiString *") AIString path, @Nullable @NativeType(value="aiTextureMapping *") IntBuffer mapping, @Nullable @NativeType(value="unsigned int *") IntBuffer uvindex, @Nullable @NativeType(value="float *") FloatBuffer blend, @Nullable @NativeType(value="aiTextureOp *") IntBuffer op, @Nullable @NativeType(value="aiTextureMapMode *") IntBuffer mapmode, @Nullable @NativeType(value="unsigned int *") IntBuffer flags) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)mapping, 1);
            Checks.checkSafe((Buffer)uvindex, 1);
            Checks.checkSafe((Buffer)blend, 1);
            Checks.checkSafe((Buffer)op, 1);
            Checks.checkSafe((Buffer)mapmode, 1);
            Checks.checkSafe((Buffer)flags, 1);
        }
        return Assimp.naiGetMaterialTexture(pMat.address(), type, index, path.address(), MemoryUtil.memAddressSafe(mapping), MemoryUtil.memAddressSafe(uvindex), MemoryUtil.memAddressSafe(blend), MemoryUtil.memAddressSafe(op), MemoryUtil.memAddressSafe(mapmode), MemoryUtil.memAddressSafe(flags));
    }

    public static long naiCreateAndRegisterDefaultMaterial() {
        long __functionAddress = Functions.CreateAndRegisterDefaultMaterial;
        return JNI.invokeP(__functionAddress);
    }

    @Nullable
    @NativeType(value="struct aiMaterial *")
    public static AIMaterial aiCreateAndRegisterDefaultMaterial() {
        long __result = Assimp.naiCreateAndRegisterDefaultMaterial();
        return AIMaterial.createSafe(__result);
    }

    public static void aiReleaseDefaultMaterial() {
        long __functionAddress = Functions.ReleaseDefaultMaterial;
        JNI.invokeV(__functionAddress);
    }

    public static long naiGetLegalString() {
        long __functionAddress = Functions.GetLegalString;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="char const *")
    public static String aiGetLegalString() {
        long __result = Assimp.naiGetLegalString();
        return MemoryUtil.memASCII(__result);
    }

    @NativeType(value="unsigned int")
    public static int aiGetVersionMinor() {
        long __functionAddress = Functions.GetVersionMinor;
        return JNI.invokeI(__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int aiGetVersionMajor() {
        long __functionAddress = Functions.GetVersionMajor;
        return JNI.invokeI(__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int aiGetVersionRevision() {
        long __functionAddress = Functions.GetVersionRevision;
        return JNI.invokeI(__functionAddress);
    }

    public static long naiGetBranchName() {
        long __functionAddress = Functions.GetBranchName;
        return JNI.invokeP(__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String aiGetBranchName() {
        long __result = Assimp.naiGetBranchName();
        return MemoryUtil.memUTF8Safe(__result);
    }

    @NativeType(value="unsigned int")
    public static int aiGetCompileFlags() {
        long __functionAddress = Functions.GetCompileFlags;
        return JNI.invokeI(__functionAddress);
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialFloatArray(@NativeType(value="struct aiMaterial *") AIMaterial pMat, @NativeType(value="char *") ByteBuffer pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="float *") float[] pOut, @Nullable @NativeType(value="unsigned int *") int[] pMax) {
        long __functionAddress = Functions.GetMaterialFloatArray;
        if (Checks.CHECKS) {
            Checks.checkNT1(pKey);
            Checks.checkSafe(pMax, 1);
            Checks.check(pOut, pMax[0]);
            AIMaterial.validate(pMat.address());
        }
        return JNI.invokePPPPI(__functionAddress, pMat.address(), MemoryUtil.memAddress(pKey), type, index, pOut, pMax);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="aiReturn")
    public static int aiGetMaterialFloatArray(@NativeType(value="struct aiMaterial *") AIMaterial pMat, @NativeType(value="char *") CharSequence pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="float *") float[] pOut, @Nullable @NativeType(value="unsigned int *") int[] pMax) {
        long __functionAddress = Functions.GetMaterialFloatArray;
        if (Checks.CHECKS) {
            Checks.checkSafe(pMax, 1);
            Checks.check(pOut, pMax[0]);
            AIMaterial.validate(pMat.address());
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pKeyEncoded = stack.ASCII(pKey);
            int n = JNI.invokePPPPI(__functionAddress, pMat.address(), MemoryUtil.memAddress(pKeyEncoded), type, index, pOut, pMax);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialIntegerArray(@NativeType(value="struct aiMaterial *") AIMaterial pMat, @NativeType(value="char *") ByteBuffer pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="int *") int[] pOut, @Nullable @NativeType(value="unsigned int *") int[] pMax) {
        long __functionAddress = Functions.GetMaterialIntegerArray;
        if (Checks.CHECKS) {
            Checks.checkNT1(pKey);
            Checks.checkSafe(pMax, 1);
            Checks.check(pOut, pMax[0]);
            AIMaterial.validate(pMat.address());
        }
        return JNI.invokePPPPI(__functionAddress, pMat.address(), MemoryUtil.memAddress(pKey), type, index, pOut, pMax);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="aiReturn")
    public static int aiGetMaterialIntegerArray(@NativeType(value="struct aiMaterial *") AIMaterial pMat, @NativeType(value="char *") CharSequence pKey, @NativeType(value="unsigned int") int type, @NativeType(value="unsigned int") int index, @NativeType(value="int *") int[] pOut, @Nullable @NativeType(value="unsigned int *") int[] pMax) {
        long __functionAddress = Functions.GetMaterialIntegerArray;
        if (Checks.CHECKS) {
            Checks.checkSafe(pMax, 1);
            Checks.check(pOut, pMax[0]);
            AIMaterial.validate(pMat.address());
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pKeyEncoded = stack.ASCII(pKey);
            int n = JNI.invokePPPPI(__functionAddress, pMat.address(), MemoryUtil.memAddress(pKeyEncoded), type, index, pOut, pMax);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="aiReturn")
    public static int aiGetMaterialTexture(@NativeType(value="struct aiMaterial *") AIMaterial pMat, @NativeType(value="aiTextureType") int type, @NativeType(value="unsigned int") int index, @NativeType(value="struct aiString *") AIString path, @Nullable @NativeType(value="aiTextureMapping *") int[] mapping, @Nullable @NativeType(value="unsigned int *") int[] uvindex, @Nullable @NativeType(value="float *") float[] blend, @Nullable @NativeType(value="aiTextureOp *") int[] op, @Nullable @NativeType(value="aiTextureMapMode *") int[] mapmode, @Nullable @NativeType(value="unsigned int *") int[] flags) {
        long __functionAddress = Functions.GetMaterialTexture;
        if (Checks.CHECKS) {
            Checks.checkSafe(mapping, 1);
            Checks.checkSafe(uvindex, 1);
            Checks.checkSafe(blend, 1);
            Checks.checkSafe(op, 1);
            Checks.checkSafe(mapmode, 1);
            Checks.checkSafe(flags, 1);
            AIMaterial.validate(pMat.address());
        }
        return JNI.invokePPPPPPPPI(__functionAddress, pMat.address(), type, index, path.address(), mapping, uvindex, blend, op, mapmode, flags);
    }

    static /* synthetic */ SharedLibrary access$000() {
        return ASSIMP;
    }

    public static final class Functions {
        public static final long GetExportFormatCount = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiGetExportFormatCount");
        public static final long GetExportFormatDescription = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiGetExportFormatDescription");
        public static final long ReleaseExportFormatDescription = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiReleaseExportFormatDescription");
        public static final long CopyScene = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiCopyScene");
        public static final long FreeScene = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiFreeScene");
        public static final long ExportScene = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiExportScene");
        public static final long ExportSceneEx = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiExportSceneEx");
        public static final long ExportSceneToBlob = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiExportSceneToBlob");
        public static final long ReleaseExportBlob = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiReleaseExportBlob");
        public static final long ImportFile = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiImportFile");
        public static final long ImportFileEx = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiImportFileEx");
        public static final long ImportFileExWithProperties = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiImportFileExWithProperties");
        public static final long ImportFileFromMemory = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiImportFileFromMemory");
        public static final long ImportFileFromMemoryWithProperties = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiImportFileFromMemoryWithProperties");
        public static final long ApplyPostProcessing = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiApplyPostProcessing");
        public static final long AttachLogStream = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiAttachLogStream");
        public static final long EnableVerboseLogging = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiEnableVerboseLogging");
        public static final long DetachLogStream = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiDetachLogStream");
        public static final long DetachAllLogStreams = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiDetachAllLogStreams");
        public static final long ReleaseImport = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiReleaseImport");
        public static final long GetErrorString = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiGetErrorString");
        public static final long IsExtensionSupported = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiIsExtensionSupported");
        public static final long GetExtensionList = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiGetExtensionList");
        public static final long GetMemoryRequirements = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiGetMemoryRequirements");
        public static final long CreatePropertyStore = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiCreatePropertyStore");
        public static final long ReleasePropertyStore = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiReleasePropertyStore");
        public static final long SetImportPropertyInteger = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiSetImportPropertyInteger");
        public static final long SetImportPropertyFloat = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiSetImportPropertyFloat");
        public static final long SetImportPropertyString = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiSetImportPropertyString");
        public static final long SetImportPropertyMatrix = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiSetImportPropertyMatrix");
        public static final long CreateQuaternionFromMatrix = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiCreateQuaternionFromMatrix");
        public static final long DecomposeMatrix = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiDecomposeMatrix");
        public static final long TransposeMatrix4 = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiTransposeMatrix4");
        public static final long TransposeMatrix3 = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiTransposeMatrix3");
        public static final long TransformVecByMatrix3 = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiTransformVecByMatrix3");
        public static final long TransformVecByMatrix4 = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiTransformVecByMatrix4");
        public static final long MultiplyMatrix4 = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiMultiplyMatrix4");
        public static final long MultiplyMatrix3 = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiMultiplyMatrix3");
        public static final long IdentityMatrix3 = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiIdentityMatrix3");
        public static final long IdentityMatrix4 = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiIdentityMatrix4");
        public static final long GetImportFormatCount = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiGetImportFormatCount");
        public static final long GetImportFormatDescription = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiGetImportFormatDescription");
        public static final long GetImporterDesc = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiGetImporterDesc");
        public static final long GetMaterialProperty = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiGetMaterialProperty");
        public static final long GetMaterialFloatArray = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiGetMaterialFloatArray");
        public static final long GetMaterialIntegerArray = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiGetMaterialIntegerArray");
        public static final long GetMaterialColor = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiGetMaterialColor");
        public static final long GetMaterialUVTransform = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiGetMaterialUVTransform");
        public static final long GetMaterialString = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiGetMaterialString");
        public static final long GetMaterialTextureCount = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiGetMaterialTextureCount");
        public static final long GetMaterialTexture = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiGetMaterialTexture");
        public static final long CreateAndRegisterDefaultMaterial = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiCreateAndRegisterDefaultMaterial");
        public static final long ReleaseDefaultMaterial = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiReleaseDefaultMaterial");
        public static final long GetLegalString = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiGetLegalString");
        public static final long GetVersionMinor = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiGetVersionMinor");
        public static final long GetVersionMajor = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiGetVersionMajor");
        public static final long GetVersionRevision = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiGetVersionRevision");
        public static final long GetBranchName = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiGetBranchName");
        public static final long GetCompileFlags = APIUtil.apiGetFunctionAddress(Assimp.access$000(), "aiGetCompileFlags");

        private Functions() {
        }
    }
}

