/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiString")
public class AIString
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LENGTH;
    public static final int DATA;

    AIString(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public AIString(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIString.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long length() {
        return AIString.nlength(this.address());
    }

    @NativeType(value="char[Assimp.MAXLEN]")
    public ByteBuffer data() {
        return AIString.ndata(this.address());
    }

    @NativeType(value="char[Assimp.MAXLEN]")
    public String dataString() {
        return AIString.ndataString(this.address());
    }

    public AIString data(@NativeType(value="char[Assimp.MAXLEN]") ByteBuffer value) {
        AIString.ndata(this.address(), value);
        return this;
    }

    public AIString set(AIString src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIString malloc() {
        return AIString.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIString calloc() {
        return AIString.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIString create() {
        return new AIString(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIString create(long address) {
        return new AIString(address, null);
    }

    @Nullable
    public static AIString createSafe(long address) {
        return address == 0L ? null : AIString.create(address);
    }

    public static Buffer malloc(int capacity) {
        return AIString.create(AIString.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIString.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(AIString.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIString.create(address, capacity);
    }

    public static AIString mallocStack() {
        return AIString.mallocStack(MemoryStack.stackGet());
    }

    public static AIString callocStack() {
        return AIString.callocStack(MemoryStack.stackGet());
    }

    public static AIString mallocStack(MemoryStack stack) {
        return AIString.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIString callocStack(MemoryStack stack) {
        return AIString.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIString.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIString.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIString.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIString.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nlength(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)LENGTH);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DATA, (int)AIString.nlength(struct));
    }

    public static String ndataString(long struct) {
        return MemoryUtil.memUTF8(AIString.ndata(struct));
    }

    public static void nlength(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)LENGTH, value);
    }

    public static void ndata(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
            Checks.checkGT(value, 1024);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)DATA, value.remaining());
        AIString.nlength(struct, value.remaining() - 1);
    }

    static {
        Struct.Layout layout = AIString.__struct(AIString.__member(POINTER_SIZE), AIString.__array(1, 1024));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LENGTH = layout.offsetof(0);
        DATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIString, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIString newInstance(long address) {
            return new AIString(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="size_t")
        public long length() {
            return AIString.nlength(this.address());
        }

        @NativeType(value="char[Assimp.MAXLEN]")
        public ByteBuffer data() {
            return AIString.ndata(this.address());
        }

        @NativeType(value="char[Assimp.MAXLEN]")
        public String dataString() {
            return AIString.ndataString(this.address());
        }

        public Buffer data(@NativeType(value="char[Assimp.MAXLEN]") ByteBuffer value) {
            AIString.ndata(this.address(), value);
            return this;
        }
    }
}

