/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIFileCloseProc;
import org.lwjgl.assimp.AIFileCloseProcI;
import org.lwjgl.assimp.AIFileOpenProc;
import org.lwjgl.assimp.AIFileOpenProcI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiFileIO")
public class AIFileIO
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OPENPROC;
    public static final int CLOSEPROC;
    public static final int USERDATA;

    AIFileIO(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public AIFileIO(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIFileIO.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="aiFileOpenProc")
    public AIFileOpenProc OpenProc() {
        return AIFileIO.nOpenProc(this.address());
    }

    @NativeType(value="aiFileCloseProc")
    public AIFileCloseProc CloseProc() {
        return AIFileIO.nCloseProc(this.address());
    }

    @NativeType(value="aiUserData")
    public long UserData() {
        return AIFileIO.nUserData(this.address());
    }

    public AIFileIO OpenProc(@NativeType(value="aiFileOpenProc") AIFileOpenProcI value) {
        AIFileIO.nOpenProc(this.address(), value);
        return this;
    }

    public AIFileIO CloseProc(@NativeType(value="aiFileCloseProc") AIFileCloseProcI value) {
        AIFileIO.nCloseProc(this.address(), value);
        return this;
    }

    public AIFileIO UserData(@NativeType(value="aiUserData") long value) {
        AIFileIO.nUserData(this.address(), value);
        return this;
    }

    public AIFileIO set(AIFileOpenProcI OpenProc, AIFileCloseProcI CloseProc, long UserData) {
        this.OpenProc(OpenProc);
        this.CloseProc(CloseProc);
        this.UserData(UserData);
        return this;
    }

    public AIFileIO set(AIFileIO src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIFileIO malloc() {
        return AIFileIO.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIFileIO calloc() {
        return AIFileIO.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIFileIO create() {
        return new AIFileIO(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIFileIO create(long address) {
        return new AIFileIO(address, null);
    }

    @Nullable
    public static AIFileIO createSafe(long address) {
        return address == 0L ? null : AIFileIO.create(address);
    }

    public static Buffer malloc(int capacity) {
        return AIFileIO.create(AIFileIO.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIFileIO.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(AIFileIO.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIFileIO.create(address, capacity);
    }

    public static AIFileIO mallocStack() {
        return AIFileIO.mallocStack(MemoryStack.stackGet());
    }

    public static AIFileIO callocStack() {
        return AIFileIO.callocStack(MemoryStack.stackGet());
    }

    public static AIFileIO mallocStack(MemoryStack stack) {
        return AIFileIO.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIFileIO callocStack(MemoryStack stack) {
        return AIFileIO.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIFileIO.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIFileIO.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIFileIO.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIFileIO.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIFileOpenProc nOpenProc(long struct) {
        return AIFileOpenProc.create(MemoryUtil.memGetAddress(struct + (long)OPENPROC));
    }

    public static AIFileCloseProc nCloseProc(long struct) {
        return AIFileCloseProc.create(MemoryUtil.memGetAddress(struct + (long)CLOSEPROC));
    }

    public static long nUserData(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)USERDATA);
    }

    public static void nOpenProc(long struct, AIFileOpenProcI value) {
        MemoryUtil.memPutAddress(struct + (long)OPENPROC, value.address());
    }

    public static void nCloseProc(long struct, AIFileCloseProcI value) {
        MemoryUtil.memPutAddress(struct + (long)CLOSEPROC, value.address());
    }

    public static void nUserData(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)USERDATA, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)OPENPROC));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CLOSEPROC));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIFileIO.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = AIFileIO.__struct(AIFileIO.__member(POINTER_SIZE), AIFileIO.__member(POINTER_SIZE), AIFileIO.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OPENPROC = layout.offsetof(0);
        CLOSEPROC = layout.offsetof(1);
        USERDATA = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<AIFileIO, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIFileIO newInstance(long address) {
            return new AIFileIO(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="aiFileOpenProc")
        public AIFileOpenProc OpenProc() {
            return AIFileIO.nOpenProc(this.address());
        }

        @NativeType(value="aiFileCloseProc")
        public AIFileCloseProc CloseProc() {
            return AIFileIO.nCloseProc(this.address());
        }

        @NativeType(value="aiUserData")
        public long UserData() {
            return AIFileIO.nUserData(this.address());
        }

        public Buffer OpenProc(@NativeType(value="aiFileOpenProc") AIFileOpenProcI value) {
            AIFileIO.nOpenProc(this.address(), value);
            return this;
        }

        public Buffer CloseProc(@NativeType(value="aiFileCloseProc") AIFileCloseProcI value) {
            AIFileIO.nCloseProc(this.address(), value);
            return this;
        }

        public Buffer UserData(@NativeType(value="aiUserData") long value) {
            AIFileIO.nUserData(this.address(), value);
            return this;
        }
    }
}

