/*
 * Decompiled with CFR 0.152.
 */
package game.views;

import engine.EnigView;
import engine.OpenAL.Sound;
import engine.OpenAL.SoundSource;
import engine.OpenGL.EnigWindow;
import engine.OpenGL.FBO;
import engine.OpenGL.Texture;
import engine.OpenGL.VAO;
import engine.Platform.Ray3f;
import game.Asteroid;
import game.Main;
import game.Shaders;
import game.Shot;
import game.UserControls;
import game.entities.Player;
import game.views.GameOverView;
import java.util.ArrayList;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;

public class MainView
extends EnigView {
    public static MainView main;
    public static VAO skySphere;
    public VAO crosshairVAO;
    public VAO baseVAO;
    public VAO hudVAO;
    public Texture baseHUDTex;
    public Texture shipHUDTex;
    public float totalTime;
    public FBO mainFrameBuffer;
    public Asteroid[] asters;
    public Player player;
    public ArrayList<Shot> shots = new ArrayList();
    public Sound[] tutorialSounds;
    public Sound proximityWarningSound;
    public Sound lowSignalSound;
    public SoundSource proximityWarningSource;
    public SoundSource lowSignalSource;
    public float proximityWarningTimer;
    public float lowSignalTimer;
    public float baseIntensity = 10.0f;
    public boolean gameIsOver = false;
    public int tutorialIndex = -2;
    private float tutorialTimer;
    private boolean tutorialActionDone = false;

    public MainView(EnigWindow window) {
        super(window);
        window.toggleCursorInput();
        skySphere = new VAO("res/objects/2Sphere.obj");
        this.crosshairVAO = new VAO(-5.0f, -5.0f, 10.0f, 10.0f);
        this.baseVAO = new VAO("res/objects/lightSource.obj");
        this.hudVAO = new VAO(-12.5f, -12.5f, 25.0f, 25.0f);
        this.baseHUDTex = new Texture("res/textures/HUDBase.png");
        this.shipHUDTex = new Texture("res/textures/HUDShip.png");
        this.asters = new Asteroid[400];
        for (int i = 0; i < this.asters.length; ++i) {
            this.asters[i] = new Asteroid(this.totalTime);
        }
        this.player = new Player(window);
        this.player.x = -20.0f;
        this.mainFrameBuffer = new FBO(new Texture(window.getWidth(), window.getHeight()));
        this.tutorialSounds = new Sound[]{new Sound("res/sounds/movement controls.wav"), new Sound("res/sounds/transport ship introduction.wav"), new Sound("res/sounds/confirm transport ship.wav"), new Sound("res/sounds/look around.wav"), new Sound("res/sounds/left hud.wav"), new Sound("res/sounds/right hud.wav"), new Sound("res/sounds/attack controls.wav"), new Sound("res/sounds/attack info.wav"), new Sound("res/sounds/astroids spawned.wav"), new Sound("res/sounds/start mission.wav"), new Sound("res/sounds/intro lock velocity.wav"), new Sound("res/sounds/intro radar.wav")};
        this.proximityWarningSource = new SoundSource();
        this.proximityWarningSource.setPitch(1.2f);
        this.lowSignalSource = new SoundSource();
        this.lowSignalSource.setPitch(1.2f);
        this.proximityWarningSound = new Sound("res/sounds/notTutorial/proximityWarning.wav");
        this.lowSignalSound = new Sound("res/sounds/notTutorial/lowSignal.wav");
    }

    public void reset() {
        for (int i = 0; i < this.asters.length; ++i) {
            this.asters[i] = new Asteroid(this.totalTime);
        }
        this.baseIntensity = 10.0f;
        this.player.x = -20.0f;
        this.player.y = 0.0f;
        this.player.z = 0.0f;
        this.player.velocity = new Vector3f();
        this.player.energy = 1.0f;
        this.shots = new ArrayList();
        this.gameIsOver = false;
        this.tutorialIndex = -2;
        this.tutorialTimer = 0.0f;
        this.tutorialActionDone = false;
    }

    @Override
    public boolean loop() {
        this.manageScene();
        this.renderScene();
        return UserControls.quit(this.window) || this.gameIsOver;
    }

    public void manageScene() {
        this.totalTime += this.deltaTime;
        this.manageShots();
        if (this.tutorialIndex == -2 || this.tutorialIndex > 4) {
            this.manageAsters();
        }
        this.player.updateRotation(this.window);
        this.player.updateMovement(this.window, this.deltaTime);
        this.checkMatchVelocity();
        this.manageDeath();
        this.manageTutorial();
    }

    public void manageTutorial() {
        Main.source.setPitch(1.02f);
        if (this.tutorialIndex == -1) {
            if (this.tutorialTimer > 1.0f) {
                ++this.tutorialIndex;
                Main.source.playSound(this.tutorialSounds[0]);
            }
        } else if (this.tutorialIndex == 0) {
            if (this.player.velocity.lengthSquared() > 0.5f && this.tutorialTimer > 12.5f) {
                ++this.tutorialIndex;
                Main.source.playSound(this.tutorialSounds[1]);
                this.tutorialTimer = 0.0f;
            }
        } else if (this.tutorialIndex == 1) {
            if (this.tutorialTimer > 6.5f) {
                Ray3f playerRay = this.player.getRay();
                float tVal = playerRay.closestTTo(new Vector3f(0.0f, 0.0f, 0.0f));
                if (tVal > 0.0f && playerRay.getPointAt(tVal).lengthSquared() < 100.0f) {
                    ++this.tutorialIndex;
                    this.tutorialTimer = 0.0f;
                    Main.source.playSound(this.tutorialSounds[2]);
                } else if (this.tutorialTimer > 10.0f) {
                    Main.source.playSound(this.tutorialSounds[3]);
                    this.tutorialTimer = 4.0f;
                }
            }
        } else if (this.tutorialIndex == 2) {
            if ((double)this.tutorialTimer > 2.2 && (double)this.tutorialTimer < 2.4) {
                Main.source.playSound(this.tutorialSounds[4]);
                this.tutorialTimer = 2.5f;
            } else if (this.tutorialTimer > 11.0f && (double)this.tutorialTimer < 11.1) {
                Main.source.playSound(this.tutorialSounds[5]);
                this.tutorialTimer = 11.2f;
            } else if ((double)this.tutorialTimer > 22.5) {
                ++this.tutorialIndex;
                this.tutorialTimer = 0.0f;
                Main.source.playSound(this.tutorialSounds[6]);
            }
        } else if (this.tutorialIndex == 3) {
            if (this.shots.size() > 0 && (double)this.tutorialTimer > 4.5) {
                ++this.tutorialIndex;
                this.tutorialTimer = 0.0f;
                Main.source.playSound(this.tutorialSounds[7]);
            }
        } else if (this.tutorialIndex == 4) {
            if (this.tutorialTimer > 5.0f) {
                ++this.tutorialIndex;
                this.tutorialTimer = 0.0f;
                Main.source.setPitch(1.2f);
                Main.source.playSound(this.tutorialSounds[8]);
            }
        } else if (this.tutorialIndex == 5) {
            if (this.tutorialTimer > 2.0f) {
                ++this.tutorialIndex;
                this.tutorialTimer = 0.0f;
                Main.source.setPitch(1.02f);
                Main.source.playSound(this.tutorialSounds[9]);
            }
        } else if (this.tutorialIndex == 6) {
            if (this.tutorialTimer > 4.0f) {
                ++this.tutorialIndex;
                this.tutorialTimer = 0.0f;
                Main.source.playSound(this.tutorialSounds[10]);
            }
        } else if (this.tutorialIndex == 7 && this.tutorialActionDone && this.tutorialTimer > 7.2f) {
            ++this.tutorialIndex;
            this.tutorialTimer = 0.0f;
            Main.source.playSound(this.tutorialSounds[11]);
        }
        this.tutorialTimer += this.deltaTime;
    }

    public void manageDeath() {
        float playerLength;
        this.baseIntensity = (float)((double)this.baseIntensity - 0.05 * (double)this.deltaTime);
        if (this.baseIntensity < 0.0f) {
            this.endGame(1);
        }
        if (this.player.energy < 0.0f) {
            this.endGame(2);
        }
        if ((playerLength = this.player.length()) > 300.0f) {
            if (this.tutorialIndex > -2 && this.tutorialIndex < 4) {
                this.player.x = 20.0f;
                this.player.y = 0.0f;
                this.player.z = 0.0f;
                this.player.velocity = new Vector3f();
            } else {
                this.endGame(4);
            }
        } else if (playerLength > 250.0f && this.lowSignalTimer < 0.0f) {
            this.lowSignalSource.playSound(this.lowSignalSound);
            this.lowSignalTimer = 10.0f;
        }
        if (this.player.energy > 1.0f) {
            this.player.energy = 1.0f;
        }
        if (this.baseIntensity > 20.0f) {
            this.baseIntensity = 20.0f;
        }
        this.proximityWarningTimer -= this.deltaTime;
        this.lowSignalTimer -= this.deltaTime;
    }

    public void checkMatchVelocity() {
        if (UserControls.matchVelocity(this.window)) {
            Ray3f playerRay = this.player.getRay();
            float bestT = playerRay.closestTTo(new Vector3f(0.0f, 0.0f, 0.0f));
            if (bestT > 0.0f && playerRay.getPointAt(bestT).lengthSquared() < 100.0f) {
                this.player.energy = (float)((double)this.player.energy - ((double)0.05f + 0.001 * (double)this.player.velocity.length()));
                this.player.velocity.x = 0.0f;
                this.player.velocity.y = 0.0f;
                this.player.velocity.z = 0.0f;
                if (this.tutorialIndex == 7) {
                    this.tutorialActionDone = true;
                }
            } else {
                int bestIndex = -1;
                bestT = Float.POSITIVE_INFINITY;
                for (int i = 0; i < this.asters.length; ++i) {
                    float tVal = playerRay.closestTTo(this.asters[i]);
                    if (!(tVal > 0.0f) || !(playerRay.getPointAt(tVal).distanceSquared(this.asters[i]) < this.asters[i].scale * this.asters[i].scale) || !(tVal < bestT)) continue;
                    bestT = tVal;
                    bestIndex = i;
                }
                if (bestIndex >= 0) {
                    if (this.tutorialIndex == 6) {
                        this.tutorialActionDone = true;
                    }
                    this.player.energy = (float)((double)this.player.energy - ((double)0.05f + 0.001 * (double)this.asters[bestIndex].velocity.distance(this.player.velocity)));
                    this.player.velocity = new Vector3f(this.asters[bestIndex].velocity);
                }
            }
        }
    }

    public void manageShots() {
        if (this.window.mouseButtons[0] == 1) {
            this.shots.add(new Shot(this.player));
            this.player.energy -= 0.01f;
        }
        block0: for (int i = 0; i < this.shots.size(); ++i) {
            this.shots.get(i).add(this.shots.get((int)i).velocity.mul(this.deltaTime, new Vector3f()));
            if (this.shots.get(i).distanceSquared(this.player) > 1000000.0f) {
                this.shots.remove(i);
                --i;
                continue;
            }
            if (this.shots.get(i).lengthSquared() < 100.0f) {
                this.baseIntensity += 0.5f;
                this.shots.remove(i);
                --i;
                continue;
            }
            for (int j = 0; j < this.asters.length; ++j) {
                float tVal;
                Ray3f ray;
                Vector3f pointClose;
                float scale = this.asters[j].scale;
                if ((double)this.asters[j].impactTimer > -0.5) {
                    scale *= 1.0f - this.asters[j].impactTimer / 11.0f;
                }
                if ((pointClose = (ray = this.shots.get(i).getRay(this.deltaTime)).getPointAt(tVal = ray.closestTTo(this.asters[j]))).distance(this.asters[j]) > scale + 0.1f || (tVal < 0.0f || tVal > 1.0f) && (pointClose = ray.start).distance(this.asters[j]) > scale + 0.1f || !(this.shots.get(i).distance(this.asters[j]) < scale + 0.1f)) continue;
                if (this.asters[j].impactTimer < 0.0f) {
                    this.asters[j].impactLocation = new Vector3f(this.shots.get(i)).sub(this.asters[j]).rotateX(-this.asters[j].rotation);
                    this.asters[j].impactTimer = 0.0f;
                }
                this.shots.remove(i);
                --i;
                continue block0;
            }
        }
    }

    public void manageAsters() {
        for (int i = 0; i < this.asters.length; ++i) {
            this.asters[i].add(this.asters[i].velocity.mul(this.deltaTime, new Vector3f()));
            if (this.asters[i].lengthSquared() > 250000.0f) {
                this.asters[i] = new Asteroid(this.totalTime);
            }
            if ((double)this.asters[i].impactTimer < -0.5 && this.asters[i].length() < 10.0f + this.asters[i].scale) {
                if (this.baseIntensity > 5.0f) {
                    this.baseIntensity -= 5.0f;
                    this.asters[i] = new Asteroid(this.totalTime);
                } else {
                    this.endGame(0);
                }
            }
            if ((double)this.asters[i].impactTimer < -0.5 && this.asters[i].distanceSquared(this.player) < this.asters[i].scale * this.asters[i].scale) {
                this.endGame(3);
            }
            this.asters[i].rotation += this.asters[i].omega * this.deltaTime;
            if (!(this.asters[i].impactTimer > -0.5f)) continue;
            this.asters[i].impactTimer += this.deltaTime;
            if (!(this.asters[i].impactTimer > 10.0f)) continue;
            this.asters[i].impactTimer = 10.0f;
            this.asters[i].hitPlayerTimer -= this.deltaTime;
            this.asters[i].velocity.x = (this.player.x + this.player.velocity.x * this.asters[i].hitPlayerTimer - this.asters[i].x) / this.asters[i].hitPlayerTimer;
            this.asters[i].velocity.y = (this.player.y + this.player.velocity.y * this.asters[i].hitPlayerTimer - this.asters[i].y) / this.asters[i].hitPlayerTimer;
            this.asters[i].velocity.z = (this.player.z + this.player.velocity.z * this.asters[i].hitPlayerTimer - this.asters[i].z) / this.asters[i].hitPlayerTimer;
            if (!(this.asters[i].hitPlayerTimer < 0.0f)) continue;
            this.asters[i] = new Asteroid(this.totalTime);
            this.player.energy += this.asters[i].scale / 15.0f;
        }
    }

    public void renderScene() {
        FBO.prepareDefaultRender();
        this.renderCrosshair();
        this.renderHUD();
        this.renderBase();
        if (this.tutorialIndex == -2 || this.tutorialIndex > 4) {
            this.renderAsteroids();
        }
        this.renderShots();
        this.renderStars();
    }

    public void renderCrosshair() {
        Shaders.crosshairShader.enable();
        Shaders.crosshairShader.setUniform(0, 0, Main.squareCam);
        Shaders.crosshairShader.setUniform(2, 0, this.player.energy);
        Shaders.crosshairShader.setUniform(2, 1, this.player.energy);
        Ray3f playerRay = this.player.getRay();
        float bestT = playerRay.closestTTo(new Vector3f(0.0f, 0.0f, 0.0f));
        if (bestT > 0.0f && playerRay.getPointAt(bestT).lengthSquared() < 100.0f) {
            Shaders.crosshairShader.setUniform(2, 1, this.player.energy - 0.05f - 0.001f * this.player.velocity.length());
        } else {
            int bestIndex = -1;
            bestT = Float.POSITIVE_INFINITY;
            for (int i = 0; i < this.asters.length; ++i) {
                float tVal = playerRay.closestTTo(this.asters[i]);
                if (!(tVal > 0.0f) || !(playerRay.getPointAt(tVal).distanceSquared(this.asters[i]) < this.asters[i].scale * this.asters[i].scale) || !(tVal < bestT)) continue;
                bestT = tVal;
                bestIndex = i;
            }
            if (bestIndex >= 0) {
                Shaders.crosshairShader.setUniform(2, 1, this.player.energy - 0.05f - 0.001f * this.asters[bestIndex].velocity.distance(this.player.velocity));
            }
        }
        this.crosshairVAO.fullRender();
    }

    public void renderHUD() {
        Shaders.baseHUDShader.enable();
        this.baseHUDTex.bind();
        Shaders.baseHUDShader.setUniform(0, 0, Main.squareCam.translate(-this.window.getAspectRatio() * 50.0f + 12.5f, -37.5f, 0.0f, new Matrix4f()));
        Shaders.baseHUDShader.setUniform(2, 0, 1.0f - this.baseIntensity / 20.0f);
        float closestDist = Float.POSITIVE_INFINITY;
        for (int i = 0; i < this.asters.length; ++i) {
            float dist;
            if (!(this.asters[i].impactTimer < 0.0f) || !((dist = this.asters[i].length()) < closestDist)) continue;
            closestDist = dist;
        }
        Shaders.baseHUDShader.setUniform(2, 1, 1.0f - closestDist / 200.0f);
        this.hudVAO.fullRender();
        if (closestDist < 50.0f && this.proximityWarningTimer < 0.0f) {
            this.proximityWarningTimer = 10.0f;
            this.proximityWarningSource.playSound(this.proximityWarningSound);
        }
        Shaders.shipHUDShader.enable();
        this.shipHUDTex.bind();
        Shaders.shipHUDShader.setUniform(0, 0, Main.squareCam.translate(this.window.getAspectRatio() * 50.0f - 12.5f, -37.5f, 0.0f, new Matrix4f()));
        Shaders.shipHUDShader.setUniform(2, 0, 1.0f - this.player.energy);
        Shaders.baseHUDShader.setUniform(2, 1, this.player.length() / 400.0f);
        this.hudVAO.fullRender();
    }

    public void renderBase() {
        Matrix4f mat = this.player.getCameraMatrix().scale(10.0f);
        Shaders.baseLightShader.enable();
        Shaders.baseLightShader.setUniform(0, 0, mat);
        Shaders.baseLightShader.setUniform(2, 0, 1.0f - 1.0f / this.baseIntensity);
        skySphere.fullRender();
        Shaders.baseFrameShader.enable();
        Shaders.baseFrameShader.setUniform(0, 0, mat);
        Shaders.baseFrameShader.setUniform(2, 0, 2.0f - 2.0f / this.baseIntensity);
        this.baseVAO.fullRender();
    }

    public void renderShots() {
        Shaders.shotShader.enable();
        skySphere.prepareRender();
        Matrix4f mat = this.player.getCameraMatrix();
        for (int i = 0; i < this.shots.size(); ++i) {
            Shaders.shotShader.setUniform(0, 0, mat.translate(this.shots.get(i), new Matrix4f()).scale(0.1f));
            skySphere.drawTriangles();
        }
        skySphere.unbind();
    }

    public void renderAsteroids() {
        Asteroid.sphere.prepareRender();
        Matrix4f mat = this.player.getCameraMatrix();
        if (UserControls.seeAsteroids(this.window)) {
            this.player.energy -= this.deltaTime * 0.1f;
            Shaders.asteroidEZShader.enable();
            for (int i = 0; i < this.asters.length; ++i) {
                Asteroid aster = this.asters[i];
                float scale = aster.scale;
                if ((double)aster.impactTimer > -0.5) {
                    scale *= 1.0f - aster.impactTimer / 11.0f;
                }
                Shaders.asteroidEZShader.setUniform(0, 0, mat.translate(aster, new Matrix4f()).scale(scale).rotateX(aster.rotation));
                Shaders.asteroidEZShader.setUniform(0, 1, aster.randSeed);
                Shaders.asteroidEZShader.setUniform(2, 0, this.player.sub(aster, new Vector3f()).normalize().rotateX(-aster.rotation));
                Asteroid.sphere.drawTriangles();
            }
        } else {
            Shaders.asteroidShader.enable();
            for (int i = 0; i < this.asters.length; ++i) {
                Asteroid aster = this.asters[i];
                float scale = aster.scale;
                if ((double)aster.impactTimer > -0.5) {
                    scale *= 1.0f - aster.impactTimer / 11.0f;
                }
                Shaders.asteroidShader.setUniform(0, 0, mat.translate(aster, new Matrix4f()).scale(scale).rotateX(aster.rotation));
                Shaders.asteroidShader.setUniform(0, 1, aster.randSeed);
                Shaders.asteroidShader.setUniform(2, 0, aster.rotateX(-aster.rotation, new Vector3f()).normalize(-1.0f));
                Shaders.asteroidShader.setUniform(2, 1, 50.0f * this.baseIntensity / aster.length());
                if (aster.impactTimer > -0.5f) {
                    Shaders.asteroidShader.setUniform(2, 2, aster.impactLocation);
                    Shaders.asteroidShader.setUniform(2, 3, aster.impactTimer);
                    Shaders.asteroidShader.setUniform(2, 4, this.player.sub(aster, new Vector3f()).normalize().rotateX(-aster.rotation));
                } else {
                    Shaders.asteroidShader.setUniform(2, 3, 0.0f);
                    Shaders.asteroidShader.setUniform(2, 4, 0.0f, 1.0f, 0.0f);
                }
                Asteroid.sphere.drawTriangles();
            }
        }
    }

    public void renderStars() {
        GL11.glDisable(2884);
        Shaders.starsShader.enable();
        Shaders.starsShader.setUniform(0, 0, this.player.getCameraMatrix().translate(this.player.x, this.player.y, this.player.z).scale(90000.0f));
        Shaders.starsShader.setUniform(2, 0, this.totalTime);
        skySphere.fullRender();
        GL11.glEnable(2884);
    }

    public void endGame(int looseCondition) {
        GameOverView.deathReason = looseCondition;
        this.gameIsOver = true;
    }
}

