/*
 * Decompiled with CFR 0.152.
 */
package game.views;

import engine.EnigView;
import engine.OpenGL.EnigWindow;
import engine.OpenGL.FBO;
import engine.OpenGL.Texture;
import engine.OpenGL.VAO;
import game.Main;
import game.Shaders;
import game.UserControls;
import game.views.GameOverView;
import game.views.MainView;
import org.joml.Matrix4f;

public class MainMenuView
extends EnigView {
    public static MainMenuView main;
    public Texture titleTexture;
    public Texture startTexture;
    public Texture tutorialTexture;
    public Texture quitTexture;
    public VAO titleVAO;
    public VAO buttonVAO;
    public float time = 0.0f;

    public MainMenuView(EnigWindow window) {
        super(window);
        main = this;
        this.titleTexture = new Texture("res/textures/menu/title.png");
        this.startTexture = new Texture("res/textures/menu/launch.png");
        this.tutorialTexture = new Texture("res/textures/menu/training.png");
        this.quitTexture = new Texture("res/textures/menu/abort.png");
        this.titleVAO = new VAO(-25.0f, 25.0f, 50.0f, 25.0f);
        this.buttonVAO = new VAO(-50.0f, -5.0f, 30.0f, 10.0f);
    }

    @Override
    public boolean loop() {
        FBO.prepareDefaultRender();
        Shaders.textureShader.enable();
        this.titleTexture.bind();
        Shaders.textureShader.setUniform(0, 0, Main.squareCam);
        this.titleVAO.fullRender();
        Shaders.buttonShader.enable();
        Shaders.buttonShader.setUniform(0, 0, Main.squareCam.translate(0.0f, 20.0f, 0.0f, new Matrix4f()));
        if (this.window.cursorXFloat * this.window.getAspectRatio() * 50.0f > -50.0f && this.window.cursorXFloat * this.window.getAspectRatio() * 50.0f < -20.0f && this.window.cursorYFloat * 50.0f > 15.0f && this.window.cursorYFloat * 50.0f < 25.0f) {
            Shaders.buttonShader.setUniform(2, 0, this.time);
            if (this.window.mouseButtons[0] == 1) {
                this.window.mouseButtons[0] = 0;
                this.window.toggleCursorInput();
                MainView.main.reset();
                MainView.main.runLoop();
                this.window.toggleCursorInput();
                if (MainView.main.gameIsOver) {
                    GameOverView.main.runLoop();
                }
                this.window.mouseButtons[0] = 0;
                return false;
            }
        } else {
            Shaders.buttonShader.setUniform(2, 0, 0.0f);
        }
        this.startTexture.bind();
        this.buttonVAO.prepareRender();
        this.buttonVAO.drawTriangles();
        Shaders.buttonShader.setUniform(0, 0, Main.squareCam.translate(0.0f, 10.0f, 0.0f, new Matrix4f()));
        if (this.window.cursorXFloat * this.window.getAspectRatio() * 50.0f > -50.0f && this.window.cursorXFloat * this.window.getAspectRatio() * 50.0f < -20.0f && this.window.cursorYFloat * 50.0f > 5.0f && this.window.cursorYFloat * 50.0f < 15.0f) {
            Shaders.buttonShader.setUniform(2, 0, this.time);
            if (this.window.mouseButtons[0] == 1) {
                this.window.mouseButtons[0] = 0;
                this.window.toggleCursorInput();
                MainView.main.reset();
                MainView.main.tutorialIndex = -1;
                MainView.main.runLoop();
                this.window.toggleCursorInput();
                if (MainView.main.gameIsOver) {
                    GameOverView.main.runLoop();
                }
                this.window.mouseButtons[0] = 0;
                return false;
            }
        } else {
            Shaders.buttonShader.setUniform(2, 0, 0.0f);
        }
        this.tutorialTexture.bind();
        this.buttonVAO.prepareRender();
        this.buttonVAO.drawTriangles();
        Shaders.buttonShader.setUniform(0, 0, Main.squareCam.translate(0.0f, 0.0f, 0.0f, new Matrix4f()));
        if (this.window.cursorXFloat * this.window.getAspectRatio() * 50.0f > -50.0f && this.window.cursorXFloat * this.window.getAspectRatio() * 50.0f < -20.0f && this.window.cursorYFloat * 50.0f > -5.0f && this.window.cursorYFloat * 50.0f < 5.0f) {
            Shaders.buttonShader.setUniform(2, 0, this.time);
            if (this.window.mouseButtons[0] == 1) {
                return true;
            }
        } else {
            Shaders.buttonShader.setUniform(2, 0, 0.0f);
        }
        this.quitTexture.bind();
        this.buttonVAO.drawTriangles();
        this.buttonVAO.unbind();
        this.time -= this.deltaTime;
        if (this.time < 0.0f) {
            this.time = 1.0f;
        }
        return UserControls.quit(this.window);
    }
}

