/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import engine.Entities.Camera;
import engine.OpenGL.EnigWindow;
import engine.Platform.Ray3f;
import game.UserControls;
import org.joml.Vector3f;

public class Player
extends Camera {
    public Vector3f velocity = new Vector3f();
    public float energy = 1.0f;

    public Player(EnigWindow window) {
        super(0.7853982f, 0.01f, 9.0E9f, window);
    }

    public void updateMovement(EnigWindow window, float timeStep) {
        if (UserControls.forward(window)) {
            this.velocity.add(this.getRotatedVector(0.0f, 0.0f, -1.0f, 10.0f * timeStep));
            this.energy -= 0.01f * timeStep;
        }
        if (UserControls.backward(window)) {
            this.velocity.add(this.getRotatedVector(0.0f, 0.0f, 1.0f, 10.0f * timeStep));
            this.energy -= 0.01f * timeStep;
        }
        if (UserControls.left(window)) {
            this.velocity.add(this.getRotatedVector(-1.0f, 0.0f, 0.0f, 10.0f * timeStep));
            this.energy -= 0.01f * timeStep;
        }
        if (UserControls.right(window)) {
            this.velocity.add(this.getRotatedVector(1.0f, 0.0f, 0.0f, 10.0f * timeStep));
            this.energy -= 0.01f * timeStep;
        }
        if (UserControls.up(window)) {
            this.velocity.add(this.getRotatedVector(0.0f, 1.0f, 0.0f, 10.0f * timeStep));
            this.energy -= 0.01f * timeStep;
        }
        if (UserControls.down(window)) {
            this.velocity.add(this.getRotatedVector(0.0f, -1.0f, 0.0f, 10.0f * timeStep));
            this.energy -= 0.01f * timeStep;
        }
        this.add(this.velocity.mul(timeStep, new Vector3f()));
    }

    public Ray3f getRay() {
        return new Ray3f(this, this.getRotatedVector(0.0f, 0.0f, -1.0f, 1.0f));
    }

    public void applyMovement(Vector3f acceleration, float timeStep) {
        this.add(this.velocity.mul(timeStep, new Vector3f()));
        this.add(acceleration.mul(0.5f * timeStep * timeStep, new Vector3f()));
        this.velocity.add(acceleration.mul(timeStep, new Vector3f()));
    }

    public void updateRotation(EnigWindow window) {
        this.yaw(-((float)window.cursorXOffset) / 1000.0f);
        this.pitch(-((float)window.cursorYOffset) / 1000.0f);
        this.updateRotations();
    }
}

