/*
 * Decompiled with CFR 0.152.
 */
package game;

import engine.OpenGL.VAO;
import org.joml.Vector3f;

public class Asteroid
extends Vector3f {
    public static VAO sphere;
    public Vector3f velocity = new Vector3f();
    public float rotation;
    public float omega;
    public float randSeed;
    public float mass;
    public float scale;
    public float hitPlayerTimer = 1.0f;
    public Vector3f impactLocation;
    public float impactTimer = -1.0f;

    public Asteroid(float totalTimeElapsed) {
        this.x = (float)Math.random() * 10.0f - 5.0f;
        this.y = (float)Math.random() * 10.0f - 5.0f;
        this.z = (float)Math.random() * 10.0f - 5.0f;
        this.normalize((float)Math.random() * 100.0f + 350.0f);
        this.scale = (float)Math.random() * 2.0f + 0.5f;
        this.randSeed = (float)(Math.E / Math.random());
        this.velocity = new Vector3f((float)Math.random(), (float)Math.random(), (float)Math.random()).normalize(20.0f * (float)Math.random());
        this.velocity.x += 10.0f * (float)(Math.random() * (double)(totalTimeElapsed + 50.0f) / 50.0) - 1.0f;
        Vector3f rAxis = new Vector3f((float)Math.random(), (float)Math.random(), (float)Math.random()).normalize((float)Math.random());
        this.omega = (float)(Math.PI * (Math.random() - 0.5));
    }

    public void applyImpulse(Vector3f dMoment) {
        this.velocity.add(dMoment.mul(1.0f / this.mass, new Vector3f()));
    }

    public void applyMovement(Vector3f acceleration, float timeStep) {
        this.add(this.velocity.mul(timeStep, new Vector3f()));
        this.add(acceleration.mul(0.5f * timeStep * timeStep, new Vector3f()));
        this.velocity.add(acceleration.mul(timeStep, new Vector3f()));
    }

    public static void loadRes() {
        sphere = new VAO("res/objects/4Sphere.obj");
    }
}

