/*
 * Decompiled with CFR 0.152.
 */
package engine.Platform;

import engine.Platform.Ray3f;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class Simplex2v3d {
    public Vector3f a;
    public Vector3f b;
    public Vector3f c;
    public Vector3f normal;

    public Simplex2v3d(Vector3f a, Vector3f b, Vector3f c) {
        Vector3f na = new Vector3f(a.x - c.x, a.y - c.y, a.z - c.z);
        Vector3f nb = new Vector3f(b.x - c.x, b.y - c.y, b.z - c.z);
        this.normal = na.cross(nb).normalize();
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public Simplex2v3d(float ax, float ay, float az, float bx, float by, float bz, float cx, float cy, float cz) {
        Vector3f na = new Vector3f(ax - cx, ay - cy, az - cz);
        Vector3f nb = new Vector3f(bx - cx, by - cy, bz - cz);
        this.normal = na.cross(nb).normalize();
        this.a = new Vector3f(ax, ay, az);
        this.b = new Vector3f(bx, by, bz);
        this.c = new Vector3f(cx, cy, cz);
    }

    public Simplex2v3d(Vector3f norm, Vector3f point) {
        this.normal = norm;
        this.a = new Vector3f(-1.0f, (-norm.x + norm.z) / norm.y + point.y, 1.0f);
        this.b = new Vector3f(1.0f, (norm.x + norm.z) / norm.y + point.y, 1.0f);
        this.c = new Vector3f(-1.0f, (-norm.x - norm.z) / norm.y + point.y, -1.0f);
    }

    public Simplex2v3d(float xCoeff, float zCoeff, Vector3f point) {
        this.a = new Vector3f(-1.0f + point.x, -xCoeff + zCoeff + point.y, 1.0f + point.z);
        this.b = new Vector3f(1.0f + point.x, xCoeff + zCoeff + point.y, 1.0f + point.z);
        this.c = new Vector3f(-1.0f + point.x, -xCoeff - zCoeff + point.y, -1.0f + point.z);
        Vector3f na = new Vector3f(this.a.x - this.c.x, this.a.y - this.c.y, this.a.z - this.c.z);
        Vector3f nb = new Vector3f(this.b.x - this.c.x, this.b.y - this.c.y, this.b.z - this.c.z);
        this.normal = na.cross(nb).normalize();
    }

    public float getx(float y, float z) {
        return -(this.normal.y * (y - this.c.y) + this.normal.z * (z - this.c.z)) / this.normal.x + this.c.x;
    }

    public float getx(Vector2f v) {
        return this.getx(v.x, v.y);
    }

    public float gety(float x, float z) {
        return -(this.normal.x * (x - this.c.x) + this.normal.z * (z - this.c.z)) / this.normal.y + this.c.y;
    }

    public float gety(Vector2f v) {
        return this.gety(v.x, v.y);
    }

    public float getz(float x, float y) {
        return -(this.normal.x * (x - this.c.x) + this.normal.y * (y - this.c.y)) / this.normal.z + this.c.z;
    }

    public float getz(Vector2f v) {
        return this.getz(v.x, v.y);
    }

    public float getTIntersect(Ray3f l) {
        Vector3f k = l.start.sub(this.a, new Vector3f());
        return -k.dot(this.normal) / l.delta.dot(this.normal);
    }

    public Vector3f getIntersectPoint(Ray3f l) {
        return l.intersectionPoint(this);
    }

    public Ray3f getReflected(Ray3f ray) {
        Vector3f intersection = this.getIntersectPoint(ray);
        if (intersection == null) {
            return null;
        }
        return new Ray3f(intersection, this.normal.mul(2.0f * this.normal.dot(ray.delta) / this.normal.lengthSquared(), new Vector3f()).add(ray.delta));
    }
}

