/*
 * Decompiled with CFR 0.152.
 */
package engine.Platform;

import engine.Platform.Simplex2v3d;
import org.joml.Vector3f;

public class Ray3f {
    public Vector3f start;
    public Vector3f delta;

    public Ray3f(float sx, float sy, float sz, float dx, float dy, float dz) {
        this.start = new Vector3f(sx, sy, sz);
        this.delta = new Vector3f(dx, dy, dz);
    }

    public Ray3f(Vector3f start, Vector3f delta) {
        this.start = new Vector3f(start);
        this.delta = new Vector3f(delta);
    }

    public Ray3f(Ray3f other) {
        this.start = new Vector3f(other.start);
        this.delta = new Vector3f(other.delta);
    }

    public Vector3f getPointAt(float t) {
        return new Vector3f(this.start.x + this.delta.x * t, this.start.y + this.delta.y * t, this.start.z + this.delta.z * t);
    }

    public float getXAt(float t) {
        return this.start.x + this.delta.x * t;
    }

    public float getYAt(float t) {
        return this.start.y + this.delta.y * t;
    }

    public float getZAt(float t) {
        return this.start.z + this.delta.z * t;
    }

    public boolean intersects(Simplex2v3d simplex) {
        float doubleAreaReciprocal;
        float oy;
        float t = simplex.getTIntersect(this);
        if (t > 1.0f) {
            return false;
        }
        if (t < 0.0f) {
            return false;
        }
        if ((double)Math.abs(simplex.normal.dot(0.0f, 0.0f, 1.0f)) < 1.0E-8) {
            float doubleAreaReciprocal2;
            float oz;
            float ox = this.getXAt(t);
            float u = (ox * simplex.b.z - ox * simplex.c.z - simplex.b.x * (oz = this.getZAt(t)) + simplex.b.x * simplex.c.z + simplex.c.x * oz - simplex.c.x * simplex.b.z) * (doubleAreaReciprocal2 = 1.0f / (simplex.a.x * simplex.b.z - simplex.a.x * simplex.c.z - simplex.b.x * simplex.a.z + simplex.b.x * simplex.c.z + simplex.c.x * simplex.a.z - simplex.c.x * simplex.b.z));
            if (u < 0.0f) {
                return false;
            }
            float v = (simplex.a.x * oz - simplex.a.x * simplex.c.z - ox * simplex.a.z + ox * simplex.c.z + simplex.c.x * simplex.a.z - simplex.c.x * oz) * doubleAreaReciprocal2;
            if (v < 0.0f) {
                return false;
            }
            return !(u + v > 1.0f);
        }
        float ox = this.getXAt(t);
        float u = (ox * simplex.b.y - ox * simplex.c.y - simplex.b.x * (oy = this.getYAt(t)) + simplex.b.x * simplex.c.y + simplex.c.x * oy - simplex.c.x * simplex.b.y) * (doubleAreaReciprocal = 1.0f / (simplex.a.x * simplex.b.y - simplex.a.x * simplex.c.y - simplex.b.x * simplex.a.y + simplex.b.x * simplex.c.y + simplex.c.x * simplex.a.y - simplex.c.x * simplex.b.y));
        if (u < 0.0f) {
            return false;
        }
        float v = (simplex.a.x * oy - simplex.a.x * simplex.c.y - ox * simplex.a.y + ox * simplex.c.y + simplex.c.x * simplex.a.y - simplex.c.x * oy) * doubleAreaReciprocal;
        if (v < 0.0f) {
            return false;
        }
        return !(u + v > 1.0f);
    }

    public Vector3f intersectionPoint(Simplex2v3d simplex) {
        float doubleAreaReciprocal;
        float oy;
        float t = simplex.getTIntersect(this);
        if (t > 1.0f) {
            return null;
        }
        if (t < 0.0f) {
            return null;
        }
        if ((double)Math.abs(simplex.normal.dot(0.0f, 0.0f, 1.0f)) < 1.0E-8) {
            float doubleAreaReciprocal2;
            float oz;
            float ox = this.getXAt(t);
            float u = (ox * simplex.b.z - ox * simplex.c.z - simplex.b.x * (oz = this.getZAt(t)) + simplex.b.x * simplex.c.z + simplex.c.x * oz - simplex.c.x * simplex.b.z) * (doubleAreaReciprocal2 = 1.0f / (simplex.a.x * simplex.b.z - simplex.a.x * simplex.c.z - simplex.b.x * simplex.a.z + simplex.b.x * simplex.c.z + simplex.c.x * simplex.a.z - simplex.c.x * simplex.b.z));
            if (u < 0.0f) {
                return null;
            }
            float v = (simplex.a.x * oz - simplex.a.x * simplex.c.z - ox * simplex.a.z + ox * simplex.c.z + simplex.c.x * simplex.a.z - simplex.c.x * oz) * doubleAreaReciprocal2;
            if (v < 0.0f) {
                return null;
            }
            if (u + v > 1.0f) {
                return null;
            }
            return this.getPointAt(t);
        }
        float ox = this.getXAt(t);
        float u = (ox * simplex.b.y - ox * simplex.c.y - simplex.b.x * (oy = this.getYAt(t)) + simplex.b.x * simplex.c.y + simplex.c.x * oy - simplex.c.x * simplex.b.y) * (doubleAreaReciprocal = 1.0f / (simplex.a.x * simplex.b.y - simplex.a.x * simplex.c.y - simplex.b.x * simplex.a.y + simplex.b.x * simplex.c.y + simplex.c.x * simplex.a.y - simplex.c.x * simplex.b.y));
        if (u < 0.0f) {
            return null;
        }
        float v = (simplex.a.x * oy - simplex.a.x * simplex.c.y - ox * simplex.a.y + ox * simplex.c.y + simplex.c.x * simplex.a.y - simplex.c.x * oy) * doubleAreaReciprocal;
        if (v < 0.0f) {
            return null;
        }
        if (u + v > 1.0f) {
            return null;
        }
        return this.getPointAt(t);
    }

    public void rotateX(float theta) {
        this.start.rotateX(theta);
        this.delta.rotateX(theta);
    }

    public void rotateY(float theta) {
        this.start.rotateY(theta);
        this.delta.rotateY(theta);
    }

    public void rotateZ(float theta) {
        this.start.rotateZ(theta);
        this.delta.rotateZ(theta);
    }

    public void translate(float x, float y, float z) {
        this.start.add(x, y, z);
    }

    public void translate(Vector3f offset) {
        this.start.add(offset);
    }

    public float closestTTo(Vector3f point) {
        return -(this.delta.x * (this.start.x - point.x) + this.delta.y * (this.start.y - point.y) + this.delta.z * (this.start.z - point.z)) / this.delta.lengthSquared();
    }

    public Vector3f closestPointTo(Vector3f other) {
        return this.getPointAt(this.closestTTo(other));
    }

    public float closestDistanceSquared(Vector3f other) {
        return this.closestPointTo(other).distanceSquared(other);
    }

    public float closestDistance(Vector3f other) {
        return (float)Math.sqrt(this.closestDistanceSquared(other));
    }

    public Vector3f closestPointInRangeTo(Vector3f other) {
        float tval = this.closestTTo(other);
        if (tval > 0.0f && tval < 1.0f) {
            return this.getPointAt(tval);
        }
        if (this.start.distanceSquared(other) < this.getPointAt(1.0f).distanceSquared(other)) {
            return new Vector3f(this.start);
        }
        return this.getPointAt(1.0f);
    }

    public float closestDistanceInRangeSquared(Vector3f other) {
        float tval = this.closestTTo(other);
        if (tval > 0.0f && tval < 1.0f) {
            return this.getPointAt(tval).distanceSquared(other);
        }
        return Math.min(this.start.distanceSquared(other), this.getPointAt(1.0f).distanceSquared(other));
    }

    public float closestDistanceInRange(Vector3f other) {
        return (float)Math.sqrt(this.closestDistanceInRangeSquared(other));
    }
}

