/*
 * Decompiled with CFR 0.152.
 */
package engine.Platform;

import engine.OpenGL.VAO;
import org.joml.Vector2f;

public class Box2d {
    float minx;
    float maxx;
    float miny;
    float maxy;

    public Box2d(float xmin, float ymin, float xmax, float ymax) {
        this.minx = xmin;
        this.maxx = xmax;
        this.miny = ymin;
        this.maxy = ymax;
    }

    public Box2d(Vector2f a, Vector2f b) {
        this.minx = Math.min(a.x, b.x);
        this.maxx = Math.max(a.x, b.x);
        this.miny = Math.min(a.y, b.y);
        this.maxy = Math.max(a.y, b.y);
    }

    public Vector2f getCenter() {
        return new Vector2f((this.minx + this.maxx) / 2.0f, (this.miny + this.maxy) / 2.0f);
    }

    public boolean contains(Vector2f point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(float x, float y, float extra) {
        return this.minx < x + extra && this.maxx > x - extra && this.miny < y + extra && this.maxy > y - extra;
    }

    public boolean contains(Vector2f point, float extra) {
        return this.contains(point.x, point.y, extra);
    }

    public boolean contains(float x, float y) {
        return this.minx < x && this.maxx > x && this.miny < y && this.maxy > y;
    }

    public boolean contains(Box2d other) {
        return this.minx < other.minx && this.maxx > other.maxx && this.miny < other.miny && this.maxy > other.maxy;
    }

    public boolean touching(Box2d other) {
        return this.contains(other.minx, other.miny) || this.contains(other.minx, other.miny) || this.contains(other.minx, other.maxy) || this.contains(other.minx, other.maxy) || this.contains(other.maxx, other.miny) || this.contains(other.maxx, other.miny) || this.contains(other.maxx, other.maxy) || this.contains(other.maxx, other.maxy);
    }

    public boolean touches(Vector2f[] points) {
        for (Vector2f point : points) {
            if (!this.contains(point)) continue;
            return true;
        }
        return false;
    }

    public boolean touches(float[] points) {
        for (int i = 0; i < points.length; i += 2) {
            if (!this.contains(points[i], points[i + 1])) continue;
            return true;
        }
        return false;
    }

    public boolean touches(VAO object) {
        return this.touches(object.vbos[0].getData());
    }

    public VAO getVAO() {
        return new VAO(this.minx, this.miny, this.width(), this.height());
    }

    public float width() {
        return this.maxx - this.minx;
    }

    public float height() {
        return this.maxy - this.miny;
    }
}

