/*
 * Decompiled with CFR 0.152.
 */
package engine.OpenGL;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;

public class Texture {
    public static ArrayList<Integer> textureIDs = new ArrayList();
    private int id;
    private int width;
    private int height;

    public Texture(String path) {
        try {
            BufferedImage bi = ImageIO.read(this.getClass().getClassLoader().getResourceAsStream(path));
            this.width = bi.getWidth();
            this.height = bi.getHeight();
            int[] pixels = bi.getRGB(0, 0, this.width, this.height, null, 0, this.width);
            ByteBuffer buffer = BufferUtils.createByteBuffer(this.width * this.height * 4);
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    int pixel = pixels[i * this.width + j];
                    buffer.put((byte)(pixel >> 16 & 0xFF));
                    buffer.put((byte)(pixel >> 8 & 0xFF));
                    buffer.put((byte)(pixel & 0xFF));
                    buffer.put((byte)(pixel >> 24 & 0xFF));
                }
            }
            buffer.flip();
            this.id = GL11.glGenTextures();
            textureIDs.add(this.id);
            this.bind();
            GL11.glTexParameterf(3553, 10241, 9728.0f);
            GL11.glTexParameterf(3553, 10240, 9728.0f);
            GL11.glTexImage2D(3553, 0, 6408, this.width, this.height, 0, 6408, 5121, buffer);
            Texture.unbind();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Texture(BufferedImage bi) {
        this.width = bi.getWidth();
        this.height = bi.getHeight();
        int[] pixels = bi.getRGB(0, 0, this.width, this.height, null, 0, this.width);
        ByteBuffer buffer = BufferUtils.createByteBuffer(this.width * this.height * 4);
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                int pixel = pixels[i * this.width + j];
                buffer.put((byte)(pixel >> 16 & 0xFF));
                buffer.put((byte)(pixel >> 8 & 0xFF));
                buffer.put((byte)(pixel & 0xFF));
                buffer.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        buffer.flip();
        this.id = GL11.glGenTextures();
        textureIDs.add(this.id);
        this.bind();
        GL11.glTexParameterf(3553, 10241, 9728.0f);
        GL11.glTexParameterf(3553, 10240, 9728.0f);
        GL11.glTexImage2D(3553, 0, 6408, this.width, this.height, 0, 6408, 5121, buffer);
        Texture.unbind();
    }

    public Texture(int w, int h) {
        this.width = w;
        this.height = h;
        this.id = GL11.glGenTextures();
        textureIDs.add(this.id);
        this.bind();
        GL11.glTexImage2D(3553, 0, 6408, this.width, this.height, 0, 6408, 5121, (ByteBuffer)null);
        GL11.glTexParameterf(3553, 10241, 9728.0f);
        GL11.glTexParameterf(3553, 10240, 9728.0f);
        Texture.unbind();
    }

    public void bind() {
        GL13.glActiveTexture(33984);
        GL11.glBindTexture(3553, this.id);
    }

    public void bindPosition(int pos) {
        GL13.glActiveTexture(33984 + pos);
        GL11.glBindTexture(3553, this.id);
    }

    public static void unbind() {
        GL13.glActiveTexture(33984);
        GL11.glBindTexture(3553, 0);
    }

    public static void unbindPosition(int pos) {
        GL13.glActiveTexture(33984 + pos);
        GL11.glBindTexture(3553, 0);
    }

    public void destroy() {
        GL11.glDeleteTextures(this.id);
    }

    public int getId() {
        return this.id;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

