/*
 * Decompiled with CFR 0.152.
 */
package engine.OpenGL;

import engine.OpenGL.Sampler;
import engine.OpenGL.Shader;
import java.util.ArrayList;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL20;

public class ShaderProgram {
    public static ArrayList<Integer> shaderProgramIDs = new ArrayList();
    private int id;
    public Shader[] shaders = new Shader[3];
    public static ShaderProgram currentShaderProgram;

    public ShaderProgram(String vertPath, String fragPath) {
        this.id = GL20.glCreateProgram();
        shaderProgramIDs.add(this.id);
        this.shaders[0] = new Shader(vertPath, 35633);
        this.shaders[2] = new Shader(fragPath, 35632);
        GL20.glAttachShader(this.id, this.shaders[0].getID());
        GL20.glAttachShader(this.id, this.shaders[2].getID());
        GL20.glLinkProgram(this.id);
        if (GL20.glGetProgrami(this.id, 35714) != 1) {
            throw new RuntimeException("Failed to compile shader: ! " + GL20.glGetProgramInfoLog(this.id));
        }
        GL20.glDetachShader(this.id, this.shaders[0].getID());
        GL20.glDetachShader(this.id, this.shaders[2].getID());
        for (Shader s : this.shaders) {
            if (s == null) continue;
            for (Sampler sa : s.samplers) {
                sa.setLocation(this.id);
            }
        }
    }

    public ShaderProgram(String folderName) {
        this.id = GL20.glCreateProgram();
        shaderProgramIDs.add(this.id);
        this.shaders[0] = new Shader("res/shaders/" + folderName + "/vert", 35633);
        this.shaders[2] = new Shader("res/shaders/" + folderName + "/frag", 35632);
        GL20.glAttachShader(this.id, this.shaders[0].getID());
        GL20.glAttachShader(this.id, this.shaders[2].getID());
        GL20.glLinkProgram(this.id);
        if (GL20.glGetProgrami(this.id, 35714) != 1) {
            throw new RuntimeException("Failed to compile shader: ! " + GL20.glGetProgramInfoLog(this.id));
        }
        GL20.glDetachShader(this.id, this.shaders[0].getID());
        GL20.glDetachShader(this.id, this.shaders[2].getID());
        for (Shader s : this.shaders) {
            if (s == null) continue;
            for (Sampler sa : s.samplers) {
                sa.setLocation(this.id);
            }
        }
    }

    public ShaderProgram(Shader[] shaderL, boolean[] exists) {
        this.id = GL20.glCreateProgram();
        shaderProgramIDs.add(this.id);
        this.shaders = shaderL;
        if (exists[0]) {
            GL20.glAttachShader(this.id, this.shaders[0].getID());
        }
        if (exists[1]) {
            GL20.glAttachShader(this.id, this.shaders[1].getID());
        }
        if (exists[2]) {
            GL20.glAttachShader(this.id, this.shaders[2].getID());
        }
        GL20.glLinkProgram(this.id);
        if (exists[0]) {
            GL20.glDetachShader(this.id, this.shaders[0].getID());
        }
        if (exists[1]) {
            GL20.glDetachShader(this.id, this.shaders[1].getID());
        }
        if (exists[2]) {
            GL20.glDetachShader(this.id, this.shaders[2].getID());
        }
        for (Shader s : this.shaders) {
            if (s == null) continue;
            for (Sampler sa : s.samplers) {
                sa.setLocation(this.id);
            }
        }
    }

    public int getID() {
        return this.id;
    }

    public void enable() {
        currentShaderProgram = this;
        GL20.glUseProgram(this.id);
        int textureNum = 0;
        for (Shader s : this.shaders) {
            if (s == null) continue;
            for (Sampler sa : s.samplers) {
                GL20.glUniform1i(sa.location, textureNum);
                ++textureNum;
            }
        }
    }

    public static void disable() {
        GL20.glUseProgram(0);
    }

    public void destroy() {
        GL20.glDeleteProgram(this.id);
        for (int i = 0; i < shaderProgramIDs.size(); ++i) {
            if (shaderProgramIDs.get(i) != this.id) continue;
            shaderProgramIDs.remove(i);
        }
    }

    public void setUniform(int shader, int uniform, float val) {
        this.shaders[shader].uniforms[uniform].set(val);
    }

    public void setUniform(int shader, int uniform, float vala, float valb) {
        this.shaders[shader].uniforms[uniform].set(vala, valb);
    }

    public void setUniform(int shader, int uniform, float vala, float valb, float valc) {
        this.shaders[shader].uniforms[uniform].set(vala, valb, valc);
    }

    public void setUniform(int shader, int uniform, float vala, float valb, float valc, float vald) {
        this.shaders[shader].uniforms[uniform].set(vala, valb, valc, vald);
    }

    public void setUniform(int shader, int uniform, Vector2f val) {
        this.shaders[shader].uniforms[uniform].set(val);
    }

    public void setUniform(int shader, int uniform, Vector3f val) {
        this.shaders[shader].uniforms[uniform].set(val);
    }

    public void setUniform(int shader, int uniform, Vector4f val) {
        this.shaders[shader].uniforms[uniform].set(val);
    }

    public void setUniform(int shader, int uniform, Matrix4f val) {
        this.shaders[shader].uniforms[uniform].set(val);
    }

    public void setUniform(int shader, int uniform, int val) {
        this.shaders[shader].uniforms[uniform].set(val);
    }

    public void setUniform(int shader, int uniform, float[] val) {
        this.shaders[shader].uniforms[uniform].set(val);
    }

    public void setUniform(int shader, int uniform, Vector2f[] val) {
        this.shaders[shader].uniforms[uniform].set(val);
    }

    public void setUniform(int shader, int uniform, Vector3f[] val) {
        this.shaders[shader].uniforms[uniform].set(val);
    }

    public void setUniform(int shader, int uniform, Vector4f[] val) {
        this.shaders[shader].uniforms[uniform].set(val);
    }

    public void setUniform(int shader, int uniform, int[] val) {
        this.shaders[shader].uniforms[uniform].set(val);
    }
}

