/*
 * Decompiled with CFR 0.152.
 */
package engine.OpenGL;

import engine.Platform.Simplex2v3d;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class OBJInformation {
    public float[] vertices;
    public float[] textCoords;
    public float[] normals;
    public int[] indexArray;

    public OBJInformation() {
    }

    public OBJInformation getInfo(String fileName) {
        List<String> lines = null;
        try {
            lines = this.readAllLines(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<Vector3f> vertices = new ArrayList<Vector3f>();
        ArrayList<Vector2f> textures = new ArrayList<Vector2f>();
        ArrayList<Vector3f> normals = new ArrayList<Vector3f>();
        ArrayList<Face> faces = new ArrayList<Face>();
        for (String line : lines) {
            String[] tokens = line.split("\\s+");
            switch (tokens[0]) {
                case "v": {
                    Vector3f vec3f = new Vector3f(Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]), Float.parseFloat(tokens[3]));
                    vertices.add(vec3f);
                    break;
                }
                case "vt": {
                    Vector2f vec2f = new Vector2f(Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]));
                    textures.add(vec2f);
                    break;
                }
                case "vn": {
                    Vector3f vec3fNorm = new Vector3f(Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]), Float.parseFloat(tokens[3]));
                    normals.add(vec3fNorm);
                    break;
                }
                case "f": {
                    Face face = new Face(tokens[1], tokens[2], tokens[3]);
                    faces.add(face);
                    break;
                }
            }
        }
        return new OBJInformation(vertices, textures, normals, faces);
    }

    private OBJInformation(List<Vector3f> posList, List<Vector2f> textCoordList, List<Vector3f> normList, List<Face> facesList) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        float[] posArr = new float[posList.size() * 3];
        int i = 0;
        for (Vector3f pos : posList) {
            posArr[i * 3] = pos.x;
            posArr[i * 3 + 1] = pos.y;
            posArr[i * 3 + 2] = pos.z;
            ++i;
        }
        float[] textCoordArr = new float[posList.size() * 2];
        float[] normArr = new float[posList.size() * 3];
        for (Face face : facesList) {
            IdxGroup[] faceVertexIndices;
            for (IdxGroup indValue : faceVertexIndices = face.getFaceVertexIndices()) {
                OBJInformation.processFaceVertex(indValue, textCoordList, normList, indices, textCoordArr, normArr);
            }
        }
        int[] indicesArr = new int[indices.size()];
        indicesArr = indices.stream().mapToInt(v -> v).toArray();
        this.vertices = posArr;
        this.indexArray = indicesArr;
        this.textCoords = textCoordArr;
        this.normals = normArr;
    }

    private static void processFaceVertex(IdxGroup indices, List<Vector2f> textCoordList, List<Vector3f> normList, List<Integer> indicesList, float[] texCoordArr, float[] normArr) {
        int posIndex = indices.idxPos;
        indicesList.add(posIndex);
        if (indices.idxTextCoord >= 0) {
            Vector2f textCoord = textCoordList.get(indices.idxTextCoord);
            texCoordArr[posIndex * 2] = textCoord.x;
            texCoordArr[posIndex * 2 + 1] = 1.0f - textCoord.y;
        }
        if (indices.idxVecNormal >= 0) {
            Vector3f vecNorm = normList.get(indices.idxVecNormal);
            normArr[posIndex * 3] = vecNorm.x;
            normArr[posIndex * 3 + 1] = vecNorm.y;
            normArr[posIndex * 3 + 2] = vecNorm.z;
        }
    }

    public List<String> readAllLines(String fileName) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(fileName)));){
            String line;
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
        }
        return list;
    }

    public static Simplex2v3d[] getSimplexArray(String path) {
        OBJInformation info = new OBJInformation().getInfo(path);
        Simplex2v3d[] ret = new Simplex2v3d[info.indexArray.length / 3];
        for (int i = 0; i < ret.length; ++i) {
            int idxA = info.indexArray[i * 3];
            int idxB = info.indexArray[i * 3 + 1];
            int idxC = info.indexArray[i * 3 + 2];
            ret[i] = new Simplex2v3d(info.vertices[idxA * 3], info.vertices[idxA * 3 + 1], info.vertices[idxA * 3 + 2], info.vertices[idxB * 3], info.vertices[idxB * 3 + 1], info.vertices[idxB * 3 + 2], info.vertices[idxC * 3], info.vertices[idxC * 3 + 1], info.vertices[idxC * 3 + 2]);
        }
        return ret;
    }

    protected static class IdxGroup {
        public static final int NO_VALUE = -1;
        public int idxPos = -1;
        public int idxTextCoord = -1;
        public int idxVecNormal = -1;
    }

    protected static class Face {
        private IdxGroup[] idxGroups = new IdxGroup[3];

        public Face(String v1, String v2, String v3) {
            this.idxGroups[0] = this.parseLine(v1);
            this.idxGroups[1] = this.parseLine(v2);
            this.idxGroups[2] = this.parseLine(v3);
        }

        private IdxGroup parseLine(String line) {
            IdxGroup idxGroup = new IdxGroup();
            String[] lineTokens = line.split("/");
            int length = lineTokens.length;
            idxGroup.idxPos = Integer.parseInt(lineTokens[0]) - 1;
            if (length > 1) {
                String textCoord = lineTokens[1];
                int n = idxGroup.idxTextCoord = textCoord.length() > 0 ? Integer.parseInt(textCoord) - 1 : -1;
                if (length > 2) {
                    idxGroup.idxVecNormal = Integer.parseInt(lineTokens[2]) - 1;
                }
            }
            return idxGroup;
        }

        public IdxGroup[] getFaceVertexIndices() {
            return this.idxGroups;
        }
    }
}

