/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug.org.eclipse.jetty.websocket.servlet;

import java.io.IOException;
import org.lwjglx.debug.javax.servlet.ServletContext;
import org.lwjglx.debug.javax.servlet.ServletException;
import org.lwjglx.debug.javax.servlet.http.HttpServlet;
import org.lwjglx.debug.javax.servlet.http.HttpServletRequest;
import org.lwjglx.debug.javax.servlet.http.HttpServletResponse;
import org.lwjglx.debug.org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.lwjglx.debug.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.lwjglx.debug.org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public abstract class WebSocketServlet
extends HttpServlet {
    private WebSocketServletFactory factory;

    public abstract void configure(WebSocketServletFactory var1);

    @Override
    public void destroy() {
        try {
            this.factory.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void init() throws ServletException {
        try {
            WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
            String max = this.getInitParameter("maxIdleTime");
            if (max != null) {
                policy.setIdleTimeout(Long.parseLong(max));
            }
            if ((max = this.getInitParameter("maxTextMessageSize")) != null) {
                policy.setMaxTextMessageSize(Integer.parseInt(max));
            }
            if ((max = this.getInitParameter("maxBinaryMessageSize")) != null) {
                policy.setMaxBinaryMessageSize(Integer.parseInt(max));
            }
            if ((max = this.getInitParameter("inputBufferSize")) != null) {
                policy.setInputBufferSize(Integer.parseInt(max));
            }
            ServletContext ctx = this.getServletContext();
            this.factory = WebSocketServletFactory.Loader.load(ctx, policy);
            this.configure(this.factory);
            this.factory.start();
            ctx.setAttribute(WebSocketServletFactory.class.getName(), this.factory);
        }
        catch (Exception x) {
            throw new ServletException(x);
        }
    }

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.factory.isUpgradeRequest(request, response)) {
            if (this.factory.acceptWebSocket(request, response)) {
                return;
            }
            if (response.isCommitted()) {
                return;
            }
        }
        super.service(request, response);
    }
}

