/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug.opengl;

import java.io.PrintStream;
import java.util.function.Consumer;
import org.lwjgl.opengl.AMDDebugOutput;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageAMDCallback;
import org.lwjgl.opengl.GLDebugMessageARBCallback;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Callback;
import org.lwjglx.debug.Context;
import org.lwjglx.debug.RT;

public class GLUtil {
    private static final String EXCEPTION_MESSAGE = "OpenGL function call raised an error (see stderr output)";

    public static Callback setupDebugMessageCallback() {
        return GLUtil.setupDebugMessageCallback(APIUtil.DEBUG_STREAM);
    }

    private static void trace(Consumer<String> output) {
        StackTraceElement[] elems = RT.filterStackTrace(new Throwable(), 4).getStackTrace();
        for (int i = 0; i < elems.length; ++i) {
            StackTraceElement ste = elems[i];
            output.accept(ste.toString());
        }
    }

    private static void printTrace(final PrintStream stream) {
        GLUtil.trace(new Consumer<String>(){
            boolean first = true;

            @Override
            public void accept(String str) {
                if (this.first) {
                    GLUtil.printDetail(stream, "Stacktrace", str);
                    this.first = false;
                } else {
                    GLUtil.printDetailLine(stream, "Stacktrace", str);
                }
            }
        });
    }

    public static Callback setupDebugMessageCallback(PrintStream stream) {
        GLCapabilities caps = GL.getCapabilities();
        if (caps.OpenGL43) {
            APIUtil.apiLog("[GL] Using OpenGL 4.3 for error logging.");
            GLDebugMessageCallback proc = GLDebugMessageCallback.create((source, type, id, severity, length, message, userParam) -> {
                Context context = Context.CURRENT_CONTEXT.get();
                String level = severity == 33387 || severity == 37192 ? "info " : (severity == 37191 ? "warn " : "error");
                if (context != null) {
                    stream.println("[" + level + "][" + context.counter + "] OpenGL debug message");
                } else {
                    stream.println("[" + level + "] OpenGL debug message");
                }
                GLUtil.printDetail(stream, "ID", String.format("0x%X", id));
                GLUtil.printDetail(stream, "Source", GLUtil.getDebugSource(source));
                GLUtil.printDetail(stream, "Type", GLUtil.getDebugType(type));
                GLUtil.printDetail(stream, "Severity", GLUtil.getDebugSeverity(severity));
                GLUtil.printDetail(stream, "Message", GLDebugMessageCallback.getMessage(length, message));
                GLUtil.printTrace(stream);
                if (type == 33356) {
                    RT.throwISEOrLogError(EXCEPTION_MESSAGE, false, 3);
                }
            });
            GL43.glDebugMessageCallback(proc, 0L);
            if ((GL11.glGetInteger(33310) & 2) == 0) {
                APIUtil.apiLog("[GL] Warning: A non-debug context may not produce any debug output.");
                GL11.glEnable(37600);
            }
            GL11.glEnable(33346);
            return proc;
        }
        if (caps.GL_KHR_debug) {
            APIUtil.apiLog("[GL] Using KHR_debug for error logging.");
            GLDebugMessageCallback proc = GLDebugMessageCallback.create((source, type, id, severity, length, message, userParam) -> {
                Context context = Context.CURRENT_CONTEXT.get();
                String level = severity == 33387 || severity == 37192 ? "info " : (severity == 37191 ? "warn " : "error");
                if (context != null) {
                    stream.println("[" + level + "][" + context.counter + "] OpenGL debug message");
                } else {
                    stream.println("[" + level + "] OpenGL debug message");
                }
                GLUtil.printDetail(stream, "ID", String.format("0x%X", id));
                GLUtil.printDetail(stream, "Source", GLUtil.getDebugSource(source));
                GLUtil.printDetail(stream, "Type", GLUtil.getDebugType(type));
                GLUtil.printDetail(stream, "Severity", GLUtil.getDebugSeverity(severity));
                GLUtil.printDetail(stream, "Message", GLDebugMessageCallback.getMessage(length, message));
                GLUtil.printTrace(stream);
                if (type == 33356) {
                    RT.throwISEOrLogError(EXCEPTION_MESSAGE, false, 3);
                }
            });
            KHRDebug.glDebugMessageCallback(proc, 0L);
            if (caps.OpenGL30 && (GL11.glGetInteger(33310) & 2) == 0) {
                APIUtil.apiLog("[GL] Warning: A non-debug context may not produce any debug output.");
                GL11.glEnable(37600);
            }
            GL11.glEnable(33346);
            return proc;
        }
        if (caps.GL_ARB_debug_output) {
            APIUtil.apiLog("[GL] Using ARB_debug_output for error logging.");
            GLDebugMessageARBCallback proc = GLDebugMessageARBCallback.create((source, type, id, severity, length, message, userParam) -> {
                Context context = Context.CURRENT_CONTEXT.get();
                String level = severity == 37192 ? "info " : (severity == 37191 ? "warn " : "error");
                if (context != null) {
                    stream.println("[" + level + "][" + context.counter + "] OpenGL debug message");
                } else {
                    stream.println("[" + level + "] OpenGL debug message");
                }
                GLUtil.printDetail(stream, "ID", String.format("0x%X", id));
                GLUtil.printDetail(stream, "Source", GLUtil.getSourceARB(source));
                GLUtil.printDetail(stream, "Type", GLUtil.getTypeARB(type));
                GLUtil.printDetail(stream, "Severity", GLUtil.getSeverityARB(severity));
                GLUtil.printDetail(stream, "Message", GLDebugMessageARBCallback.getMessage(length, message));
                GLUtil.printTrace(stream);
                if (type == 33356) {
                    RT.throwISEOrLogError(EXCEPTION_MESSAGE, false, 3);
                }
            });
            ARBDebugOutput.glDebugMessageCallbackARB(proc, 0L);
            GL11.glEnable(33346);
            return proc;
        }
        if (caps.GL_AMD_debug_output) {
            APIUtil.apiLog("[GL] Using AMD_debug_output for error logging.");
            GLDebugMessageAMDCallback proc = GLDebugMessageAMDCallback.create((id, category, severity, length, message, userParam) -> {
                Context context = Context.CURRENT_CONTEXT.get();
                String level = severity == 37192 ? "info " : (severity == 37191 ? "warn " : "error");
                if (context != null) {
                    stream.println("[" + level + "][" + context.counter + "] OpenGL debug message");
                } else {
                    stream.println("[" + level + "] OpenGL debug message");
                }
                GLUtil.printDetail(stream, "ID", String.format("0x%X", id));
                GLUtil.printDetail(stream, "Category", GLUtil.getCategoryAMD(category));
                GLUtil.printDetail(stream, "Severity", GLUtil.getSeverityAMD(severity));
                GLUtil.printDetail(stream, "Message", GLDebugMessageAMDCallback.getMessage(length, message));
                GLUtil.printTrace(stream);
                if (severity == 37190) {
                    RT.throwISEOrLogError(EXCEPTION_MESSAGE, false, 3);
                }
            });
            AMDDebugOutput.glDebugMessageCallbackAMD(proc, 0L);
            return proc;
        }
        APIUtil.apiLog("[GL] No debug output implementation is available.");
        return null;
    }

    private static void printDetail(PrintStream stream, String type, String message) {
        stream.printf("  %s: %s\n", type, message);
    }

    private static void printDetailLine(PrintStream stream, String type, String message) {
        stream.append("    ");
        for (int i = 0; i < type.length(); ++i) {
            stream.append(" ");
        }
        stream.append(message + "\n");
    }

    private static String getDebugSource(int source) {
        switch (source) {
            case 33350: {
                return "API";
            }
            case 33351: {
                return "WINDOW SYSTEM";
            }
            case 33352: {
                return "SHADER COMPILER";
            }
            case 33353: {
                return "THIRD PARTY";
            }
            case 33354: {
                return "APPLICATION";
            }
            case 33355: {
                return "OTHER";
            }
        }
        return APIUtil.apiUnknownToken(source);
    }

    private static String getDebugType(int type) {
        switch (type) {
            case 33356: {
                return "ERROR";
            }
            case 33357: {
                return "DEPRECATED BEHAVIOR";
            }
            case 33358: {
                return "UNDEFINED BEHAVIOR";
            }
            case 33359: {
                return "PORTABILITY";
            }
            case 33360: {
                return "PERFORMANCE";
            }
            case 33361: {
                return "OTHER";
            }
            case 33384: {
                return "MARKER";
            }
        }
        return APIUtil.apiUnknownToken(type);
    }

    private static String getDebugSeverity(int severity) {
        switch (severity) {
            case 37190: {
                return "HIGH";
            }
            case 37191: {
                return "MEDIUM";
            }
            case 37192: {
                return "LOW";
            }
            case 33387: {
                return "NOTIFICATION";
            }
        }
        return APIUtil.apiUnknownToken(severity);
    }

    private static String getSourceARB(int source) {
        switch (source) {
            case 33350: {
                return "API";
            }
            case 33351: {
                return "WINDOW SYSTEM";
            }
            case 33352: {
                return "SHADER COMPILER";
            }
            case 33353: {
                return "THIRD PARTY";
            }
            case 33354: {
                return "APPLICATION";
            }
            case 33355: {
                return "OTHER";
            }
        }
        return APIUtil.apiUnknownToken(source);
    }

    private static String getTypeARB(int type) {
        switch (type) {
            case 33356: {
                return "ERROR";
            }
            case 33357: {
                return "DEPRECATED BEHAVIOR";
            }
            case 33358: {
                return "UNDEFINED BEHAVIOR";
            }
            case 33359: {
                return "PORTABILITY";
            }
            case 33360: {
                return "PERFORMANCE";
            }
            case 33361: {
                return "OTHER";
            }
        }
        return APIUtil.apiUnknownToken(type);
    }

    private static String getSeverityARB(int severity) {
        switch (severity) {
            case 37190: {
                return "HIGH";
            }
            case 37191: {
                return "MEDIUM";
            }
            case 37192: {
                return "LOW";
            }
        }
        return APIUtil.apiUnknownToken(severity);
    }

    private static String getCategoryAMD(int category) {
        switch (category) {
            case 37193: {
                return "API ERROR";
            }
            case 37194: {
                return "WINDOW SYSTEM";
            }
            case 37195: {
                return "DEPRECATION";
            }
            case 37196: {
                return "UNDEFINED BEHAVIOR";
            }
            case 37197: {
                return "PERFORMANCE";
            }
            case 37198: {
                return "SHADER COMPILER";
            }
            case 37199: {
                return "APPLICATION";
            }
            case 37200: {
                return "OTHER";
            }
        }
        return APIUtil.apiUnknownToken(category);
    }

    private static String getSeverityAMD(int severity) {
        switch (severity) {
            case 37190: {
                return "HIGH";
            }
            case 37191: {
                return "MEDIUM";
            }
            case 37192: {
                return "LOW";
            }
        }
        return APIUtil.apiUnknownToken(severity);
    }
}

