/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Collections;
import java.util.Map;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.ARBOcclusionQuery;
import org.lwjgl.opengl.ARBTimerQuery;
import org.lwjgl.opengl.GL11;
import org.lwjglx.debug.Command;
import org.lwjglx.debug.Context;
import org.lwjglx.debug.GLmetadata;
import org.lwjglx.debug.Log;
import org.lwjglx.debug.MethodCall;
import org.lwjglx.debug.Param;
import org.lwjglx.debug.Profiling;
import org.lwjglx.debug.Properties;
import org.lwjglx.debug.WeakIdentityHashMap;

public class RT {
    private static final Map<Buffer, ByteOrder> bufferEndiannessWritten = Collections.synchronizedMap(new WeakIdentityHashMap());
    private static final Map<Buffer, Buffer> bufferViews = Collections.synchronizedMap(new WeakIdentityHashMap());
    public static Thread mainThread;
    public static boolean glfwInitialized;

    private static void throwIfNotNativeEndianness(ByteOrder order) {
        if (order != null && order != ByteOrder.nativeOrder()) {
            RT.throwIAEOrLogError("buffer contains values written using non-native endianness.");
        }
    }

    public static boolean checkNativeByteOrder(Buffer buf) {
        if (buf == null) {
            return true;
        }
        RT.throwIfNotNativeEndianness(bufferEndiannessWritten.get(buf));
        Buffer viewedBuffer = bufferViews.get(buf);
        if (viewedBuffer != null) {
            RT.throwIfNotNativeEndianness(bufferEndiannessWritten.get(viewedBuffer));
        }
        return true;
    }

    private static void writeByteBuffer(ByteBuffer buf) {
        ByteOrder order = bufferEndiannessWritten.get(buf);
        if (order == null) {
            Buffer viewedBuffer = bufferViews.get(buf);
            if (viewedBuffer != null) {
                bufferEndiannessWritten.put(viewedBuffer, buf.order());
            } else {
                bufferEndiannessWritten.put(buf, buf.order());
            }
        }
    }

    private static void writeCharBuffer(CharBuffer buf) {
        Buffer viewedBuffer = bufferViews.get(buf);
        if (viewedBuffer != null) {
            bufferEndiannessWritten.put(viewedBuffer, buf.order());
        }
    }

    private static void writeShortBuffer(ShortBuffer buf) {
        Buffer viewedBuffer = bufferViews.get(buf);
        if (viewedBuffer != null) {
            bufferEndiannessWritten.put(viewedBuffer, buf.order());
        }
    }

    private static void writeIntBuffer(IntBuffer buf) {
        Buffer viewedBuffer = bufferViews.get(buf);
        if (viewedBuffer != null) {
            bufferEndiannessWritten.put(viewedBuffer, buf.order());
        }
    }

    private static void writeLongBuffer(LongBuffer buf) {
        Buffer viewedBuffer = bufferViews.get(buf);
        if (viewedBuffer != null) {
            bufferEndiannessWritten.put(viewedBuffer, buf.order());
        }
    }

    private static void writeFloatBuffer(FloatBuffer buf) {
        Buffer viewedBuffer = bufferViews.get(buf);
        if (viewedBuffer != null) {
            bufferEndiannessWritten.put(viewedBuffer, buf.order());
        }
    }

    private static void writeDoubleBuffer(DoubleBuffer buf) {
        Buffer viewedBuffer = bufferViews.get(buf);
        if (viewedBuffer == null) {
            throw new AssertionError();
        }
        bufferEndiannessWritten.put(viewedBuffer, buf.order());
    }

    public static ByteBuffer slice(ByteBuffer buf) {
        ByteBuffer buffer = buf.slice();
        Buffer viewedBuffer = bufferViews.get(buf);
        if (viewedBuffer != null) {
            bufferViews.put(buffer, viewedBuffer);
        } else {
            bufferViews.put(buffer, buf);
        }
        return buffer;
    }

    public static CharBuffer slice(CharBuffer buf) {
        CharBuffer buffer = buf.slice();
        Buffer viewedBuffer = bufferViews.get(buf);
        if (viewedBuffer != null) {
            bufferViews.put(buffer, viewedBuffer);
        }
        return buffer;
    }

    public static ShortBuffer slice(ShortBuffer buf) {
        ShortBuffer buffer = buf.slice();
        Buffer viewedBuffer = bufferViews.get(buf);
        if (viewedBuffer != null) {
            bufferViews.put(buffer, viewedBuffer);
        }
        return buffer;
    }

    public static IntBuffer slice(IntBuffer buf) {
        IntBuffer buffer = buf.slice();
        Buffer viewedBuffer = bufferViews.get(buf);
        if (viewedBuffer != null) {
            bufferViews.put(buffer, viewedBuffer);
        }
        return buffer;
    }

    public static LongBuffer slice(LongBuffer buf) {
        LongBuffer buffer = buf.slice();
        Buffer viewedBuffer = bufferViews.get(buf);
        if (viewedBuffer != null) {
            bufferViews.put(buffer, viewedBuffer);
        }
        return buffer;
    }

    public static FloatBuffer slice(FloatBuffer buf) {
        FloatBuffer buffer = buf.slice();
        Buffer viewedBuffer = bufferViews.get(buf);
        if (viewedBuffer != null) {
            bufferViews.put(buffer, viewedBuffer);
        }
        return buffer;
    }

    public static DoubleBuffer slice(DoubleBuffer buf) {
        DoubleBuffer buffer = buf.slice();
        Buffer viewedBuffer = bufferViews.get(buf);
        if (viewedBuffer != null) {
            bufferViews.put(buffer, viewedBuffer);
        }
        return buffer;
    }

    public static CharBuffer asCharBuffer(ByteBuffer buf) {
        CharBuffer buffer = buf.asCharBuffer();
        Buffer viewedBuffer = bufferViews.get(buf);
        if (viewedBuffer != null) {
            bufferViews.put(buffer, viewedBuffer);
        } else {
            bufferViews.put(buffer, buf);
        }
        return buffer;
    }

    public static ShortBuffer asShortBuffer(ByteBuffer buf) {
        ShortBuffer buffer = buf.asShortBuffer();
        Buffer viewedBuffer = bufferViews.get(buf);
        if (viewedBuffer != null) {
            bufferViews.put(buffer, viewedBuffer);
        } else {
            bufferViews.put(buffer, buf);
        }
        return buffer;
    }

    public static IntBuffer asIntBuffer(ByteBuffer buf) {
        IntBuffer buffer = buf.asIntBuffer();
        Buffer viewedBuffer = bufferViews.get(buf);
        if (viewedBuffer != null) {
            bufferViews.put(buffer, viewedBuffer);
        } else {
            bufferViews.put(buffer, buf);
        }
        return buffer;
    }

    public static LongBuffer asLongBuffer(ByteBuffer buf) {
        LongBuffer buffer = buf.asLongBuffer();
        Buffer viewedBuffer = bufferViews.get(buf);
        if (viewedBuffer != null) {
            bufferViews.put(buffer, viewedBuffer);
        } else {
            bufferViews.put(buffer, buf);
        }
        return buffer;
    }

    public static FloatBuffer asFloatBuffer(ByteBuffer buf) {
        FloatBuffer buffer = buf.asFloatBuffer();
        Buffer viewedBuffer = bufferViews.get(buf);
        if (viewedBuffer != null) {
            bufferViews.put(buffer, viewedBuffer);
        } else {
            bufferViews.put(buffer, buf);
        }
        return buffer;
    }

    public static DoubleBuffer asDoubleBuffer(ByteBuffer buf) {
        DoubleBuffer buffer = buf.asDoubleBuffer();
        Buffer viewedBuffer = bufferViews.get(buf);
        if (viewedBuffer != null) {
            bufferViews.put(buffer, viewedBuffer);
        } else {
            bufferViews.put(buffer, buf);
        }
        return buffer;
    }

    public static ByteBuffer putChar(ByteBuffer buf, char value) {
        buf.putChar(value);
        RT.writeByteBuffer(buf);
        return buf;
    }

    public static ByteBuffer putChar(ByteBuffer buf, int index, char value) {
        buf.putChar(index, value);
        RT.writeByteBuffer(buf);
        return buf;
    }

    public static ByteBuffer putShort(ByteBuffer buf, short value) {
        buf.putShort(value);
        RT.writeByteBuffer(buf);
        return buf;
    }

    public static ByteBuffer putShort(ByteBuffer buf, int index, short value) {
        buf.putShort(index, value);
        RT.writeByteBuffer(buf);
        return buf;
    }

    public static ByteBuffer putInt(ByteBuffer buf, int value) {
        buf.putInt(value);
        RT.writeByteBuffer(buf);
        return buf;
    }

    public static ByteBuffer putInt(ByteBuffer buf, int index, int value) {
        buf.putInt(index, value);
        RT.writeByteBuffer(buf);
        return buf;
    }

    public static ByteBuffer putLong(ByteBuffer buf, long value) {
        buf.putLong(value);
        RT.writeByteBuffer(buf);
        return buf;
    }

    public static ByteBuffer putLong(ByteBuffer buf, int index, long value) {
        buf.putLong(index, value);
        RT.writeByteBuffer(buf);
        return buf;
    }

    public static ByteBuffer putFloat(ByteBuffer buf, float value) {
        buf.putFloat(value);
        RT.writeByteBuffer(buf);
        return buf;
    }

    public static ByteBuffer putFloat(ByteBuffer buf, int index, float value) {
        buf.putFloat(index, value);
        RT.writeByteBuffer(buf);
        return buf;
    }

    public static ByteBuffer putDouble(ByteBuffer buf, double value) {
        buf.putDouble(value);
        RT.writeByteBuffer(buf);
        return buf;
    }

    public static ByteBuffer putDouble(ByteBuffer buf, int index, double value) {
        buf.putDouble(index, value);
        RT.writeByteBuffer(buf);
        return buf;
    }

    public static CharBuffer put(CharBuffer buf, char s) {
        buf.put(s);
        RT.writeCharBuffer(buf);
        return buf;
    }

    public static CharBuffer put(CharBuffer buf, int index, char s) {
        buf.put(index, s);
        RT.writeCharBuffer(buf);
        return buf;
    }

    public static CharBuffer put(CharBuffer buf, CharBuffer src) {
        buf.put(src);
        RT.writeCharBuffer(buf);
        return buf;
    }

    public static CharBuffer put(CharBuffer buf, char[] src, int offset, int length) {
        buf.put(src, offset, length);
        RT.writeCharBuffer(buf);
        return buf;
    }

    public static CharBuffer put(CharBuffer buf, char[] src) {
        buf.put(src);
        RT.writeCharBuffer(buf);
        return buf;
    }

    public static ShortBuffer put(ShortBuffer buf, short s) {
        buf.put(s);
        RT.writeShortBuffer(buf);
        return buf;
    }

    public static ShortBuffer put(ShortBuffer buf, int index, short s) {
        buf.put(index, s);
        RT.writeShortBuffer(buf);
        return buf;
    }

    public static ShortBuffer put(ShortBuffer buf, ShortBuffer src) {
        buf.put(src);
        RT.writeShortBuffer(buf);
        return buf;
    }

    public static ShortBuffer put(ShortBuffer buf, short[] src, int offset, int length) {
        buf.put(src, offset, length);
        RT.writeShortBuffer(buf);
        return buf;
    }

    public static ShortBuffer put(ShortBuffer buf, short[] src) {
        buf.put(src);
        RT.writeShortBuffer(buf);
        return buf;
    }

    public static IntBuffer put(IntBuffer buf, int s) {
        buf.put(s);
        RT.writeIntBuffer(buf);
        return buf;
    }

    public static IntBuffer put(IntBuffer buf, int index, int s) {
        buf.put(index, s);
        RT.writeIntBuffer(buf);
        return buf;
    }

    public static IntBuffer put(IntBuffer buf, IntBuffer src) {
        buf.put(src);
        RT.writeIntBuffer(buf);
        return buf;
    }

    public static IntBuffer put(IntBuffer buf, int[] src, int offset, int length) {
        buf.put(src, offset, length);
        RT.writeIntBuffer(buf);
        return buf;
    }

    public static IntBuffer put(IntBuffer buf, int[] src) {
        buf.put(src);
        RT.writeIntBuffer(buf);
        return buf;
    }

    public static LongBuffer put(LongBuffer buf, long s) {
        buf.put(s);
        RT.writeLongBuffer(buf);
        return buf;
    }

    public static LongBuffer put(LongBuffer buf, int index, long s) {
        buf.put(index, s);
        RT.writeLongBuffer(buf);
        return buf;
    }

    public static LongBuffer put(LongBuffer buf, LongBuffer src) {
        buf.put(src);
        RT.writeLongBuffer(buf);
        return buf;
    }

    public static LongBuffer put(LongBuffer buf, long[] src, int offset, int length) {
        buf.put(src, offset, length);
        RT.writeLongBuffer(buf);
        return buf;
    }

    public static LongBuffer put(LongBuffer buf, long[] src) {
        buf.put(src);
        RT.writeLongBuffer(buf);
        return buf;
    }

    public static FloatBuffer put(FloatBuffer buf, float s) {
        buf.put(s);
        RT.writeFloatBuffer(buf);
        return buf;
    }

    public static FloatBuffer put(FloatBuffer buf, int index, float s) {
        buf.put(index, s);
        RT.writeFloatBuffer(buf);
        return buf;
    }

    public static FloatBuffer put(FloatBuffer buf, FloatBuffer src) {
        buf.put(src);
        RT.writeFloatBuffer(buf);
        return buf;
    }

    public static FloatBuffer put(FloatBuffer buf, float[] src, int offset, int length) {
        buf.put(src, offset, length);
        RT.writeFloatBuffer(buf);
        return buf;
    }

    public static FloatBuffer put(FloatBuffer buf, float[] src) {
        buf.put(src);
        RT.writeFloatBuffer(buf);
        return buf;
    }

    public static DoubleBuffer put(DoubleBuffer buf, double s) {
        buf.put(s);
        RT.writeDoubleBuffer(buf);
        return buf;
    }

    public static DoubleBuffer put(DoubleBuffer buf, int index, double s) {
        buf.put(index, s);
        RT.writeDoubleBuffer(buf);
        return buf;
    }

    public static DoubleBuffer put(DoubleBuffer buf, DoubleBuffer src) {
        buf.put(src);
        RT.writeDoubleBuffer(buf);
        return buf;
    }

    public static DoubleBuffer put(DoubleBuffer buf, double[] src, int offset, int length) {
        buf.put(src, offset, length);
        RT.writeDoubleBuffer(buf);
        return buf;
    }

    public static DoubleBuffer put(DoubleBuffer buf, double[] src) {
        buf.put(src);
        RT.writeDoubleBuffer(buf);
        return buf;
    }

    public static MethodCall methodCall(String source, int line, String name) {
        return new MethodCall(source, line, name);
    }

    public static void methodCall(MethodCall mc) {
        Log.trace(mc.toString());
    }

    public static MethodCall paramGlfwWindow(MethodCall mc, long window) {
        Context ctx = Context.CONTEXTS.get(window);
        if (ctx == null) {
            mc.param(window);
        } else {
            mc.paramEnum("window[" + ctx.counter + "]");
        }
        return mc;
    }

    public static MethodCall paramGlfwMonitor(MethodCall mc, long monitor) {
        PointerBuffer monitors = GLFW.glfwGetMonitors();
        for (int i = 0; i < monitors.remaining(); ++i) {
            long m = monitors.get(i);
            if (m != monitor) continue;
            mc.paramEnum("monitor[" + i + "]");
            return mc;
        }
        mc.param(monitor);
        return mc;
    }

    public static int returnValue(int val, MethodCall mc) {
        return mc.returnValue(val);
    }

    public static short returnValue(short val, MethodCall mc) {
        return mc.returnValue(val);
    }

    public static long returnValue(long val, MethodCall mc) {
        return mc.returnValue(val);
    }

    public static boolean returnValue(boolean val, MethodCall mc) {
        return mc.returnValue(val);
    }

    public static char returnValue(char val, MethodCall mc) {
        return mc.returnValue(val);
    }

    public static float returnValue(float val, MethodCall mc) {
        return mc.returnValue(val);
    }

    public static double returnValue(double val, MethodCall mc) {
        return mc.returnValue(val);
    }

    public static Object returnValue(Object val, MethodCall mc) {
        return mc.returnValue(val);
    }

    public static long returnValueGlfwWindow(long window, MethodCall mc) {
        Context ctx = Context.CONTEXTS.get(window);
        if (ctx == null) {
            mc.returnValue(window);
        } else {
            mc.returnValueEnum("window[" + ctx.counter + "]");
        }
        return window;
    }

    public static long returnValueGlfwMonitor(long monitor, MethodCall mc) {
        PointerBuffer monitors = GLFW.glfwGetMonitors();
        for (int i = 0; i < monitors.remaining(); ++i) {
            long m = monitors.get(i);
            if (m != monitor) continue;
            mc.returnValueEnum("monitor[" + i + "]");
            return monitor;
        }
        mc.returnValue(monitor);
        return monitor;
    }

    public static void checkFunction(long addr, String glCall) {
        if (addr == 0L) {
            throw new IllegalStateException(glCall + " is not supported in the current profile");
        }
    }

    public static void checkError(String glCall) {
        int err;
        Context context = Context.CURRENT_CONTEXT.get();
        if (context != null && context.debugCallback == null && !context.inImmediateMode && (err = GL11.glGetError()) != 0) {
            RT.throwISEOrLogError(glCall + " produced error: " + err + " (" + RT.glErrorToString(err) + ")");
        }
    }

    public static String glErrorToString(int err) {
        switch (err) {
            case 1280: {
                return "GL_INVALID_ENUM";
            }
            case 1281: {
                return "GL_INVALID_VALUE";
            }
            case 1282: {
                return "GL_INVALID_OPERATION";
            }
            case 1283: {
                return "GL_STACK_OVERFLOW";
            }
            case 1284: {
                return "GL_STACK_UNDERFLOW";
            }
            case 1285: {
                return "GL_OUT_OF_MEMORY";
            }
            case 1286: {
                return "GL_INVALID_FRAMEBUFFER_OPERATION";
            }
            case 1287: {
                return "GL_CONTEXT_LOST";
            }
            case 32817: {
                return "GL_TABLE_TOO_LARGE";
            }
        }
        return "<UNKNOWN>";
    }

    public static <T extends Throwable> T filterStackTrace(T t, int offset) {
        StackTraceElement[] elems = t.getStackTrace();
        StackTraceElement[] filtered = new StackTraceElement[elems.length];
        int j = 0;
        for (int i = offset; i < elems.length; ++i) {
            String className = elems[i].getClassName();
            if (className == null) {
                className = "";
            }
            if (className.startsWith("org.lwjglx.") && !className.startsWith("org.lwjglx.debug.opengl") && !className.startsWith("org.lwjglx.debug.glfw")) continue;
            filtered[j++] = elems[i];
        }
        StackTraceElement[] newElems = new StackTraceElement[j];
        System.arraycopy(filtered, 0, newElems, 0, j);
        t.setStackTrace(newElems);
        return t;
    }

    public static void throwISEOrLogError(String message) {
        RT.throwISEOrLogError(message, true, 2);
    }

    public static void throwISEOrLogError(String message, boolean stacktrace, int offset) {
        IllegalStateException e = RT.filterStackTrace(new IllegalStateException(message), offset);
        if (!Properties.NO_THROW_ON_ERROR.enabled) {
            throw e;
        }
        Log.error(message, stacktrace ? e : null);
    }

    public static void throwIAEOrLogError(String message) {
        RT.throwIAEOrLogError(message, true);
    }

    public static void throwIAEOrLogError(String message, boolean stacktrace) {
        IllegalArgumentException e = RT.filterStackTrace(new IllegalArgumentException(message), 2);
        if (!Properties.NO_THROW_ON_ERROR.enabled) {
            throw e;
        }
        Log.error(message, stacktrace ? e : null);
    }

    private static void checkBufferDirect(Buffer buffer, String type, String methodName) {
        if (buffer == null) {
            return;
        }
        if (!buffer.isDirect()) {
            RT.throwIAEOrLogError("buffer is not direct. Buffers created via " + type + ".allocate() or " + type + ".wrap() are not supported. Use BufferUtils.create" + type + "() instead.");
        } else if (buffer.capacity() == 0) {
            String message = "buffer has zero capacity.";
            if ("glBufferData".equals(methodName)) {
                message = message + " If you want to clear an OpenGL buffer object, use GL15.glBufferData(target, size=0, usage) instead.";
            }
            RT.throwIAEOrLogError(message);
        } else if (buffer.remaining() == 0) {
            RT.throwIAEOrLogError("buffer has no remaining elements. Did you forget to flip()/rewind() it?");
        }
    }

    public static void checkFlipBufferAtPosition0(Buffer buffer) {
        if (buffer.position() == 0) {
            RT.throwISEOrLogError("calling flip() on a buffer with position = 0. Check if you called a method that actually modifies the buffer position.");
        }
    }

    public static void checkBuffer(ByteBuffer buffer, String methodName) {
        RT.checkBufferDirect(buffer, "ByteBuffer", methodName);
        RT.checkNativeByteOrder(buffer);
    }

    public static void checkBuffer(ShortBuffer buffer, String methodName) {
        RT.checkBufferDirect(buffer, "ShortBuffer", methodName);
        RT.checkNativeByteOrder(buffer);
    }

    public static void checkBuffer(FloatBuffer buffer, String methodName) {
        RT.checkBufferDirect(buffer, "FloatBuffer", methodName);
        RT.checkNativeByteOrder(buffer);
    }

    public static void checkBuffer(IntBuffer buffer, String methodName) {
        RT.checkBufferDirect(buffer, "IntBuffer", methodName);
        RT.checkNativeByteOrder(buffer);
    }

    public static void checkBuffer(DoubleBuffer buffer, String methodName) {
        RT.checkBufferDirect(buffer, "DoubleBuffer", methodName);
        RT.checkNativeByteOrder(buffer);
    }

    public static void checkBuffer(LongBuffer buffer, String methodName) {
        RT.checkBufferDirect(buffer, "LongBuffer", methodName);
        RT.checkNativeByteOrder(buffer);
    }

    public static void checkNotNull(Object paramValue, int paramIndex, String paramName) {
        if (paramValue == null) {
            if (paramName != null) {
                throw new IllegalArgumentException("Argument for " + (paramIndex + 1) + ". parameter '" + paramName + "' must not be null");
            }
            throw new IllegalArgumentException("Argument for " + (paramIndex + 1) + ". parameter must not be null");
        }
    }

    public static String glEnumFor(int value, Map<Integer, String> initialGroup) {
        String glEnum = null;
        if (glEnum == null) {
            glEnum = initialGroup.get(value);
        }
        if (glEnum == null && initialGroup != GLmetadata._null_()) {
            glEnum = GLmetadata._null_().get(value);
        }
        return glEnum;
    }

    public static String glEnumFor(Command cmd, int paramIndex, int value) {
        Param param = cmd.params.get(paramIndex);
        String glEnum = null;
        if (cmd.extension != null) {
            glEnum = cmd.extension.get(value);
        }
        if (glEnum == null) {
            glEnum = param.group.get(value);
        }
        if (glEnum == null && param.group != GLmetadata._null_()) {
            glEnum = GLmetadata._null_().get(value);
        }
        return glEnum;
    }

    public static int glEnumReturn(int value, MethodCall mc, Command cmd) {
        String glEnum = null;
        if (cmd.extension != null) {
            glEnum = cmd.extension.get(value);
        }
        if (glEnum == null) {
            glEnum = cmd.returnGroup.get(value);
        }
        if (glEnum == null && cmd.returnGroup != GLmetadata._null_()) {
            glEnum = GLmetadata._null_().get(value);
        }
        mc.returnValueEnum(glEnum);
        return value;
    }

    public static String decodeBitField(Command cmd, int paramIndex, int value) {
        Param param = cmd.params.get(paramIndex);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Integer, String> e : param.group.entrySet()) {
            int bitmask = e.getKey();
            int v = value & bitmask;
            int rest = v ^ bitmask;
            if (v == 0 || rest != 0) continue;
            if (sb.length() == 0) {
                sb.append(e.getValue());
                continue;
            }
            sb.append(" | ").append(e.getValue());
        }
        return sb.toString();
    }

    public static void delay() {
        try {
            Thread.sleep(Properties.SLEEP);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void beforeDraw() {
        if (Properties.VALIDATE.enabled) {
            Context.checkFramebufferCompleteness();
        }
        Context ctx = Context.CURRENT_CONTEXT.get();
        if (ctx.caps.GL_ARB_timer_query) {
            Context.TimingQuery q = ctx.nextTimerQuery();
            q.drawTime = true;
            ARBTimerQuery.glQueryCounter(q.before, 36392);
            ctx.currentTimingQuery = q;
        }
    }

    public static void draw(int verticesCount) {
        if (Properties.VALIDATE.enabled && verticesCount == 0) {
            Log.warn("Draw call with 0 vertices", new Throwable(), 3);
        }
        Context ctx = Context.CURRENT_CONTEXT.get();
        ctx.verticesCount += verticesCount;
        ctx.drawCallSeen = true;
        if (Properties.PROFILE.enabled && ctx.caps.GL_ARB_timer_query) {
            Context.TimingQuery q = ctx.currentTimingQuery;
            ARBTimerQuery.glQueryCounter(q.after, 36392);
        }
    }

    public static void beginImmediate() {
        if (Properties.VALIDATE.enabled) {
            Context.checkFramebufferCompleteness();
        }
        Context ctx = Context.CURRENT_CONTEXT.get();
        ctx.inImmediateMode = true;
        ctx.drawCallSeen = true;
        if (Properties.PROFILE.enabled) {
            RT.beforeDraw();
        }
    }

    public static void endImmediate() {
        Context ctx = Context.CURRENT_CONTEXT.get();
        ctx.inImmediateMode = false;
        if (Properties.PROFILE.enabled) {
            RT.draw(ctx.immediateModeVertices);
            ctx.immediateModeVertices = 0;
        }
    }

    public static void vertex() {
        Context ctx = Context.CURRENT_CONTEXT.get();
        ++ctx.immediateModeVertices;
    }

    public static void frame() {
        Context ctx = Context.CURRENT_CONTEXT.get();
        ctx.frameEndTime = System.nanoTime();
        float drawTime = 0.0f;
        ++ctx.frame;
        if (Properties.VALIDATE.enabled && !ctx.drawCallSeen) {
            Log.info("No draw call seen in frame [" + ctx.frame + "]");
        }
        if (Properties.PROFILE.enabled && ctx.caps.GL_ARB_timer_query) {
            if (ctx.lastCodeSectionQuery != null) {
                ARBTimerQuery.glQueryCounter(ctx.lastCodeSectionQuery.after, 36392);
                ctx.lastCodeSectionQuery = null;
            }
            ctx.currentCodeSectionIndex = 0;
            for (int i = 0; i < ctx.timingQueries.size(); ++i) {
                Context.TimingQuery q = ctx.timingQueries.get(i);
                if (!q.used) continue;
                while (ARBOcclusionQuery.glGetQueryObjectiARB(q.before, 34919) == 0) {
                }
                while (ARBOcclusionQuery.glGetQueryObjectiARB(q.after, 34919) == 0) {
                }
                long time0 = ARBTimerQuery.glGetQueryObjectui64(q.before, 34918);
                long time1 = ARBTimerQuery.glGetQueryObjectui64(q.after, 34918);
                q.time0 = time0;
                q.time1 = time1;
                if (q.drawTime) {
                    drawTime += (float)(time1 - time0) / 1000000.0f;
                }
                q.used = false;
            }
            ctx.drawCallTimeMs = drawTime;
            Profiling.frame(ctx);
            for (Context.TimedCodeSection section : ctx.codeSectionTimes) {
                section.queries.clear();
            }
        }
        ctx.verticesCount = 0;
        ctx.drawCallSeen = false;
        ctx.glCallCount = 0;
        ctx.frameStartTime = ctx.frameEndTime;
    }

    public static void glCall() {
        Context ctx = Context.CURRENT_CONTEXT.get();
        ++ctx.glCallCount;
    }

    private static int textureSize(int internalFormat, int width, int height) {
        switch (internalFormat) {
            case 6402: {
                return width * height * 3;
            }
            case 34041: {
                return width * height * 4;
            }
            case 6403: {
                return width * height;
            }
            case 33319: {
                return width * height * 2;
            }
            case 6407: {
                return width * height * 3;
            }
            case 6408: {
                return width * height * 4;
            }
            case 33321: {
                return width * height;
            }
            case 36756: {
                return width * height;
            }
            case 33322: {
                return width * height * 16 / 8;
            }
            case 36760: {
                return width * height * 16 / 8;
            }
            case 33323: {
                return width * height * 16 / 8;
            }
            case 36757: {
                return width * height * 16 / 8;
            }
            case 33324: {
                return width * height * 32 / 8;
            }
            case 36761: {
                return width * height * 32 / 8;
            }
            case 10768: {
                return width * height * 8 / 8;
            }
            case 32847: {
                return width * height * 12 / 8;
            }
            case 32848: {
                return width * height * 15 / 8;
            }
            case 32849: {
                return width * height * 24 / 8;
            }
            case 36758: {
                return width * height * 24 / 8;
            }
            case 32850: {
                return width * height * 30 / 8;
            }
            case 32851: {
                return width * height * 36 / 8;
            }
            case 36762: {
                return width * height * 48 / 8;
            }
            case 32853: {
                return width * height * 8 / 8;
            }
            case 32854: {
                return width * height * 16 / 8;
            }
            case 32855: {
                return width * height * 16 / 8;
            }
            case 32856: {
                return width * height * 32 / 8;
            }
            case 36759: {
                return width * height * 32 / 8;
            }
            case 32857: {
                return width * height * 32 / 8;
            }
            case 36975: {
                return width * height * 32 / 8;
            }
            case 32858: {
                return width * height * 42 / 8;
            }
            case 32859: {
                return width * height * 64 / 8;
            }
            case 35905: {
                return width * height * 24 / 8;
            }
            case 35907: {
                return width * height * 32 / 8;
            }
            case 33325: {
                return width * height * 16 / 8;
            }
            case 33327: {
                return width * height * 32 / 8;
            }
            case 34843: {
                return width * height * 48 / 8;
            }
            case 34842: {
                return width * height * 64 / 8;
            }
            case 33326: {
                return width * height * 32 / 8;
            }
            case 33328: {
                return width * height * 64 / 8;
            }
            case 34837: {
                return width * height * 96 / 8;
            }
            case 34836: {
                return width * height * 128 / 8;
            }
            case 35898: {
                return width * height * 32 / 8;
            }
            case 35901: {
                return width * height * 22 / 8;
            }
            case 33329: {
                return width * height * 8 / 8;
            }
            case 33330: {
                return width * height * 8 / 8;
            }
            case 33331: {
                return width * height * 16 / 8;
            }
            case 33332: {
                return width * height * 16 / 8;
            }
            case 33333: {
                return width * height * 32 / 8;
            }
            case 33334: {
                return width * height * 32 / 8;
            }
            case 33335: {
                return width * height * 16 / 8;
            }
            case 33336: {
                return width * height * 16 / 8;
            }
            case 33337: {
                return width * height * 32 / 8;
            }
            case 33338: {
                return width * height * 32 / 8;
            }
            case 33339: {
                return width * height * 64 / 8;
            }
            case 33340: {
                return width * height * 64 / 8;
            }
            case 36239: {
                return width * height * 24 / 8;
            }
            case 36221: {
                return width * height * 24 / 8;
            }
            case 36233: {
                return width * height * 16 * 3 / 8;
            }
            case 36215: {
                return width * height * 16 * 3 / 8;
            }
            case 36227: {
                return width * height * 32 * 3 / 8;
            }
            case 36209: {
                return width * height * 32 * 3 / 8;
            }
            case 36238: {
                return width * height * 8 * 4 / 8;
            }
            case 36220: {
                return width * height * 8 * 4 / 8;
            }
            case 36232: {
                return width * height * 16 * 4 / 8;
            }
            case 36214: {
                return width * height * 16 * 4 / 8;
            }
            case 36226: {
                return width * height * 32 * 4 / 8;
            }
            case 36208: {
                return width * height * 32 * 4 / 8;
            }
        }
        return width * height;
    }

    public static void setTextureLayerSize(int target, int level, int internalformat, int width, int height, Context.TextureObject obj) {
        Context.TextureLayer tlayer = null;
        if (target >= 34069 && target <= 34074) {
            int layer = target - 34069;
            tlayer = obj.layers[layer];
        } else {
            tlayer = obj.layers[0];
        }
        tlayer.ensureLevel(level);
        Context.TextureLevel tlevel = tlayer.levels[level];
        tlevel.internalformat = internalformat;
        tlevel.width = width;
        tlevel.height = height;
        tlevel.size = RT.textureSize(internalformat, width, height);
    }

    public static void generateMipmap(int target) {
        Context ctx = Context.CURRENT_CONTEXT.get();
        Context.TextureObject to = ctx.textureObjectBindings.get(target);
        if (to != null && to.layers != null) {
            int maxLevel = ctx.caps.OpenGL12 ? GL11.glGetTexParameteri(target, 33085) : 1000;
            for (int i = 0; i < to.layers.length; ++i) {
                int layerTarget = target;
                if (target == 34067) {
                    layerTarget = 34069 + i;
                }
                Context.TextureLayer layer = to.layers[i];
                Context.TextureLevel level0 = layer.levels[0];
                int width = level0.width;
                int height = level0.height;
                int level = 0;
                while (width > 1 || height > 1 && level < maxLevel) {
                    RT.setTextureLayerSize(layerTarget, ++level, level0.internalformat, width >>>= 1, height >>>= 1, to);
                }
            }
        }
    }

    public static void checkMainThread(String methodName) {
        Thread currentThread = Thread.currentThread();
        if (currentThread != mainThread) {
            RT.throwISEOrLogError("Method " + methodName + " was called in thread [" + currentThread + "] which is not the main thread.");
        }
    }

    public static void checkGlfwInitialized(String methodName) {
        if (!glfwInitialized) {
            RT.throwISEOrLogError("Method " + methodName + " was called before initializing GLFW via glfwInit().");
        }
    }

    public static void stringMarker(String string) {
        Context.TimedCodeSection section;
        Context ctx = Context.CURRENT_CONTEXT.get();
        if (!ctx.caps.GL_ARB_timer_query) {
            return;
        }
        if (ctx.lastCodeSectionQuery != null) {
            ARBTimerQuery.glQueryCounter(ctx.lastCodeSectionQuery.after, 36392);
            ctx.lastCodeSectionQuery = null;
        }
        if (string.equals("end")) {
            return;
        }
        if (ctx.codeSectionTimes.size() <= ctx.currentCodeSectionIndex) {
            section = new Context.TimedCodeSection();
            section.name = string;
            ctx.codeSectionTimes.add(section);
        } else {
            section = ctx.codeSectionTimes.get(ctx.currentCodeSectionIndex);
            if (section == null || !section.name.equals(string)) {
                for (int i = ctx.currentCodeSectionIndex + 1; i < ctx.codeSectionTimes.size(); ++i) {
                    ctx.codeSectionTimes.set(i, null);
                }
                section = new Context.TimedCodeSection();
                section.name = string;
                ctx.codeSectionTimes.set(ctx.currentCodeSectionIndex, section);
            }
        }
        Context.TimingQuery q = ctx.nextTimerQuery();
        section.queries.add(q);
        ARBTimerQuery.glQueryCounter(q.before, 36392);
        ctx.lastCodeSectionQuery = q;
        ++ctx.currentCodeSectionIndex;
    }

    public static void checkGlfwMonitor(long monitor) {
        if (monitor == 0L) {
            return;
        }
        PointerBuffer pb = GLFW.glfwGetMonitors();
        for (int i = 0; i < pb.remaining(); ++i) {
            if (pb.get(i) != monitor) continue;
            return;
        }
        RT.throwIAEOrLogError("Provided 'monitor' argument is not a valid GLFW monitor handle: " + monitor);
    }

    public static void checkGlfwWindow(long share) {
        if (share == 0L) {
            return;
        }
        for (Context ctx : Context.CONTEXTS.values()) {
            if (ctx.window != share) continue;
            return;
        }
        RT.throwIAEOrLogError("Provided 'share' argument is not a valid GLFW window handle: " + share);
    }
}

