/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug;

public class Properties {
    public static final BooleanProperty VALIDATE = Properties.getBooleanProperty("org.lwjglx.VALIDATE", true);
    public static final BooleanProperty STRICT = Properties.getBooleanProperty("org.lwjglx.STRICT", false);
    public static final BooleanProperty DEBUG = Properties.getBooleanProperty("org.lwjglx.DEBUG", false);
    public static final BooleanProperty TRACE = Properties.getBooleanProperty("org.lwjglx.TRACE", false);
    public static final BooleanProperty PROFILE = Properties.getBooleanProperty("org.lwjglx.PROFILE", false);
    public static final BooleanProperty PROFILE_SUSPEND = new BooleanProperty();
    public static final BooleanProperty NO_THROW_ON_ERROR = Properties.getBooleanProperty("org.lwjglx.NO_THROW", false);
    public static String OUTPUT = System.getProperty("org.lwjglx.OUTPUT", null);
    public static long SLEEP = Properties.getLongProperty("org.lwjglx.SLEEP", 0L);

    private static BooleanProperty getBooleanProperty(String prop, boolean def) {
        String value = System.getProperty(prop);
        BooleanProperty p = new BooleanProperty();
        if (value != null) {
            p.byDefault = false;
            p.enabled = value.equals("") || Boolean.valueOf(value) != false;
        } else {
            p.byDefault = true;
            p.enabled = def;
        }
        return p;
    }

    private static long getLongProperty(String prop, long def) {
        String value = System.getProperty(prop);
        try {
            if (value != null) {
                return Long.valueOf(value);
            }
            return def;
        }
        catch (NumberFormatException e) {
            throw new AssertionError((Object)("System property [" + prop + "] is not an integer: " + value));
        }
    }

    public static class BooleanProperty {
        public boolean enabled;
        public boolean byDefault = true;

        public void enable() {
            this.enabled = true;
            this.byDefault = false;
        }

        public void disableIfByDefault() {
            if (this.byDefault) {
                this.enabled = false;
                this.byDefault = false;
            }
        }
    }
}

