/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkViewportSwizzleNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;
    public static final int W;

    VkViewportSwizzleNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkViewportSwizzleNV(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkViewportSwizzleNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkViewportCoordinateSwizzleNV")
    public int x() {
        return VkViewportSwizzleNV.nx(this.address());
    }

    @NativeType(value="VkViewportCoordinateSwizzleNV")
    public int y() {
        return VkViewportSwizzleNV.ny(this.address());
    }

    @NativeType(value="VkViewportCoordinateSwizzleNV")
    public int z() {
        return VkViewportSwizzleNV.nz(this.address());
    }

    @NativeType(value="VkViewportCoordinateSwizzleNV")
    public int w() {
        return VkViewportSwizzleNV.nw(this.address());
    }

    public VkViewportSwizzleNV x(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
        VkViewportSwizzleNV.nx(this.address(), value);
        return this;
    }

    public VkViewportSwizzleNV y(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
        VkViewportSwizzleNV.ny(this.address(), value);
        return this;
    }

    public VkViewportSwizzleNV z(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
        VkViewportSwizzleNV.nz(this.address(), value);
        return this;
    }

    public VkViewportSwizzleNV w(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
        VkViewportSwizzleNV.nw(this.address(), value);
        return this;
    }

    public VkViewportSwizzleNV set(int x, int y, int z, int w) {
        this.x(x);
        this.y(y);
        this.z(z);
        this.w(w);
        return this;
    }

    public VkViewportSwizzleNV set(VkViewportSwizzleNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkViewportSwizzleNV malloc() {
        return VkViewportSwizzleNV.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkViewportSwizzleNV calloc() {
        return VkViewportSwizzleNV.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkViewportSwizzleNV create() {
        return new VkViewportSwizzleNV(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkViewportSwizzleNV create(long address) {
        return new VkViewportSwizzleNV(address, null);
    }

    @Nullable
    public static VkViewportSwizzleNV createSafe(long address) {
        return address == 0L ? null : VkViewportSwizzleNV.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkViewportSwizzleNV.create(VkViewportSwizzleNV.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkViewportSwizzleNV.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkViewportSwizzleNV.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkViewportSwizzleNV.create(address, capacity);
    }

    public static VkViewportSwizzleNV mallocStack() {
        return VkViewportSwizzleNV.mallocStack(MemoryStack.stackGet());
    }

    public static VkViewportSwizzleNV callocStack() {
        return VkViewportSwizzleNV.callocStack(MemoryStack.stackGet());
    }

    public static VkViewportSwizzleNV mallocStack(MemoryStack stack) {
        return VkViewportSwizzleNV.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkViewportSwizzleNV callocStack(MemoryStack stack) {
        return VkViewportSwizzleNV.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkViewportSwizzleNV.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkViewportSwizzleNV.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkViewportSwizzleNV.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkViewportSwizzleNV.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt(struct + (long)X);
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt(struct + (long)Y);
    }

    public static int nz(long struct) {
        return MemoryUtil.memGetInt(struct + (long)Z);
    }

    public static int nw(long struct) {
        return MemoryUtil.memGetInt(struct + (long)W);
    }

    public static void nx(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)X, value);
    }

    public static void ny(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)Y, value);
    }

    public static void nz(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)Z, value);
    }

    public static void nw(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)W, value);
    }

    static {
        Struct.Layout layout = VkViewportSwizzleNV.__struct(VkViewportSwizzleNV.__member(4), VkViewportSwizzleNV.__member(4), VkViewportSwizzleNV.__member(4), VkViewportSwizzleNV.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
        W = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkViewportSwizzleNV, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkViewportSwizzleNV newInstance(long address) {
            return new VkViewportSwizzleNV(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkViewportCoordinateSwizzleNV")
        public int x() {
            return VkViewportSwizzleNV.nx(this.address());
        }

        @NativeType(value="VkViewportCoordinateSwizzleNV")
        public int y() {
            return VkViewportSwizzleNV.ny(this.address());
        }

        @NativeType(value="VkViewportCoordinateSwizzleNV")
        public int z() {
            return VkViewportSwizzleNV.nz(this.address());
        }

        @NativeType(value="VkViewportCoordinateSwizzleNV")
        public int w() {
            return VkViewportSwizzleNV.nw(this.address());
        }

        public Buffer x(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
            VkViewportSwizzleNV.nx(this.address(), value);
            return this;
        }

        public Buffer y(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
            VkViewportSwizzleNV.ny(this.address(), value);
            return this;
        }

        public Buffer z(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
            VkViewportSwizzleNV.nz(this.address(), value);
            return this;
        }

        public Buffer w(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
            VkViewportSwizzleNV.nw(this.address(), value);
            return this;
        }
    }
}

