/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkVertexInputBindingDescription
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BINDING;
    public static final int STRIDE;
    public static final int INPUTRATE;

    VkVertexInputBindingDescription(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkVertexInputBindingDescription(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkVertexInputBindingDescription.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int binding() {
        return VkVertexInputBindingDescription.nbinding(this.address());
    }

    @NativeType(value="uint32_t")
    public int stride() {
        return VkVertexInputBindingDescription.nstride(this.address());
    }

    @NativeType(value="VkVertexInputRate")
    public int inputRate() {
        return VkVertexInputBindingDescription.ninputRate(this.address());
    }

    public VkVertexInputBindingDescription binding(@NativeType(value="uint32_t") int value) {
        VkVertexInputBindingDescription.nbinding(this.address(), value);
        return this;
    }

    public VkVertexInputBindingDescription stride(@NativeType(value="uint32_t") int value) {
        VkVertexInputBindingDescription.nstride(this.address(), value);
        return this;
    }

    public VkVertexInputBindingDescription inputRate(@NativeType(value="VkVertexInputRate") int value) {
        VkVertexInputBindingDescription.ninputRate(this.address(), value);
        return this;
    }

    public VkVertexInputBindingDescription set(int binding, int stride, int inputRate) {
        this.binding(binding);
        this.stride(stride);
        this.inputRate(inputRate);
        return this;
    }

    public VkVertexInputBindingDescription set(VkVertexInputBindingDescription src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkVertexInputBindingDescription malloc() {
        return VkVertexInputBindingDescription.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkVertexInputBindingDescription calloc() {
        return VkVertexInputBindingDescription.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkVertexInputBindingDescription create() {
        return new VkVertexInputBindingDescription(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkVertexInputBindingDescription create(long address) {
        return new VkVertexInputBindingDescription(address, null);
    }

    @Nullable
    public static VkVertexInputBindingDescription createSafe(long address) {
        return address == 0L ? null : VkVertexInputBindingDescription.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkVertexInputBindingDescription.create(VkVertexInputBindingDescription.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkVertexInputBindingDescription.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkVertexInputBindingDescription.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkVertexInputBindingDescription.create(address, capacity);
    }

    public static VkVertexInputBindingDescription mallocStack() {
        return VkVertexInputBindingDescription.mallocStack(MemoryStack.stackGet());
    }

    public static VkVertexInputBindingDescription callocStack() {
        return VkVertexInputBindingDescription.callocStack(MemoryStack.stackGet());
    }

    public static VkVertexInputBindingDescription mallocStack(MemoryStack stack) {
        return VkVertexInputBindingDescription.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkVertexInputBindingDescription callocStack(MemoryStack stack) {
        return VkVertexInputBindingDescription.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkVertexInputBindingDescription.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkVertexInputBindingDescription.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkVertexInputBindingDescription.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkVertexInputBindingDescription.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nbinding(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BINDING);
    }

    public static int nstride(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STRIDE);
    }

    public static int ninputRate(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INPUTRATE);
    }

    public static void nbinding(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BINDING, value);
    }

    public static void nstride(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STRIDE, value);
    }

    public static void ninputRate(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INPUTRATE, value);
    }

    static {
        Struct.Layout layout = VkVertexInputBindingDescription.__struct(VkVertexInputBindingDescription.__member(4), VkVertexInputBindingDescription.__member(4), VkVertexInputBindingDescription.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BINDING = layout.offsetof(0);
        STRIDE = layout.offsetof(1);
        INPUTRATE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkVertexInputBindingDescription, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkVertexInputBindingDescription newInstance(long address) {
            return new VkVertexInputBindingDescription(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="uint32_t")
        public int binding() {
            return VkVertexInputBindingDescription.nbinding(this.address());
        }

        @NativeType(value="uint32_t")
        public int stride() {
            return VkVertexInputBindingDescription.nstride(this.address());
        }

        @NativeType(value="VkVertexInputRate")
        public int inputRate() {
            return VkVertexInputBindingDescription.ninputRate(this.address());
        }

        public Buffer binding(@NativeType(value="uint32_t") int value) {
            VkVertexInputBindingDescription.nbinding(this.address(), value);
            return this;
        }

        public Buffer stride(@NativeType(value="uint32_t") int value) {
            VkVertexInputBindingDescription.nstride(this.address(), value);
            return this;
        }

        public Buffer inputRate(@NativeType(value="VkVertexInputRate") int value) {
            VkVertexInputBindingDescription.ninputRate(this.address(), value);
            return this;
        }
    }
}

