/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSubresourceLayout
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET;
    public static final int SIZE;
    public static final int ROWPITCH;
    public static final int ARRAYPITCH;
    public static final int DEPTHPITCH;

    VkSubresourceLayout(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkSubresourceLayout(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSubresourceLayout.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VkSubresourceLayout.noffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkSubresourceLayout.nsize(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long rowPitch() {
        return VkSubresourceLayout.nrowPitch(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long arrayPitch() {
        return VkSubresourceLayout.narrayPitch(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long depthPitch() {
        return VkSubresourceLayout.ndepthPitch(this.address());
    }

    public static VkSubresourceLayout malloc() {
        return VkSubresourceLayout.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSubresourceLayout calloc() {
        return VkSubresourceLayout.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSubresourceLayout create() {
        return new VkSubresourceLayout(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSubresourceLayout create(long address) {
        return new VkSubresourceLayout(address, null);
    }

    @Nullable
    public static VkSubresourceLayout createSafe(long address) {
        return address == 0L ? null : VkSubresourceLayout.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkSubresourceLayout.create(VkSubresourceLayout.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSubresourceLayout.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkSubresourceLayout.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSubresourceLayout.create(address, capacity);
    }

    public static VkSubresourceLayout mallocStack() {
        return VkSubresourceLayout.mallocStack(MemoryStack.stackGet());
    }

    public static VkSubresourceLayout callocStack() {
        return VkSubresourceLayout.callocStack(MemoryStack.stackGet());
    }

    public static VkSubresourceLayout mallocStack(MemoryStack stack) {
        return VkSubresourceLayout.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSubresourceLayout callocStack(MemoryStack stack) {
        return VkSubresourceLayout.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSubresourceLayout.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSubresourceLayout.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSubresourceLayout.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSubresourceLayout.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OFFSET);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SIZE);
    }

    public static long nrowPitch(long struct) {
        return MemoryUtil.memGetLong(struct + (long)ROWPITCH);
    }

    public static long narrayPitch(long struct) {
        return MemoryUtil.memGetLong(struct + (long)ARRAYPITCH);
    }

    public static long ndepthPitch(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DEPTHPITCH);
    }

    static {
        Struct.Layout layout = VkSubresourceLayout.__struct(VkSubresourceLayout.__member(8), VkSubresourceLayout.__member(8), VkSubresourceLayout.__member(8), VkSubresourceLayout.__member(8), VkSubresourceLayout.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        ROWPITCH = layout.offsetof(2);
        ARRAYPITCH = layout.offsetof(3);
        DEPTHPITCH = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkSubresourceLayout, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSubresourceLayout newInstance(long address) {
            return new VkSubresourceLayout(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VkSubresourceLayout.noffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkSubresourceLayout.nsize(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long rowPitch() {
            return VkSubresourceLayout.nrowPitch(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long arrayPitch() {
            return VkSubresourceLayout.narrayPitch(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long depthPitch() {
            return VkSubresourceLayout.ndepthPitch(this.address());
        }
    }
}

