/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSampleLocationsInfoEXT;

public class VkSubpassSampleLocationsEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SUBPASSINDEX;
    public static final int SAMPLELOCATIONSINFO;

    VkSubpassSampleLocationsEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkSubpassSampleLocationsEXT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSubpassSampleLocationsEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int subpassIndex() {
        return VkSubpassSampleLocationsEXT.nsubpassIndex(this.address());
    }

    public VkSampleLocationsInfoEXT sampleLocationsInfo() {
        return VkSubpassSampleLocationsEXT.nsampleLocationsInfo(this.address());
    }

    public VkSubpassSampleLocationsEXT sampleLocationsInfo(Consumer<VkSampleLocationsInfoEXT> consumer) {
        consumer.accept(this.sampleLocationsInfo());
        return this;
    }

    public VkSubpassSampleLocationsEXT subpassIndex(@NativeType(value="uint32_t") int value) {
        VkSubpassSampleLocationsEXT.nsubpassIndex(this.address(), value);
        return this;
    }

    public VkSubpassSampleLocationsEXT sampleLocationsInfo(VkSampleLocationsInfoEXT value) {
        VkSubpassSampleLocationsEXT.nsampleLocationsInfo(this.address(), value);
        return this;
    }

    public VkSubpassSampleLocationsEXT set(int subpassIndex, VkSampleLocationsInfoEXT sampleLocationsInfo) {
        this.subpassIndex(subpassIndex);
        this.sampleLocationsInfo(sampleLocationsInfo);
        return this;
    }

    public VkSubpassSampleLocationsEXT set(VkSubpassSampleLocationsEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSubpassSampleLocationsEXT malloc() {
        return VkSubpassSampleLocationsEXT.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSubpassSampleLocationsEXT calloc() {
        return VkSubpassSampleLocationsEXT.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSubpassSampleLocationsEXT create() {
        return new VkSubpassSampleLocationsEXT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSubpassSampleLocationsEXT create(long address) {
        return new VkSubpassSampleLocationsEXT(address, null);
    }

    @Nullable
    public static VkSubpassSampleLocationsEXT createSafe(long address) {
        return address == 0L ? null : VkSubpassSampleLocationsEXT.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkSubpassSampleLocationsEXT.create(VkSubpassSampleLocationsEXT.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSubpassSampleLocationsEXT.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkSubpassSampleLocationsEXT.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSubpassSampleLocationsEXT.create(address, capacity);
    }

    public static VkSubpassSampleLocationsEXT mallocStack() {
        return VkSubpassSampleLocationsEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkSubpassSampleLocationsEXT callocStack() {
        return VkSubpassSampleLocationsEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkSubpassSampleLocationsEXT mallocStack(MemoryStack stack) {
        return VkSubpassSampleLocationsEXT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSubpassSampleLocationsEXT callocStack(MemoryStack stack) {
        return VkSubpassSampleLocationsEXT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSubpassSampleLocationsEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSubpassSampleLocationsEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSubpassSampleLocationsEXT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSubpassSampleLocationsEXT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsubpassIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBPASSINDEX);
    }

    public static VkSampleLocationsInfoEXT nsampleLocationsInfo(long struct) {
        return VkSampleLocationsInfoEXT.create(struct + (long)SAMPLELOCATIONSINFO);
    }

    public static void nsubpassIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SUBPASSINDEX, value);
    }

    public static void nsampleLocationsInfo(long struct, VkSampleLocationsInfoEXT value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SAMPLELOCATIONSINFO, VkSampleLocationsInfoEXT.SIZEOF);
    }

    public static void validate(long struct) {
        VkSampleLocationsInfoEXT.validate(struct + (long)SAMPLELOCATIONSINFO);
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkSubpassSampleLocationsEXT.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkSubpassSampleLocationsEXT.__struct(VkSubpassSampleLocationsEXT.__member(4), VkSubpassSampleLocationsEXT.__member(VkSampleLocationsInfoEXT.SIZEOF, VkSampleLocationsInfoEXT.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SUBPASSINDEX = layout.offsetof(0);
        SAMPLELOCATIONSINFO = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkSubpassSampleLocationsEXT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSubpassSampleLocationsEXT newInstance(long address) {
            return new VkSubpassSampleLocationsEXT(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="uint32_t")
        public int subpassIndex() {
            return VkSubpassSampleLocationsEXT.nsubpassIndex(this.address());
        }

        public VkSampleLocationsInfoEXT sampleLocationsInfo() {
            return VkSubpassSampleLocationsEXT.nsampleLocationsInfo(this.address());
        }

        public Buffer sampleLocationsInfo(Consumer<VkSampleLocationsInfoEXT> consumer) {
            consumer.accept(this.sampleLocationsInfo());
            return this;
        }

        public Buffer subpassIndex(@NativeType(value="uint32_t") int value) {
            VkSubpassSampleLocationsEXT.nsubpassIndex(this.address(), value);
            return this;
        }

        public Buffer sampleLocationsInfo(VkSampleLocationsInfoEXT value) {
            VkSubpassSampleLocationsEXT.nsampleLocationsInfo(this.address(), value);
            return this;
        }
    }
}

