/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSparseMemoryBind;

public class VkSparseBufferMemoryBindInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFER;
    public static final int BINDCOUNT;
    public static final int PBINDS;

    VkSparseBufferMemoryBindInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkSparseBufferMemoryBindInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSparseBufferMemoryBindInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkSparseBufferMemoryBindInfo.nbuffer(this.address());
    }

    @NativeType(value="uint32_t")
    public int bindCount() {
        return VkSparseBufferMemoryBindInfo.nbindCount(this.address());
    }

    @NativeType(value="VkSparseMemoryBind const *")
    public VkSparseMemoryBind.Buffer pBinds() {
        return VkSparseBufferMemoryBindInfo.npBinds(this.address());
    }

    public VkSparseBufferMemoryBindInfo buffer(@NativeType(value="VkBuffer") long value) {
        VkSparseBufferMemoryBindInfo.nbuffer(this.address(), value);
        return this;
    }

    public VkSparseBufferMemoryBindInfo pBinds(@NativeType(value="VkSparseMemoryBind const *") VkSparseMemoryBind.Buffer value) {
        VkSparseBufferMemoryBindInfo.npBinds(this.address(), value);
        return this;
    }

    public VkSparseBufferMemoryBindInfo set(long buffer, VkSparseMemoryBind.Buffer pBinds) {
        this.buffer(buffer);
        this.pBinds(pBinds);
        return this;
    }

    public VkSparseBufferMemoryBindInfo set(VkSparseBufferMemoryBindInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSparseBufferMemoryBindInfo malloc() {
        return VkSparseBufferMemoryBindInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSparseBufferMemoryBindInfo calloc() {
        return VkSparseBufferMemoryBindInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSparseBufferMemoryBindInfo create() {
        return new VkSparseBufferMemoryBindInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSparseBufferMemoryBindInfo create(long address) {
        return new VkSparseBufferMemoryBindInfo(address, null);
    }

    @Nullable
    public static VkSparseBufferMemoryBindInfo createSafe(long address) {
        return address == 0L ? null : VkSparseBufferMemoryBindInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkSparseBufferMemoryBindInfo.create(VkSparseBufferMemoryBindInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSparseBufferMemoryBindInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkSparseBufferMemoryBindInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSparseBufferMemoryBindInfo.create(address, capacity);
    }

    public static VkSparseBufferMemoryBindInfo mallocStack() {
        return VkSparseBufferMemoryBindInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkSparseBufferMemoryBindInfo callocStack() {
        return VkSparseBufferMemoryBindInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkSparseBufferMemoryBindInfo mallocStack(MemoryStack stack) {
        return VkSparseBufferMemoryBindInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSparseBufferMemoryBindInfo callocStack(MemoryStack stack) {
        return VkSparseBufferMemoryBindInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSparseBufferMemoryBindInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSparseBufferMemoryBindInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSparseBufferMemoryBindInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSparseBufferMemoryBindInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BUFFER);
    }

    public static int nbindCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BINDCOUNT);
    }

    public static VkSparseMemoryBind.Buffer npBinds(long struct) {
        return VkSparseMemoryBind.create(MemoryUtil.memGetAddress(struct + (long)PBINDS), VkSparseBufferMemoryBindInfo.nbindCount(struct));
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BUFFER, value);
    }

    public static void nbindCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BINDCOUNT, value);
    }

    public static void npBinds(long struct, VkSparseMemoryBind.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PBINDS, value.address());
        VkSparseBufferMemoryBindInfo.nbindCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PBINDS));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkSparseBufferMemoryBindInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkSparseBufferMemoryBindInfo.__struct(VkSparseBufferMemoryBindInfo.__member(8), VkSparseBufferMemoryBindInfo.__member(4), VkSparseBufferMemoryBindInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFER = layout.offsetof(0);
        BINDCOUNT = layout.offsetof(1);
        PBINDS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSparseBufferMemoryBindInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSparseBufferMemoryBindInfo newInstance(long address) {
            return new VkSparseBufferMemoryBindInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkSparseBufferMemoryBindInfo.nbuffer(this.address());
        }

        @NativeType(value="uint32_t")
        public int bindCount() {
            return VkSparseBufferMemoryBindInfo.nbindCount(this.address());
        }

        @NativeType(value="VkSparseMemoryBind const *")
        public VkSparseMemoryBind.Buffer pBinds() {
            return VkSparseBufferMemoryBindInfo.npBinds(this.address());
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkSparseBufferMemoryBindInfo.nbuffer(this.address(), value);
            return this;
        }

        public Buffer pBinds(@NativeType(value="VkSparseMemoryBind const *") VkSparseMemoryBind.Buffer value) {
            VkSparseBufferMemoryBindInfo.npBinds(this.address(), value);
            return this;
        }
    }
}

