/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;
import org.lwjgl.vulkan.VkSampleLocationEXT;

public class VkSampleLocationsInfoEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SAMPLELOCATIONSPERPIXEL;
    public static final int SAMPLELOCATIONGRIDSIZE;
    public static final int SAMPLELOCATIONSCOUNT;
    public static final int PSAMPLELOCATIONS;

    VkSampleLocationsInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkSampleLocationsInfoEXT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSampleLocationsInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSampleLocationsInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSampleLocationsInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkSampleCountFlagBits")
    public int sampleLocationsPerPixel() {
        return VkSampleLocationsInfoEXT.nsampleLocationsPerPixel(this.address());
    }

    public VkExtent2D sampleLocationGridSize() {
        return VkSampleLocationsInfoEXT.nsampleLocationGridSize(this.address());
    }

    public VkSampleLocationsInfoEXT sampleLocationGridSize(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.sampleLocationGridSize());
        return this;
    }

    @NativeType(value="uint32_t")
    public int sampleLocationsCount() {
        return VkSampleLocationsInfoEXT.nsampleLocationsCount(this.address());
    }

    @NativeType(value="VkSampleLocationEXT const *")
    public VkSampleLocationEXT.Buffer pSampleLocations() {
        return VkSampleLocationsInfoEXT.npSampleLocations(this.address());
    }

    public VkSampleLocationsInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkSampleLocationsInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkSampleLocationsInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkSampleLocationsInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkSampleLocationsInfoEXT sampleLocationsPerPixel(@NativeType(value="VkSampleCountFlagBits") int value) {
        VkSampleLocationsInfoEXT.nsampleLocationsPerPixel(this.address(), value);
        return this;
    }

    public VkSampleLocationsInfoEXT sampleLocationGridSize(VkExtent2D value) {
        VkSampleLocationsInfoEXT.nsampleLocationGridSize(this.address(), value);
        return this;
    }

    public VkSampleLocationsInfoEXT pSampleLocations(@NativeType(value="VkSampleLocationEXT const *") VkSampleLocationEXT.Buffer value) {
        VkSampleLocationsInfoEXT.npSampleLocations(this.address(), value);
        return this;
    }

    public VkSampleLocationsInfoEXT set(int sType, long pNext, int sampleLocationsPerPixel, VkExtent2D sampleLocationGridSize, VkSampleLocationEXT.Buffer pSampleLocations) {
        this.sType(sType);
        this.pNext(pNext);
        this.sampleLocationsPerPixel(sampleLocationsPerPixel);
        this.sampleLocationGridSize(sampleLocationGridSize);
        this.pSampleLocations(pSampleLocations);
        return this;
    }

    public VkSampleLocationsInfoEXT set(VkSampleLocationsInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSampleLocationsInfoEXT malloc() {
        return VkSampleLocationsInfoEXT.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSampleLocationsInfoEXT calloc() {
        return VkSampleLocationsInfoEXT.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSampleLocationsInfoEXT create() {
        return new VkSampleLocationsInfoEXT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSampleLocationsInfoEXT create(long address) {
        return new VkSampleLocationsInfoEXT(address, null);
    }

    @Nullable
    public static VkSampleLocationsInfoEXT createSafe(long address) {
        return address == 0L ? null : VkSampleLocationsInfoEXT.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkSampleLocationsInfoEXT.create(VkSampleLocationsInfoEXT.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSampleLocationsInfoEXT.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkSampleLocationsInfoEXT.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSampleLocationsInfoEXT.create(address, capacity);
    }

    public static VkSampleLocationsInfoEXT mallocStack() {
        return VkSampleLocationsInfoEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkSampleLocationsInfoEXT callocStack() {
        return VkSampleLocationsInfoEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkSampleLocationsInfoEXT mallocStack(MemoryStack stack) {
        return VkSampleLocationsInfoEXT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSampleLocationsInfoEXT callocStack(MemoryStack stack) {
        return VkSampleLocationsInfoEXT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSampleLocationsInfoEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSampleLocationsInfoEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSampleLocationsInfoEXT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSampleLocationsInfoEXT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nsampleLocationsPerPixel(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLELOCATIONSPERPIXEL);
    }

    public static VkExtent2D nsampleLocationGridSize(long struct) {
        return VkExtent2D.create(struct + (long)SAMPLELOCATIONGRIDSIZE);
    }

    public static int nsampleLocationsCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLELOCATIONSCOUNT);
    }

    public static VkSampleLocationEXT.Buffer npSampleLocations(long struct) {
        return VkSampleLocationEXT.create(MemoryUtil.memGetAddress(struct + (long)PSAMPLELOCATIONS), VkSampleLocationsInfoEXT.nsampleLocationsCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nsampleLocationsPerPixel(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SAMPLELOCATIONSPERPIXEL, value);
    }

    public static void nsampleLocationGridSize(long struct, VkExtent2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SAMPLELOCATIONGRIDSIZE, VkExtent2D.SIZEOF);
    }

    public static void nsampleLocationsCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SAMPLELOCATIONSCOUNT, value);
    }

    public static void npSampleLocations(long struct, VkSampleLocationEXT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSAMPLELOCATIONS, value.address());
        VkSampleLocationsInfoEXT.nsampleLocationsCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PSAMPLELOCATIONS));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkSampleLocationsInfoEXT.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkSampleLocationsInfoEXT.__struct(VkSampleLocationsInfoEXT.__member(4), VkSampleLocationsInfoEXT.__member(POINTER_SIZE), VkSampleLocationsInfoEXT.__member(4), VkSampleLocationsInfoEXT.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkSampleLocationsInfoEXT.__member(4), VkSampleLocationsInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SAMPLELOCATIONSPERPIXEL = layout.offsetof(2);
        SAMPLELOCATIONGRIDSIZE = layout.offsetof(3);
        SAMPLELOCATIONSCOUNT = layout.offsetof(4);
        PSAMPLELOCATIONS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkSampleLocationsInfoEXT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSampleLocationsInfoEXT newInstance(long address) {
            return new VkSampleLocationsInfoEXT(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSampleLocationsInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSampleLocationsInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkSampleCountFlagBits")
        public int sampleLocationsPerPixel() {
            return VkSampleLocationsInfoEXT.nsampleLocationsPerPixel(this.address());
        }

        public VkExtent2D sampleLocationGridSize() {
            return VkSampleLocationsInfoEXT.nsampleLocationGridSize(this.address());
        }

        public Buffer sampleLocationGridSize(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.sampleLocationGridSize());
            return this;
        }

        @NativeType(value="uint32_t")
        public int sampleLocationsCount() {
            return VkSampleLocationsInfoEXT.nsampleLocationsCount(this.address());
        }

        @NativeType(value="VkSampleLocationEXT const *")
        public VkSampleLocationEXT.Buffer pSampleLocations() {
            return VkSampleLocationsInfoEXT.npSampleLocations(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSampleLocationsInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSampleLocationsInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer sampleLocationsPerPixel(@NativeType(value="VkSampleCountFlagBits") int value) {
            VkSampleLocationsInfoEXT.nsampleLocationsPerPixel(this.address(), value);
            return this;
        }

        public Buffer sampleLocationGridSize(VkExtent2D value) {
            VkSampleLocationsInfoEXT.nsampleLocationGridSize(this.address(), value);
            return this;
        }

        public Buffer pSampleLocations(@NativeType(value="VkSampleLocationEXT const *") VkSampleLocationEXT.Buffer value) {
            VkSampleLocationsInfoEXT.npSampleLocations(this.address(), value);
            return this;
        }
    }
}

