/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSampleLocationEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    VkSampleLocationEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkSampleLocationEXT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSampleLocationEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return VkSampleLocationEXT.nx(this.address());
    }

    public float y() {
        return VkSampleLocationEXT.ny(this.address());
    }

    public VkSampleLocationEXT x(float value) {
        VkSampleLocationEXT.nx(this.address(), value);
        return this;
    }

    public VkSampleLocationEXT y(float value) {
        VkSampleLocationEXT.ny(this.address(), value);
        return this;
    }

    public VkSampleLocationEXT set(float x, float y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public VkSampleLocationEXT set(VkSampleLocationEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSampleLocationEXT malloc() {
        return VkSampleLocationEXT.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSampleLocationEXT calloc() {
        return VkSampleLocationEXT.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSampleLocationEXT create() {
        return new VkSampleLocationEXT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSampleLocationEXT create(long address) {
        return new VkSampleLocationEXT(address, null);
    }

    @Nullable
    public static VkSampleLocationEXT createSafe(long address) {
        return address == 0L ? null : VkSampleLocationEXT.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkSampleLocationEXT.create(VkSampleLocationEXT.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSampleLocationEXT.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkSampleLocationEXT.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSampleLocationEXT.create(address, capacity);
    }

    public static VkSampleLocationEXT mallocStack() {
        return VkSampleLocationEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkSampleLocationEXT callocStack() {
        return VkSampleLocationEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkSampleLocationEXT mallocStack(MemoryStack stack) {
        return VkSampleLocationEXT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSampleLocationEXT callocStack(MemoryStack stack) {
        return VkSampleLocationEXT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSampleLocationEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSampleLocationEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSampleLocationEXT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSampleLocationEXT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = VkSampleLocationEXT.__struct(VkSampleLocationEXT.__member(4), VkSampleLocationEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkSampleLocationEXT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSampleLocationEXT newInstance(long address) {
            return new VkSampleLocationEXT(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public float x() {
            return VkSampleLocationEXT.nx(this.address());
        }

        public float y() {
            return VkSampleLocationEXT.ny(this.address());
        }

        public Buffer x(float value) {
            VkSampleLocationEXT.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            VkSampleLocationEXT.ny(this.address(), value);
            return this;
        }
    }
}

