/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkRenderPassMultiviewCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SUBPASSCOUNT;
    public static final int PVIEWMASKS;
    public static final int DEPENDENCYCOUNT;
    public static final int PVIEWOFFSETS;
    public static final int CORRELATIONMASKCOUNT;
    public static final int PCORRELATIONMASKS;

    VkRenderPassMultiviewCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkRenderPassMultiviewCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkRenderPassMultiviewCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkRenderPassMultiviewCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkRenderPassMultiviewCreateInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int subpassCount() {
        return VkRenderPassMultiviewCreateInfo.nsubpassCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer pViewMasks() {
        return VkRenderPassMultiviewCreateInfo.npViewMasks(this.address());
    }

    @NativeType(value="uint32_t")
    public int dependencyCount() {
        return VkRenderPassMultiviewCreateInfo.ndependencyCount(this.address());
    }

    @Nullable
    @NativeType(value="int32_t const *")
    public IntBuffer pViewOffsets() {
        return VkRenderPassMultiviewCreateInfo.npViewOffsets(this.address());
    }

    @NativeType(value="uint32_t")
    public int correlationMaskCount() {
        return VkRenderPassMultiviewCreateInfo.ncorrelationMaskCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer pCorrelationMasks() {
        return VkRenderPassMultiviewCreateInfo.npCorrelationMasks(this.address());
    }

    public VkRenderPassMultiviewCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkRenderPassMultiviewCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkRenderPassMultiviewCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkRenderPassMultiviewCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkRenderPassMultiviewCreateInfo pViewMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkRenderPassMultiviewCreateInfo.npViewMasks(this.address(), value);
        return this;
    }

    public VkRenderPassMultiviewCreateInfo pViewOffsets(@Nullable @NativeType(value="int32_t const *") IntBuffer value) {
        VkRenderPassMultiviewCreateInfo.npViewOffsets(this.address(), value);
        return this;
    }

    public VkRenderPassMultiviewCreateInfo pCorrelationMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkRenderPassMultiviewCreateInfo.npCorrelationMasks(this.address(), value);
        return this;
    }

    public VkRenderPassMultiviewCreateInfo set(int sType, long pNext, @Nullable IntBuffer pViewMasks, @Nullable IntBuffer pViewOffsets, @Nullable IntBuffer pCorrelationMasks) {
        this.sType(sType);
        this.pNext(pNext);
        this.pViewMasks(pViewMasks);
        this.pViewOffsets(pViewOffsets);
        this.pCorrelationMasks(pCorrelationMasks);
        return this;
    }

    public VkRenderPassMultiviewCreateInfo set(VkRenderPassMultiviewCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkRenderPassMultiviewCreateInfo malloc() {
        return VkRenderPassMultiviewCreateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkRenderPassMultiviewCreateInfo calloc() {
        return VkRenderPassMultiviewCreateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkRenderPassMultiviewCreateInfo create() {
        return new VkRenderPassMultiviewCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkRenderPassMultiviewCreateInfo create(long address) {
        return new VkRenderPassMultiviewCreateInfo(address, null);
    }

    @Nullable
    public static VkRenderPassMultiviewCreateInfo createSafe(long address) {
        return address == 0L ? null : VkRenderPassMultiviewCreateInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkRenderPassMultiviewCreateInfo.create(VkRenderPassMultiviewCreateInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkRenderPassMultiviewCreateInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkRenderPassMultiviewCreateInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkRenderPassMultiviewCreateInfo.create(address, capacity);
    }

    public static VkRenderPassMultiviewCreateInfo mallocStack() {
        return VkRenderPassMultiviewCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkRenderPassMultiviewCreateInfo callocStack() {
        return VkRenderPassMultiviewCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkRenderPassMultiviewCreateInfo mallocStack(MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkRenderPassMultiviewCreateInfo callocStack(MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkRenderPassMultiviewCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkRenderPassMultiviewCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nsubpassCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBPASSCOUNT);
    }

    @Nullable
    public static IntBuffer npViewMasks(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PVIEWMASKS), VkRenderPassMultiviewCreateInfo.nsubpassCount(struct));
    }

    public static int ndependencyCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPENDENCYCOUNT);
    }

    @Nullable
    public static IntBuffer npViewOffsets(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PVIEWOFFSETS), VkRenderPassMultiviewCreateInfo.ndependencyCount(struct));
    }

    public static int ncorrelationMaskCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CORRELATIONMASKCOUNT);
    }

    @Nullable
    public static IntBuffer npCorrelationMasks(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PCORRELATIONMASKS), VkRenderPassMultiviewCreateInfo.ncorrelationMaskCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nsubpassCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SUBPASSCOUNT, value);
    }

    public static void npViewMasks(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PVIEWMASKS, MemoryUtil.memAddressSafe(value));
        VkRenderPassMultiviewCreateInfo.nsubpassCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ndependencyCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEPENDENCYCOUNT, value);
    }

    public static void npViewOffsets(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PVIEWOFFSETS, MemoryUtil.memAddressSafe(value));
        VkRenderPassMultiviewCreateInfo.ndependencyCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ncorrelationMaskCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CORRELATIONMASKCOUNT, value);
    }

    public static void npCorrelationMasks(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCORRELATIONMASKS, MemoryUtil.memAddressSafe(value));
        VkRenderPassMultiviewCreateInfo.ncorrelationMaskCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkRenderPassMultiviewCreateInfo.nsubpassCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PVIEWMASKS));
        }
        if (VkRenderPassMultiviewCreateInfo.ndependencyCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PVIEWOFFSETS));
        }
        if (VkRenderPassMultiviewCreateInfo.ncorrelationMaskCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PCORRELATIONMASKS));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkRenderPassMultiviewCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkRenderPassMultiviewCreateInfo.__struct(VkRenderPassMultiviewCreateInfo.__member(4), VkRenderPassMultiviewCreateInfo.__member(POINTER_SIZE), VkRenderPassMultiviewCreateInfo.__member(4), VkRenderPassMultiviewCreateInfo.__member(POINTER_SIZE), VkRenderPassMultiviewCreateInfo.__member(4), VkRenderPassMultiviewCreateInfo.__member(POINTER_SIZE), VkRenderPassMultiviewCreateInfo.__member(4), VkRenderPassMultiviewCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SUBPASSCOUNT = layout.offsetof(2);
        PVIEWMASKS = layout.offsetof(3);
        DEPENDENCYCOUNT = layout.offsetof(4);
        PVIEWOFFSETS = layout.offsetof(5);
        CORRELATIONMASKCOUNT = layout.offsetof(6);
        PCORRELATIONMASKS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkRenderPassMultiviewCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkRenderPassMultiviewCreateInfo newInstance(long address) {
            return new VkRenderPassMultiviewCreateInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkRenderPassMultiviewCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkRenderPassMultiviewCreateInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int subpassCount() {
            return VkRenderPassMultiviewCreateInfo.nsubpassCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer pViewMasks() {
            return VkRenderPassMultiviewCreateInfo.npViewMasks(this.address());
        }

        @NativeType(value="uint32_t")
        public int dependencyCount() {
            return VkRenderPassMultiviewCreateInfo.ndependencyCount(this.address());
        }

        @Nullable
        @NativeType(value="int32_t const *")
        public IntBuffer pViewOffsets() {
            return VkRenderPassMultiviewCreateInfo.npViewOffsets(this.address());
        }

        @NativeType(value="uint32_t")
        public int correlationMaskCount() {
            return VkRenderPassMultiviewCreateInfo.ncorrelationMaskCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer pCorrelationMasks() {
            return VkRenderPassMultiviewCreateInfo.npCorrelationMasks(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderPassMultiviewCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderPassMultiviewCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pViewMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkRenderPassMultiviewCreateInfo.npViewMasks(this.address(), value);
            return this;
        }

        public Buffer pViewOffsets(@Nullable @NativeType(value="int32_t const *") IntBuffer value) {
            VkRenderPassMultiviewCreateInfo.npViewOffsets(this.address(), value);
            return this;
        }

        public Buffer pCorrelationMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkRenderPassMultiviewCreateInfo.npCorrelationMasks(this.address(), value);
            return this;
        }
    }
}

