/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkInputAttachmentAspectReference;

public class VkRenderPassInputAttachmentAspectCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int ASPECTREFERENCECOUNT;
    public static final int PASPECTREFERENCES;

    VkRenderPassInputAttachmentAspectCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkRenderPassInputAttachmentAspectCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkRenderPassInputAttachmentAspectCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkRenderPassInputAttachmentAspectCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkRenderPassInputAttachmentAspectCreateInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int aspectReferenceCount() {
        return VkRenderPassInputAttachmentAspectCreateInfo.naspectReferenceCount(this.address());
    }

    @NativeType(value="VkInputAttachmentAspectReference const *")
    public VkInputAttachmentAspectReference.Buffer pAspectReferences() {
        return VkRenderPassInputAttachmentAspectCreateInfo.npAspectReferences(this.address());
    }

    public VkRenderPassInputAttachmentAspectCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkRenderPassInputAttachmentAspectCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkRenderPassInputAttachmentAspectCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkRenderPassInputAttachmentAspectCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkRenderPassInputAttachmentAspectCreateInfo pAspectReferences(@NativeType(value="VkInputAttachmentAspectReference const *") VkInputAttachmentAspectReference.Buffer value) {
        VkRenderPassInputAttachmentAspectCreateInfo.npAspectReferences(this.address(), value);
        return this;
    }

    public VkRenderPassInputAttachmentAspectCreateInfo set(int sType, long pNext, VkInputAttachmentAspectReference.Buffer pAspectReferences) {
        this.sType(sType);
        this.pNext(pNext);
        this.pAspectReferences(pAspectReferences);
        return this;
    }

    public VkRenderPassInputAttachmentAspectCreateInfo set(VkRenderPassInputAttachmentAspectCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkRenderPassInputAttachmentAspectCreateInfo malloc() {
        return VkRenderPassInputAttachmentAspectCreateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkRenderPassInputAttachmentAspectCreateInfo calloc() {
        return VkRenderPassInputAttachmentAspectCreateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkRenderPassInputAttachmentAspectCreateInfo create() {
        return new VkRenderPassInputAttachmentAspectCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkRenderPassInputAttachmentAspectCreateInfo create(long address) {
        return new VkRenderPassInputAttachmentAspectCreateInfo(address, null);
    }

    @Nullable
    public static VkRenderPassInputAttachmentAspectCreateInfo createSafe(long address) {
        return address == 0L ? null : VkRenderPassInputAttachmentAspectCreateInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkRenderPassInputAttachmentAspectCreateInfo.create(VkRenderPassInputAttachmentAspectCreateInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkRenderPassInputAttachmentAspectCreateInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkRenderPassInputAttachmentAspectCreateInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkRenderPassInputAttachmentAspectCreateInfo.create(address, capacity);
    }

    public static VkRenderPassInputAttachmentAspectCreateInfo mallocStack() {
        return VkRenderPassInputAttachmentAspectCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkRenderPassInputAttachmentAspectCreateInfo callocStack() {
        return VkRenderPassInputAttachmentAspectCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkRenderPassInputAttachmentAspectCreateInfo mallocStack(MemoryStack stack) {
        return VkRenderPassInputAttachmentAspectCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkRenderPassInputAttachmentAspectCreateInfo callocStack(MemoryStack stack) {
        return VkRenderPassInputAttachmentAspectCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkRenderPassInputAttachmentAspectCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkRenderPassInputAttachmentAspectCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkRenderPassInputAttachmentAspectCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkRenderPassInputAttachmentAspectCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int naspectReferenceCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ASPECTREFERENCECOUNT);
    }

    public static VkInputAttachmentAspectReference.Buffer npAspectReferences(long struct) {
        return VkInputAttachmentAspectReference.create(MemoryUtil.memGetAddress(struct + (long)PASPECTREFERENCES), VkRenderPassInputAttachmentAspectCreateInfo.naspectReferenceCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void naspectReferenceCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ASPECTREFERENCECOUNT, value);
    }

    public static void npAspectReferences(long struct, VkInputAttachmentAspectReference.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PASPECTREFERENCES, value.address());
        VkRenderPassInputAttachmentAspectCreateInfo.naspectReferenceCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PASPECTREFERENCES));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkRenderPassInputAttachmentAspectCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkRenderPassInputAttachmentAspectCreateInfo.__struct(VkRenderPassInputAttachmentAspectCreateInfo.__member(4), VkRenderPassInputAttachmentAspectCreateInfo.__member(POINTER_SIZE), VkRenderPassInputAttachmentAspectCreateInfo.__member(4), VkRenderPassInputAttachmentAspectCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        ASPECTREFERENCECOUNT = layout.offsetof(2);
        PASPECTREFERENCES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkRenderPassInputAttachmentAspectCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkRenderPassInputAttachmentAspectCreateInfo newInstance(long address) {
            return new VkRenderPassInputAttachmentAspectCreateInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkRenderPassInputAttachmentAspectCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkRenderPassInputAttachmentAspectCreateInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int aspectReferenceCount() {
            return VkRenderPassInputAttachmentAspectCreateInfo.naspectReferenceCount(this.address());
        }

        @NativeType(value="VkInputAttachmentAspectReference const *")
        public VkInputAttachmentAspectReference.Buffer pAspectReferences() {
            return VkRenderPassInputAttachmentAspectCreateInfo.npAspectReferences(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderPassInputAttachmentAspectCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderPassInputAttachmentAspectCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pAspectReferences(@NativeType(value="VkInputAttachmentAspectReference const *") VkInputAttachmentAspectReference.Buffer value) {
            VkRenderPassInputAttachmentAspectCreateInfo.npAspectReferences(this.address(), value);
            return this;
        }
    }
}

