/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;

public class VkQueueFamilyProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int QUEUEFLAGS;
    public static final int QUEUECOUNT;
    public static final int TIMESTAMPVALIDBITS;
    public static final int MINIMAGETRANSFERGRANULARITY;

    VkQueueFamilyProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkQueueFamilyProperties(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkQueueFamilyProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkQueueFlags")
    public int queueFlags() {
        return VkQueueFamilyProperties.nqueueFlags(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueCount() {
        return VkQueueFamilyProperties.nqueueCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int timestampValidBits() {
        return VkQueueFamilyProperties.ntimestampValidBits(this.address());
    }

    public VkExtent3D minImageTransferGranularity() {
        return VkQueueFamilyProperties.nminImageTransferGranularity(this.address());
    }

    public VkQueueFamilyProperties minImageTransferGranularity(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.minImageTransferGranularity());
        return this;
    }

    public static VkQueueFamilyProperties malloc() {
        return VkQueueFamilyProperties.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkQueueFamilyProperties calloc() {
        return VkQueueFamilyProperties.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkQueueFamilyProperties create() {
        return new VkQueueFamilyProperties(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkQueueFamilyProperties create(long address) {
        return new VkQueueFamilyProperties(address, null);
    }

    @Nullable
    public static VkQueueFamilyProperties createSafe(long address) {
        return address == 0L ? null : VkQueueFamilyProperties.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkQueueFamilyProperties.create(VkQueueFamilyProperties.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkQueueFamilyProperties.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkQueueFamilyProperties.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkQueueFamilyProperties.create(address, capacity);
    }

    public static VkQueueFamilyProperties mallocStack() {
        return VkQueueFamilyProperties.mallocStack(MemoryStack.stackGet());
    }

    public static VkQueueFamilyProperties callocStack() {
        return VkQueueFamilyProperties.callocStack(MemoryStack.stackGet());
    }

    public static VkQueueFamilyProperties mallocStack(MemoryStack stack) {
        return VkQueueFamilyProperties.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkQueueFamilyProperties callocStack(MemoryStack stack) {
        return VkQueueFamilyProperties.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkQueueFamilyProperties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkQueueFamilyProperties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkQueueFamilyProperties.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkQueueFamilyProperties.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nqueueFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)QUEUEFLAGS);
    }

    public static int nqueueCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)QUEUECOUNT);
    }

    public static int ntimestampValidBits(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TIMESTAMPVALIDBITS);
    }

    public static VkExtent3D nminImageTransferGranularity(long struct) {
        return VkExtent3D.create(struct + (long)MINIMAGETRANSFERGRANULARITY);
    }

    static {
        Struct.Layout layout = VkQueueFamilyProperties.__struct(VkQueueFamilyProperties.__member(4), VkQueueFamilyProperties.__member(4), VkQueueFamilyProperties.__member(4), VkQueueFamilyProperties.__member(VkExtent3D.SIZEOF, VkExtent3D.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        QUEUEFLAGS = layout.offsetof(0);
        QUEUECOUNT = layout.offsetof(1);
        TIMESTAMPVALIDBITS = layout.offsetof(2);
        MINIMAGETRANSFERGRANULARITY = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkQueueFamilyProperties, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkQueueFamilyProperties newInstance(long address) {
            return new VkQueueFamilyProperties(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkQueueFlags")
        public int queueFlags() {
            return VkQueueFamilyProperties.nqueueFlags(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueCount() {
            return VkQueueFamilyProperties.nqueueCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int timestampValidBits() {
            return VkQueueFamilyProperties.ntimestampValidBits(this.address());
        }

        public VkExtent3D minImageTransferGranularity() {
            return VkQueueFamilyProperties.nminImageTransferGranularity(this.address());
        }

        public Buffer minImageTransferGranularity(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.minImageTransferGranularity());
            return this;
        }
    }
}

