/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPushConstantRange
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STAGEFLAGS;
    public static final int OFFSET;
    public static final int SIZE;

    VkPushConstantRange(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkPushConstantRange(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPushConstantRange.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkShaderStageFlags")
    public int stageFlags() {
        return VkPushConstantRange.nstageFlags(this.address());
    }

    @NativeType(value="uint32_t")
    public int offset() {
        return VkPushConstantRange.noffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int size() {
        return VkPushConstantRange.nsize(this.address());
    }

    public VkPushConstantRange stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
        VkPushConstantRange.nstageFlags(this.address(), value);
        return this;
    }

    public VkPushConstantRange offset(@NativeType(value="uint32_t") int value) {
        VkPushConstantRange.noffset(this.address(), value);
        return this;
    }

    public VkPushConstantRange size(@NativeType(value="uint32_t") int value) {
        VkPushConstantRange.nsize(this.address(), value);
        return this;
    }

    public VkPushConstantRange set(int stageFlags, int offset, int size) {
        this.stageFlags(stageFlags);
        this.offset(offset);
        this.size(size);
        return this;
    }

    public VkPushConstantRange set(VkPushConstantRange src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPushConstantRange malloc() {
        return VkPushConstantRange.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPushConstantRange calloc() {
        return VkPushConstantRange.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPushConstantRange create() {
        return new VkPushConstantRange(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPushConstantRange create(long address) {
        return new VkPushConstantRange(address, null);
    }

    @Nullable
    public static VkPushConstantRange createSafe(long address) {
        return address == 0L ? null : VkPushConstantRange.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkPushConstantRange.create(VkPushConstantRange.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPushConstantRange.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkPushConstantRange.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPushConstantRange.create(address, capacity);
    }

    public static VkPushConstantRange mallocStack() {
        return VkPushConstantRange.mallocStack(MemoryStack.stackGet());
    }

    public static VkPushConstantRange callocStack() {
        return VkPushConstantRange.callocStack(MemoryStack.stackGet());
    }

    public static VkPushConstantRange mallocStack(MemoryStack stack) {
        return VkPushConstantRange.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPushConstantRange callocStack(MemoryStack stack) {
        return VkPushConstantRange.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPushConstantRange.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPushConstantRange.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPushConstantRange.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPushConstantRange.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nstageFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STAGEFLAGS);
    }

    public static int noffset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OFFSET);
    }

    public static int nsize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SIZE);
    }

    public static void nstageFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STAGEFLAGS, value);
    }

    public static void noffset(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OFFSET, value);
    }

    public static void nsize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = VkPushConstantRange.__struct(VkPushConstantRange.__member(4), VkPushConstantRange.__member(4), VkPushConstantRange.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STAGEFLAGS = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
        SIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkPushConstantRange, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPushConstantRange newInstance(long address) {
            return new VkPushConstantRange(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkShaderStageFlags")
        public int stageFlags() {
            return VkPushConstantRange.nstageFlags(this.address());
        }

        @NativeType(value="uint32_t")
        public int offset() {
            return VkPushConstantRange.noffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int size() {
            return VkPushConstantRange.nsize(this.address());
        }

        public Buffer stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
            VkPushConstantRange.nstageFlags(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="uint32_t") int value) {
            VkPushConstantRange.noffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="uint32_t") int value) {
            VkPushConstantRange.nsize(this.address(), value);
            return this;
        }
    }
}

