/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPipelineColorBlendAttachmentState;

public class VkPipelineColorBlendStateCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int LOGICOPENABLE;
    public static final int LOGICOP;
    public static final int ATTACHMENTCOUNT;
    public static final int PATTACHMENTS;
    public static final int BLENDCONSTANTS;

    VkPipelineColorBlendStateCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkPipelineColorBlendStateCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPipelineColorBlendStateCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineColorBlendStateCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineColorBlendStateCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkPipelineColorBlendStateCreateFlags")
    public int flags() {
        return VkPipelineColorBlendStateCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean logicOpEnable() {
        return VkPipelineColorBlendStateCreateInfo.nlogicOpEnable(this.address()) != 0;
    }

    @NativeType(value="VkLogicOp")
    public int logicOp() {
        return VkPipelineColorBlendStateCreateInfo.nlogicOp(this.address());
    }

    @NativeType(value="uint32_t")
    public int attachmentCount() {
        return VkPipelineColorBlendStateCreateInfo.nattachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="VkPipelineColorBlendAttachmentState const *")
    public VkPipelineColorBlendAttachmentState.Buffer pAttachments() {
        return VkPipelineColorBlendStateCreateInfo.npAttachments(this.address());
    }

    @NativeType(value="float[4]")
    public FloatBuffer blendConstants() {
        return VkPipelineColorBlendStateCreateInfo.nblendConstants(this.address());
    }

    public float blendConstants(int index) {
        return VkPipelineColorBlendStateCreateInfo.nblendConstants(this.address(), index);
    }

    public VkPipelineColorBlendStateCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineColorBlendStateCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPipelineColorBlendStateCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkPipelineColorBlendStateCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPipelineColorBlendStateCreateInfo flags(@NativeType(value="VkPipelineColorBlendStateCreateFlags") int value) {
        VkPipelineColorBlendStateCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkPipelineColorBlendStateCreateInfo logicOpEnable(@NativeType(value="VkBool32") boolean value) {
        VkPipelineColorBlendStateCreateInfo.nlogicOpEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPipelineColorBlendStateCreateInfo logicOp(@NativeType(value="VkLogicOp") int value) {
        VkPipelineColorBlendStateCreateInfo.nlogicOp(this.address(), value);
        return this;
    }

    public VkPipelineColorBlendStateCreateInfo pAttachments(@Nullable @NativeType(value="VkPipelineColorBlendAttachmentState const *") VkPipelineColorBlendAttachmentState.Buffer value) {
        VkPipelineColorBlendStateCreateInfo.npAttachments(this.address(), value);
        return this;
    }

    public VkPipelineColorBlendStateCreateInfo blendConstants(@NativeType(value="float[4]") FloatBuffer value) {
        VkPipelineColorBlendStateCreateInfo.nblendConstants(this.address(), value);
        return this;
    }

    public VkPipelineColorBlendStateCreateInfo blendConstants(int index, float value) {
        VkPipelineColorBlendStateCreateInfo.nblendConstants(this.address(), index, value);
        return this;
    }

    public VkPipelineColorBlendStateCreateInfo set(int sType, long pNext, int flags, boolean logicOpEnable, int logicOp, @Nullable VkPipelineColorBlendAttachmentState.Buffer pAttachments, FloatBuffer blendConstants) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.logicOpEnable(logicOpEnable);
        this.logicOp(logicOp);
        this.pAttachments(pAttachments);
        this.blendConstants(blendConstants);
        return this;
    }

    public VkPipelineColorBlendStateCreateInfo set(VkPipelineColorBlendStateCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineColorBlendStateCreateInfo malloc() {
        return VkPipelineColorBlendStateCreateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPipelineColorBlendStateCreateInfo calloc() {
        return VkPipelineColorBlendStateCreateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPipelineColorBlendStateCreateInfo create() {
        return new VkPipelineColorBlendStateCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPipelineColorBlendStateCreateInfo create(long address) {
        return new VkPipelineColorBlendStateCreateInfo(address, null);
    }

    @Nullable
    public static VkPipelineColorBlendStateCreateInfo createSafe(long address) {
        return address == 0L ? null : VkPipelineColorBlendStateCreateInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkPipelineColorBlendStateCreateInfo.create(VkPipelineColorBlendStateCreateInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPipelineColorBlendStateCreateInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkPipelineColorBlendStateCreateInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPipelineColorBlendStateCreateInfo.create(address, capacity);
    }

    public static VkPipelineColorBlendStateCreateInfo mallocStack() {
        return VkPipelineColorBlendStateCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkPipelineColorBlendStateCreateInfo callocStack() {
        return VkPipelineColorBlendStateCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkPipelineColorBlendStateCreateInfo mallocStack(MemoryStack stack) {
        return VkPipelineColorBlendStateCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineColorBlendStateCreateInfo callocStack(MemoryStack stack) {
        return VkPipelineColorBlendStateCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPipelineColorBlendStateCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPipelineColorBlendStateCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineColorBlendStateCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineColorBlendStateCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nlogicOpEnable(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LOGICOPENABLE);
    }

    public static int nlogicOp(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LOGICOP);
    }

    public static int nattachmentCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ATTACHMENTCOUNT);
    }

    @Nullable
    public static VkPipelineColorBlendAttachmentState.Buffer npAttachments(long struct) {
        return VkPipelineColorBlendAttachmentState.createSafe(MemoryUtil.memGetAddress(struct + (long)PATTACHMENTS), VkPipelineColorBlendStateCreateInfo.nattachmentCount(struct));
    }

    public static FloatBuffer nblendConstants(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)BLENDCONSTANTS, 4);
    }

    public static float nblendConstants(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)BLENDCONSTANTS + Checks.check(index, 4) * 4L);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nlogicOpEnable(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LOGICOPENABLE, value);
    }

    public static void nlogicOp(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LOGICOP, value);
    }

    public static void nattachmentCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ATTACHMENTCOUNT, value);
    }

    public static void npAttachments(long struct, @Nullable VkPipelineColorBlendAttachmentState.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PATTACHMENTS, MemoryUtil.memAddressSafe(value));
        VkPipelineColorBlendStateCreateInfo.nattachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nblendConstants(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)BLENDCONSTANTS, value.remaining() * 4);
    }

    public static void nblendConstants(long struct, int index, float value) {
        MemoryUtil.memPutFloat(struct + (long)BLENDCONSTANTS + Checks.check(index, 4) * 4L, value);
    }

    public static void validate(long struct) {
        if (VkPipelineColorBlendStateCreateInfo.nattachmentCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PATTACHMENTS));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkPipelineColorBlendStateCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkPipelineColorBlendStateCreateInfo.__struct(VkPipelineColorBlendStateCreateInfo.__member(4), VkPipelineColorBlendStateCreateInfo.__member(POINTER_SIZE), VkPipelineColorBlendStateCreateInfo.__member(4), VkPipelineColorBlendStateCreateInfo.__member(4), VkPipelineColorBlendStateCreateInfo.__member(4), VkPipelineColorBlendStateCreateInfo.__member(4), VkPipelineColorBlendStateCreateInfo.__member(POINTER_SIZE), VkPipelineColorBlendStateCreateInfo.__array(4, 4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        LOGICOPENABLE = layout.offsetof(3);
        LOGICOP = layout.offsetof(4);
        ATTACHMENTCOUNT = layout.offsetof(5);
        PATTACHMENTS = layout.offsetof(6);
        BLENDCONSTANTS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineColorBlendStateCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPipelineColorBlendStateCreateInfo newInstance(long address) {
            return new VkPipelineColorBlendStateCreateInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineColorBlendStateCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineColorBlendStateCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkPipelineColorBlendStateCreateFlags")
        public int flags() {
            return VkPipelineColorBlendStateCreateInfo.nflags(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean logicOpEnable() {
            return VkPipelineColorBlendStateCreateInfo.nlogicOpEnable(this.address()) != 0;
        }

        @NativeType(value="VkLogicOp")
        public int logicOp() {
            return VkPipelineColorBlendStateCreateInfo.nlogicOp(this.address());
        }

        @NativeType(value="uint32_t")
        public int attachmentCount() {
            return VkPipelineColorBlendStateCreateInfo.nattachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="VkPipelineColorBlendAttachmentState const *")
        public VkPipelineColorBlendAttachmentState.Buffer pAttachments() {
            return VkPipelineColorBlendStateCreateInfo.npAttachments(this.address());
        }

        @NativeType(value="float[4]")
        public FloatBuffer blendConstants() {
            return VkPipelineColorBlendStateCreateInfo.nblendConstants(this.address());
        }

        public float blendConstants(int index) {
            return VkPipelineColorBlendStateCreateInfo.nblendConstants(this.address(), index);
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineColorBlendStateCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineColorBlendStateCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkPipelineColorBlendStateCreateFlags") int value) {
            VkPipelineColorBlendStateCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer logicOpEnable(@NativeType(value="VkBool32") boolean value) {
            VkPipelineColorBlendStateCreateInfo.nlogicOpEnable(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer logicOp(@NativeType(value="VkLogicOp") int value) {
            VkPipelineColorBlendStateCreateInfo.nlogicOp(this.address(), value);
            return this;
        }

        public Buffer pAttachments(@Nullable @NativeType(value="VkPipelineColorBlendAttachmentState const *") VkPipelineColorBlendAttachmentState.Buffer value) {
            VkPipelineColorBlendStateCreateInfo.npAttachments(this.address(), value);
            return this;
        }

        public Buffer blendConstants(@NativeType(value="float[4]") FloatBuffer value) {
            VkPipelineColorBlendStateCreateInfo.nblendConstants(this.address(), value);
            return this;
        }

        public Buffer blendConstants(int index, float value) {
            VkPipelineColorBlendStateCreateInfo.nblendConstants(this.address(), index, value);
            return this;
        }
    }
}

