/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineColorBlendAttachmentState
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BLENDENABLE;
    public static final int SRCCOLORBLENDFACTOR;
    public static final int DSTCOLORBLENDFACTOR;
    public static final int COLORBLENDOP;
    public static final int SRCALPHABLENDFACTOR;
    public static final int DSTALPHABLENDFACTOR;
    public static final int ALPHABLENDOP;
    public static final int COLORWRITEMASK;

    VkPipelineColorBlendAttachmentState(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkPipelineColorBlendAttachmentState(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPipelineColorBlendAttachmentState.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkBool32")
    public boolean blendEnable() {
        return VkPipelineColorBlendAttachmentState.nblendEnable(this.address()) != 0;
    }

    @NativeType(value="VkBlendFactor")
    public int srcColorBlendFactor() {
        return VkPipelineColorBlendAttachmentState.nsrcColorBlendFactor(this.address());
    }

    @NativeType(value="VkBlendFactor")
    public int dstColorBlendFactor() {
        return VkPipelineColorBlendAttachmentState.ndstColorBlendFactor(this.address());
    }

    @NativeType(value="VkBlendOp")
    public int colorBlendOp() {
        return VkPipelineColorBlendAttachmentState.ncolorBlendOp(this.address());
    }

    @NativeType(value="VkBlendFactor")
    public int srcAlphaBlendFactor() {
        return VkPipelineColorBlendAttachmentState.nsrcAlphaBlendFactor(this.address());
    }

    @NativeType(value="VkBlendFactor")
    public int dstAlphaBlendFactor() {
        return VkPipelineColorBlendAttachmentState.ndstAlphaBlendFactor(this.address());
    }

    @NativeType(value="VkBlendOp")
    public int alphaBlendOp() {
        return VkPipelineColorBlendAttachmentState.nalphaBlendOp(this.address());
    }

    @NativeType(value="VkColorComponentFlags")
    public int colorWriteMask() {
        return VkPipelineColorBlendAttachmentState.ncolorWriteMask(this.address());
    }

    public VkPipelineColorBlendAttachmentState blendEnable(@NativeType(value="VkBool32") boolean value) {
        VkPipelineColorBlendAttachmentState.nblendEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPipelineColorBlendAttachmentState srcColorBlendFactor(@NativeType(value="VkBlendFactor") int value) {
        VkPipelineColorBlendAttachmentState.nsrcColorBlendFactor(this.address(), value);
        return this;
    }

    public VkPipelineColorBlendAttachmentState dstColorBlendFactor(@NativeType(value="VkBlendFactor") int value) {
        VkPipelineColorBlendAttachmentState.ndstColorBlendFactor(this.address(), value);
        return this;
    }

    public VkPipelineColorBlendAttachmentState colorBlendOp(@NativeType(value="VkBlendOp") int value) {
        VkPipelineColorBlendAttachmentState.ncolorBlendOp(this.address(), value);
        return this;
    }

    public VkPipelineColorBlendAttachmentState srcAlphaBlendFactor(@NativeType(value="VkBlendFactor") int value) {
        VkPipelineColorBlendAttachmentState.nsrcAlphaBlendFactor(this.address(), value);
        return this;
    }

    public VkPipelineColorBlendAttachmentState dstAlphaBlendFactor(@NativeType(value="VkBlendFactor") int value) {
        VkPipelineColorBlendAttachmentState.ndstAlphaBlendFactor(this.address(), value);
        return this;
    }

    public VkPipelineColorBlendAttachmentState alphaBlendOp(@NativeType(value="VkBlendOp") int value) {
        VkPipelineColorBlendAttachmentState.nalphaBlendOp(this.address(), value);
        return this;
    }

    public VkPipelineColorBlendAttachmentState colorWriteMask(@NativeType(value="VkColorComponentFlags") int value) {
        VkPipelineColorBlendAttachmentState.ncolorWriteMask(this.address(), value);
        return this;
    }

    public VkPipelineColorBlendAttachmentState set(boolean blendEnable, int srcColorBlendFactor, int dstColorBlendFactor, int colorBlendOp, int srcAlphaBlendFactor, int dstAlphaBlendFactor, int alphaBlendOp, int colorWriteMask) {
        this.blendEnable(blendEnable);
        this.srcColorBlendFactor(srcColorBlendFactor);
        this.dstColorBlendFactor(dstColorBlendFactor);
        this.colorBlendOp(colorBlendOp);
        this.srcAlphaBlendFactor(srcAlphaBlendFactor);
        this.dstAlphaBlendFactor(dstAlphaBlendFactor);
        this.alphaBlendOp(alphaBlendOp);
        this.colorWriteMask(colorWriteMask);
        return this;
    }

    public VkPipelineColorBlendAttachmentState set(VkPipelineColorBlendAttachmentState src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineColorBlendAttachmentState malloc() {
        return VkPipelineColorBlendAttachmentState.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPipelineColorBlendAttachmentState calloc() {
        return VkPipelineColorBlendAttachmentState.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPipelineColorBlendAttachmentState create() {
        return new VkPipelineColorBlendAttachmentState(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPipelineColorBlendAttachmentState create(long address) {
        return new VkPipelineColorBlendAttachmentState(address, null);
    }

    @Nullable
    public static VkPipelineColorBlendAttachmentState createSafe(long address) {
        return address == 0L ? null : VkPipelineColorBlendAttachmentState.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkPipelineColorBlendAttachmentState.create(VkPipelineColorBlendAttachmentState.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPipelineColorBlendAttachmentState.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkPipelineColorBlendAttachmentState.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPipelineColorBlendAttachmentState.create(address, capacity);
    }

    public static VkPipelineColorBlendAttachmentState mallocStack() {
        return VkPipelineColorBlendAttachmentState.mallocStack(MemoryStack.stackGet());
    }

    public static VkPipelineColorBlendAttachmentState callocStack() {
        return VkPipelineColorBlendAttachmentState.callocStack(MemoryStack.stackGet());
    }

    public static VkPipelineColorBlendAttachmentState mallocStack(MemoryStack stack) {
        return VkPipelineColorBlendAttachmentState.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineColorBlendAttachmentState callocStack(MemoryStack stack) {
        return VkPipelineColorBlendAttachmentState.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPipelineColorBlendAttachmentState.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPipelineColorBlendAttachmentState.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineColorBlendAttachmentState.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineColorBlendAttachmentState.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nblendEnable(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BLENDENABLE);
    }

    public static int nsrcColorBlendFactor(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SRCCOLORBLENDFACTOR);
    }

    public static int ndstColorBlendFactor(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DSTCOLORBLENDFACTOR);
    }

    public static int ncolorBlendOp(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COLORBLENDOP);
    }

    public static int nsrcAlphaBlendFactor(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SRCALPHABLENDFACTOR);
    }

    public static int ndstAlphaBlendFactor(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DSTALPHABLENDFACTOR);
    }

    public static int nalphaBlendOp(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ALPHABLENDOP);
    }

    public static int ncolorWriteMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COLORWRITEMASK);
    }

    public static void nblendEnable(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BLENDENABLE, value);
    }

    public static void nsrcColorBlendFactor(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SRCCOLORBLENDFACTOR, value);
    }

    public static void ndstColorBlendFactor(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DSTCOLORBLENDFACTOR, value);
    }

    public static void ncolorBlendOp(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COLORBLENDOP, value);
    }

    public static void nsrcAlphaBlendFactor(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SRCALPHABLENDFACTOR, value);
    }

    public static void ndstAlphaBlendFactor(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DSTALPHABLENDFACTOR, value);
    }

    public static void nalphaBlendOp(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ALPHABLENDOP, value);
    }

    public static void ncolorWriteMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COLORWRITEMASK, value);
    }

    static {
        Struct.Layout layout = VkPipelineColorBlendAttachmentState.__struct(VkPipelineColorBlendAttachmentState.__member(4), VkPipelineColorBlendAttachmentState.__member(4), VkPipelineColorBlendAttachmentState.__member(4), VkPipelineColorBlendAttachmentState.__member(4), VkPipelineColorBlendAttachmentState.__member(4), VkPipelineColorBlendAttachmentState.__member(4), VkPipelineColorBlendAttachmentState.__member(4), VkPipelineColorBlendAttachmentState.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BLENDENABLE = layout.offsetof(0);
        SRCCOLORBLENDFACTOR = layout.offsetof(1);
        DSTCOLORBLENDFACTOR = layout.offsetof(2);
        COLORBLENDOP = layout.offsetof(3);
        SRCALPHABLENDFACTOR = layout.offsetof(4);
        DSTALPHABLENDFACTOR = layout.offsetof(5);
        ALPHABLENDOP = layout.offsetof(6);
        COLORWRITEMASK = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineColorBlendAttachmentState, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPipelineColorBlendAttachmentState newInstance(long address) {
            return new VkPipelineColorBlendAttachmentState(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkBool32")
        public boolean blendEnable() {
            return VkPipelineColorBlendAttachmentState.nblendEnable(this.address()) != 0;
        }

        @NativeType(value="VkBlendFactor")
        public int srcColorBlendFactor() {
            return VkPipelineColorBlendAttachmentState.nsrcColorBlendFactor(this.address());
        }

        @NativeType(value="VkBlendFactor")
        public int dstColorBlendFactor() {
            return VkPipelineColorBlendAttachmentState.ndstColorBlendFactor(this.address());
        }

        @NativeType(value="VkBlendOp")
        public int colorBlendOp() {
            return VkPipelineColorBlendAttachmentState.ncolorBlendOp(this.address());
        }

        @NativeType(value="VkBlendFactor")
        public int srcAlphaBlendFactor() {
            return VkPipelineColorBlendAttachmentState.nsrcAlphaBlendFactor(this.address());
        }

        @NativeType(value="VkBlendFactor")
        public int dstAlphaBlendFactor() {
            return VkPipelineColorBlendAttachmentState.ndstAlphaBlendFactor(this.address());
        }

        @NativeType(value="VkBlendOp")
        public int alphaBlendOp() {
            return VkPipelineColorBlendAttachmentState.nalphaBlendOp(this.address());
        }

        @NativeType(value="VkColorComponentFlags")
        public int colorWriteMask() {
            return VkPipelineColorBlendAttachmentState.ncolorWriteMask(this.address());
        }

        public Buffer blendEnable(@NativeType(value="VkBool32") boolean value) {
            VkPipelineColorBlendAttachmentState.nblendEnable(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer srcColorBlendFactor(@NativeType(value="VkBlendFactor") int value) {
            VkPipelineColorBlendAttachmentState.nsrcColorBlendFactor(this.address(), value);
            return this;
        }

        public Buffer dstColorBlendFactor(@NativeType(value="VkBlendFactor") int value) {
            VkPipelineColorBlendAttachmentState.ndstColorBlendFactor(this.address(), value);
            return this;
        }

        public Buffer colorBlendOp(@NativeType(value="VkBlendOp") int value) {
            VkPipelineColorBlendAttachmentState.ncolorBlendOp(this.address(), value);
            return this;
        }

        public Buffer srcAlphaBlendFactor(@NativeType(value="VkBlendFactor") int value) {
            VkPipelineColorBlendAttachmentState.nsrcAlphaBlendFactor(this.address(), value);
            return this;
        }

        public Buffer dstAlphaBlendFactor(@NativeType(value="VkBlendFactor") int value) {
            VkPipelineColorBlendAttachmentState.ndstAlphaBlendFactor(this.address(), value);
            return this;
        }

        public Buffer alphaBlendOp(@NativeType(value="VkBlendOp") int value) {
            VkPipelineColorBlendAttachmentState.nalphaBlendOp(this.address(), value);
            return this;
        }

        public Buffer colorWriteMask(@NativeType(value="VkColorComponentFlags") int value) {
            VkPipelineColorBlendAttachmentState.ncolorWriteMask(this.address(), value);
            return this;
        }
    }
}

