/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineCacheCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int INITIALDATASIZE;
    public static final int PINITIALDATA;

    VkPipelineCacheCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkPipelineCacheCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPipelineCacheCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineCacheCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineCacheCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkPipelineCacheCreateFlags")
    public int flags() {
        return VkPipelineCacheCreateInfo.nflags(this.address());
    }

    @NativeType(value="size_t")
    public long initialDataSize() {
        return VkPipelineCacheCreateInfo.ninitialDataSize(this.address());
    }

    @Nullable
    @NativeType(value="void const *")
    public ByteBuffer pInitialData() {
        return VkPipelineCacheCreateInfo.npInitialData(this.address());
    }

    public VkPipelineCacheCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineCacheCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPipelineCacheCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkPipelineCacheCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPipelineCacheCreateInfo flags(@NativeType(value="VkPipelineCacheCreateFlags") int value) {
        VkPipelineCacheCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkPipelineCacheCreateInfo pInitialData(@Nullable @NativeType(value="void const *") ByteBuffer value) {
        VkPipelineCacheCreateInfo.npInitialData(this.address(), value);
        return this;
    }

    public VkPipelineCacheCreateInfo set(int sType, long pNext, int flags, @Nullable ByteBuffer pInitialData) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pInitialData(pInitialData);
        return this;
    }

    public VkPipelineCacheCreateInfo set(VkPipelineCacheCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineCacheCreateInfo malloc() {
        return VkPipelineCacheCreateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPipelineCacheCreateInfo calloc() {
        return VkPipelineCacheCreateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPipelineCacheCreateInfo create() {
        return new VkPipelineCacheCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPipelineCacheCreateInfo create(long address) {
        return new VkPipelineCacheCreateInfo(address, null);
    }

    @Nullable
    public static VkPipelineCacheCreateInfo createSafe(long address) {
        return address == 0L ? null : VkPipelineCacheCreateInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkPipelineCacheCreateInfo.create(VkPipelineCacheCreateInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPipelineCacheCreateInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkPipelineCacheCreateInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPipelineCacheCreateInfo.create(address, capacity);
    }

    public static VkPipelineCacheCreateInfo mallocStack() {
        return VkPipelineCacheCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkPipelineCacheCreateInfo callocStack() {
        return VkPipelineCacheCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkPipelineCacheCreateInfo mallocStack(MemoryStack stack) {
        return VkPipelineCacheCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineCacheCreateInfo callocStack(MemoryStack stack) {
        return VkPipelineCacheCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPipelineCacheCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPipelineCacheCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineCacheCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineCacheCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static long ninitialDataSize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)INITIALDATASIZE);
    }

    @Nullable
    public static ByteBuffer npInitialData(long struct) {
        return MemoryUtil.memByteBufferSafe(MemoryUtil.memGetAddress(struct + (long)PINITIALDATA), (int)VkPipelineCacheCreateInfo.ninitialDataSize(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void ninitialDataSize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)INITIALDATASIZE, value);
    }

    public static void npInitialData(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PINITIALDATA, MemoryUtil.memAddressSafe(value));
        VkPipelineCacheCreateInfo.ninitialDataSize(struct, value == null ? 0L : (long)value.remaining());
    }

    public static void validate(long struct) {
        if (VkPipelineCacheCreateInfo.ninitialDataSize(struct) != 0L) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PINITIALDATA));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkPipelineCacheCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkPipelineCacheCreateInfo.__struct(VkPipelineCacheCreateInfo.__member(4), VkPipelineCacheCreateInfo.__member(POINTER_SIZE), VkPipelineCacheCreateInfo.__member(4), VkPipelineCacheCreateInfo.__member(POINTER_SIZE), VkPipelineCacheCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        INITIALDATASIZE = layout.offsetof(3);
        PINITIALDATA = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineCacheCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPipelineCacheCreateInfo newInstance(long address) {
            return new VkPipelineCacheCreateInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineCacheCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineCacheCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkPipelineCacheCreateFlags")
        public int flags() {
            return VkPipelineCacheCreateInfo.nflags(this.address());
        }

        @NativeType(value="size_t")
        public long initialDataSize() {
            return VkPipelineCacheCreateInfo.ninitialDataSize(this.address());
        }

        @Nullable
        @NativeType(value="void const *")
        public ByteBuffer pInitialData() {
            return VkPipelineCacheCreateInfo.npInitialData(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineCacheCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineCacheCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkPipelineCacheCreateFlags") int value) {
            VkPipelineCacheCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pInitialData(@Nullable @NativeType(value="void const *") ByteBuffer value) {
            VkPipelineCacheCreateInfo.npInitialData(this.address(), value);
            return this;
        }
    }
}

